/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushManager {
    private static final Log LOG;
    private static final int CONNECT_TIMEOUT = 10000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.PushManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void acceptPushUpload(final String string, final int n, final String string2, final boolean bl, final boolean bl2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("acceptPushUp ip:" + string + " port:" + n + " FW:" + bl2));
        }
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (string2 == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fileManager = RouterService.getFileManager();
        if (fileManager.getNumFiles() < 1 && fileManager.getNumIncompleteFiles() < 1) {
            return;
        }
        ManagedThread managedThread = new ManagedThread("PushUploadThread"){

            public void managedRun() {
                Socket socket;
                block22: {
                    socket = null;
                    try {
                        try {
                            socket = bl2 ? new UDPConnection(string, n) : Sockets.connect(string, n, 10000);
                            OutputStream outputStream = socket.getOutputStream();
                            String string3 = "GIV 0:" + string2 + "/file\n\n";
                            outputStream.write(string3.getBytes());
                            outputStream.flush();
                            socket.setSoTimeout(30000);
                            String string22 = IOUtils.readWord(socket.getInputStream(), 4);
                            if (bl2) {
                                UploadStat.FW_FW_SUCCESS.incrementStat();
                            }
                            if (string22.equals("GET")) {
                                UploadStat.PUSHED_GET.incrementStat();
                                RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, socket, bl);
                                break block22;
                            }
                            if (string22.equals("HEAD")) {
                                UploadStat.PUSHED_HEAD.incrementStat();
                                RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, socket, bl);
                                break block22;
                            }
                            UploadStat.PUSHED_UNKNOWN.incrementStat();
                            throw new IOException();
                        }
                        catch (IOException iOException) {
                            if (bl2) {
                                UploadStat.FW_FW_FAILURE.incrementStat();
                            }
                            UploadStat.PUSH_FAILED.incrementStat();
                        }
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            try {
                                socket.getInputStream().close();
                            }
                            catch (IOException iOException) {}
                            try {
                                socket.getOutputStream().close();
                            }
                            catch (IOException iOException) {}
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                if (socket != null) {
                    try {
                        socket.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        socket.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        managedThread.setDaemon(true);
        managedThread.start();
    }
}

