/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RequeryDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadManager
implements BandwidthTracker {
    private static final Log LOG;
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private DownloadCallback callback;
    private MessageRouter router;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();
    private volatile boolean guiInit = false;
    private final Map UDP_FAILOVER = new TreeMap(new GUID.GUIDByteComparator());
    private final ProcessingQueue FAILOVERS = new ProcessingQueue("udp failovers");
    private static long UDP_PUSH_FAILTIME;
    public static long TIME_BETWEEN_REQUERIES;
    private long lastRequeryTime = 0L;
    private List querySentMDs = new ArrayList();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private Runnable _waitingPump;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.DownloadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        UDP_PUSH_FAILTIME = 5000L;
        TIME_BETWEEN_REQUERIES = 2700000L;
    }

    public void initialize() {
        this.initialize(RouterService.getCallback(), RouterService.getMessageRouter(), RouterService.getFileManager());
    }

    protected void initialize(DownloadCallback downloadCallback, MessageRouter messageRouter, FileManager fileManager) {
        this.callback = downloadCallback;
        this.router = messageRouter;
        this.fileManager = fileManager;
        this.scheduleWaitingPump();
    }

    public void postGuiInit() {
        File file = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File file2 = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        if (!this.readSnapshot(file)) {
            LOG.debug((Object)"Reading real downloads.dat failed");
            if (this.readSnapshot(file2)) {
                LOG.debug((Object)"Reading backup downloads.bak succeeded.");
                this.copyBackupToReal();
            } else if (file2.exists() || file.exists()) {
                LOG.debug((Object)"Reading both downloads files failed.");
                MessageService.showError("DOWNLOAD_COULD_NOT_READ_SNAPSHOT");
            }
        } else {
            LOG.debug((Object)"Reading downloads.dat worked!");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (DownloadManager.this.downloadsInProgress() > 0 && !DownloadManager.this.writeSnapshot()) {
                    DownloadManager.this.copyBackupToReal();
                }
            }
        };
        RouterService.schedule(runnable, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME);
        this.guiInit = true;
    }

    public boolean isGUIInitd() {
        return this.guiInit;
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            public void run() {
                DownloadManager.this.pumpDownloads();
            }
        };
        RouterService.schedule(this._waitingPump, 1000L, 1000L);
    }

    private synchronized void pumpDownloads() {
        int n = 1;
        Iterator iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            if (managedDownloader.isAlive()) continue;
            if (managedDownloader.isCancelled() || managedDownloader.isCompleted()) {
                iterator.remove();
                this.cleanupCompletedDownload(managedDownloader, false);
                continue;
            }
            if (this.hasFreeSlot() && (managedDownloader.hasNewSources() || managedDownloader.getRemainingStateTime() <= 0)) {
                iterator.remove();
                this.active.add(managedDownloader);
                managedDownloader.startDownload();
                continue;
            }
            if (!managedDownloader.isPaused()) {
                managedDownloader.setInactivePriority(n++);
            }
            managedDownloader.handleInactivity();
        }
    }

    private synchronized void copyBackupToReal() {
        File file = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        File file2 = SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue();
        file.delete();
        CommonUtils.copy(file2, file);
    }

    public boolean isIncomplete(URN uRN) {
        return this.incompleteFileManager.getFileForUrn(uRN) != null;
    }

    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    public synchronized int getNumIndividualDownloaders() {
        int n = 0;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            n += managedDownloader.getNumDownloaders();
        }
        return n;
    }

    public synchronized int getNumActiveDownloads() {
        return this.active.size();
    }

    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedDownloader getDownloaderForURN(URN uRN) {
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            ManagedDownloader managedDownloader;
            Iterator iterator = this.active.iterator();
            while (iterator.hasNext()) {
                managedDownloader = (ManagedDownloader)iterator.next();
                if (managedDownloader.getSHA1Urn() == null || !uRN.equals(managedDownloader.getSHA1Urn())) continue;
                return managedDownloader;
            }
            iterator = this.waiting.iterator();
            while (iterator.hasNext()) {
                managedDownloader = (ManagedDownloader)iterator.next();
                if (managedDownloader.getSHA1Urn() == null || !uRN.equals(managedDownloader.getSHA1Urn())) continue;
                return managedDownloader;
            }
        }
        return null;
    }

    public synchronized boolean isGuidForQueryDownloading(GUID gUID) {
        GUID gUID2;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            gUID2 = ((ManagedDownloader)iterator.next()).getQueryGUID();
            if (gUID2 == null || !gUID2.equals(gUID)) continue;
            return true;
        }
        iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            gUID2 = ((ManagedDownloader)iterator.next()).getQueryGUID();
            if (gUID2 == null || !gUID2.equals(gUID)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllDownloads() {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.active.size() + this.waiting.size());
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)object.next();
            managedDownloader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeSnapshot() {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.active.size() + this.waiting.size());
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
        }
        object = SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue();
        SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue().delete();
        ((File)object).renameTo(SharingSettings.DOWNLOAD_SNAPSHOT_BACKUP_FILE.getValue());
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(SharingSettings.DOWNLOAD_SNAPSHOT_FILE.getValue())));
            objectOutputStream.writeObject(arrayList);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                objectOutputStream.writeObject(this.incompleteFileManager);
            }
            objectOutputStream.flush();
            if (objectOutputStream == null) return true;
            try {
                objectOutputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        catch (IOException iOException) {
            try {
                if (objectOutputStream == null) return false;
            }
            catch (Throwable throwable) {
                if (objectOutputStream == null) throw throwable;
                try {
                    objectOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                objectOutputStream.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean readSnapshot(File file) {
        Object object;
        LinkedList linkedList = null;
        try {
            object = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            linkedList = (LinkedList)((ObjectInputStream)object).readObject();
            this.incompleteFileManager = (IncompleteFileManager)((ObjectInputStream)object).readObject();
        }
        catch (Throwable throwable) {
            LOG.error((Object)"Unable to read download file", throwable);
            return false;
        }
        linkedList = new LinkedList(new HashSet(linkedList));
        try {
            object = linkedList.iterator();
            while (true) {
                if (!object.hasNext()) {
                    return true;
                }
                ManagedDownloader managedDownloader = (ManagedDownloader)object.next();
                if (managedDownloader instanceof RequeryDownloader) continue;
                this.waiting.add(managedDownloader);
                managedDownloader.initialize(this, this.fileManager, this.callback(managedDownloader));
                this.callback(managedDownloader).addDownload(managedDownloader);
            }
        }
        catch (ClassCastException classCastException) {
            if (!this.incompleteFileManager.initialPurge(DownloadManager.getActiveDownloadFiles(linkedList))) return false;
            this.writeSnapshot();
            return false;
        }
        finally {
            if (this.incompleteFileManager.initialPurge(DownloadManager.getActiveDownloadFiles(linkedList))) {
                this.writeSnapshot();
            }
        }
    }

    private static Collection getActiveDownloadFiles(List list) {
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Downloader downloader = (Downloader)iterator.next();
            File file = downloader.getFile();
            if (file == null) continue;
            try {
                arrayList.add(FileUtils.getCanonicalFile(file));
            }
            catch (IOException iOException) {
                arrayList.add(file.getAbsoluteFile());
            }
        }
        return arrayList;
    }

    public synchronized Downloader download(RemoteFileDesc[] remoteFileDescArray, List list, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        String string2 = this.getFileName(remoteFileDescArray, string);
        if (this.conflicts(remoteFileDescArray, string2)) {
            throw new SaveLocationException(10, new File(string2 != null ? string2 : ""));
        }
        this.incompleteFileManager.purge();
        ManagedDownloader managedDownloader = new ManagedDownloader(remoteFileDescArray, this.incompleteFileManager, gUID, file, string, bl);
        this.initializeDownload(managedDownloader);
        managedDownloader.addDownload(list, false);
        return managedDownloader;
    }

    public synchronized Downloader download(File file) throws CantResumeException, SaveLocationException {
        if (this.conflictsWithIncompleteFile(file)) {
            throw new SaveLocationException(10, file);
        }
        this.incompleteFileManager.purge();
        ResumeDownloader resumeDownloader = null;
        try {
            file = FileUtils.getCanonicalFile(file);
            String string = IncompleteFileManager.getCompletedName(file);
            int n = ByteOrder.long2int(IncompleteFileManager.getCompletedSize(file));
            resumeDownloader = new ResumeDownloader(this.incompleteFileManager, file, string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantResumeException(file.getName());
        }
        catch (IOException iOException) {
            throw new CantResumeException(file.getName());
        }
        this.initializeDownload(resumeDownloader);
        return resumeDownloader;
    }

    private void initializeDownload(ManagedDownloader managedDownloader) {
        managedDownloader.initialize(this, this.fileManager, this.callback(managedDownloader));
        this.waiting.add(managedDownloader);
        this.callback(managedDownloader).addDownload(managedDownloader);
        RouterService.schedule(new Runnable(){

            public void run() {
                DownloadManager.this.writeSnapshot();
            }
        }, 0L, 0L);
    }

    private DownloadCallback callback(ManagedDownloader managedDownloader) {
        return this.callback;
    }

    private boolean conflicts(RemoteFileDesc[] remoteFileDescArray, String string) {
        URN uRN = null;
        int n = 0;
        while (n < remoteFileDescArray.length && uRN == null) {
            uRN = remoteFileDescArray[0].getSHA1Urn();
            ++n;
        }
        return this.conflicts(uRN, string, remoteFileDescArray[0].getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(URN uRN, String string, int n) {
        if (uRN == null && n == 0) {
            return false;
        }
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            return this.conflicts(this.active.iterator(), uRN, string, n) || this.conflicts(this.waiting.iterator(), uRN, string, n);
        }
    }

    private boolean conflicts(Iterator iterator, URN uRN, String string, int n) {
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            if (!managedDownloader.conflicts(uRN, string, n)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isSaveLocationTaken(File file) {
        return this.isSaveLocationTaken(this.active.iterator(), file) || this.isSaveLocationTaken(this.waiting.iterator(), file);
    }

    private boolean isSaveLocationTaken(Iterator iterator, File file) {
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            if (!file.equals(managedDownloader.getSaveFile())) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean conflictsWithIncompleteFile(File file) {
        return this.conflictsWithIncompleteFile(this.active.iterator(), file) || this.conflictsWithIncompleteFile(this.waiting.iterator(), file);
    }

    private boolean conflictsWithIncompleteFile(Iterator iterator, File file) {
        while (iterator.hasNext()) {
            ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
            if (!managedDownloader.conflictsWithIncompleteFile(file)) continue;
            return true;
        }
        return false;
    }

    public void handleQueryReply(QueryReply queryReply) {
        HostData hostData;
        List list;
        if (queryReply.calculateQualityOfService(!RouterService.acceptedIncomingConnection()) < 1) {
            return;
        }
        try {
            list = queryReply.getResultsAsList();
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        this.addDownloadWithResponses(list, hostData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List list, HostData hostData) {
        if (list == null) {
            throw new NullPointerException("null responses");
        }
        if (hostData == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList arrayList = new ArrayList(this.active.size() + this.waiting.size());
        Object object = this;
        synchronized (object) {
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        object = list.iterator();
        block3: while (object.hasNext()) {
            Response response = (Response)object.next();
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                if (!managedDownloader.addDownload(remoteFileDesc, true)) continue;
                Set set = response.getLocations();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Endpoint endpoint = (Endpoint)iterator2.next();
                    managedDownloader.addDownload(new RemoteFileDesc(remoteFileDesc, endpoint), false);
                }
                continue block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDownload(Socket socket) {
        Thread.currentThread().setName("PushDownloadThread");
        try {
            Object object;
            Object object2;
            GIVLine gIVLine = DownloadManager.parseGIV(socket);
            String string = gIVLine.file;
            int n = gIVLine.index;
            byte[] byArray = gIVLine.clientGUID;
            Object object3 = this.UDP_FAILOVER;
            synchronized (object3) {
                object2 = byArray;
                object = (Set)this.UDP_FAILOVER.get(object2);
                if (object != null) {
                    object.remove(string);
                    if (object.isEmpty()) {
                        this.UDP_FAILOVER.remove(object2);
                    }
                }
            }
            object3 = this;
            synchronized (object3) {
                if (BrowseHostHandler.handlePush(n, new GUID(byArray), socket)) {
                    return;
                }
                object2 = this.active.iterator();
                while (object2.hasNext()) {
                    object = (ManagedDownloader)object2.next();
                    if (!((ManagedDownloader)object).acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
                object2 = this.waiting.iterator();
                while (object2.hasNext()) {
                    object = (ManagedDownloader)object2.next();
                    if (!((ManagedDownloader)object).acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {}
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private boolean hasFreeSlot() {
        return this.active.size() < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    public synchronized void remove(ManagedDownloader managedDownloader, boolean bl) {
        this.active.remove(managedDownloader);
        this.waiting.remove(managedDownloader);
        if (bl) {
            this.cleanupCompletedDownload(managedDownloader, true);
        } else {
            this.waiting.add(managedDownloader);
        }
    }

    public synchronized void bumpPriority(Downloader downloader, boolean bl, int n) {
        int n2 = this.waiting.indexOf(downloader);
        if (n2 == -1) {
            return;
        }
        if (bl && n2 != 0) {
            this.waiting.remove(n2);
            if (n > n2) {
                n = n2;
            }
            if (n != 0) {
                this.waiting.add(n2 - n, downloader);
            } else {
                this.waiting.add(0, downloader);
            }
        } else if (!bl && n2 != this.waiting.size() - 1) {
            this.waiting.remove(n2);
            if (n != 0) {
                if ((n += n2) > this.waiting.size()) {
                    n = this.waiting.size();
                }
                this.waiting.add(n, downloader);
            } else {
                this.waiting.add(downloader);
            }
        }
    }

    private void cleanupCompletedDownload(ManagedDownloader managedDownloader, boolean bl) {
        this.querySentMDs.remove(managedDownloader);
        managedDownloader.finish();
        if (managedDownloader.getQueryGUID() != null) {
            this.router.downloadFinished(managedDownloader.getQueryGUID());
        }
        this.callback(managedDownloader).removeDownload(managedDownloader);
        if (bl) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback(managedDownloader).downloadsComplete();
        }
    }

    public synchronized boolean sendQuery(ManagedDownloader managedDownloader, QueryRequest queryRequest) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery():" + queryRequest.getQuery()));
        }
        Assert.that(this.waiting.contains(managedDownloader), "Unknown or non-waiting MD trying to send requery.");
        boolean bl = GUID.isLimeRequeryGUID(queryRequest.getGUID());
        long l = System.currentTimeMillis() - this.lastRequeryTime;
        if (bl && l <= TIME_BETWEEN_REQUERIES) {
            return false;
        }
        if (this.querySentMDs.size() >= this.waiting.size()) {
            LOG.trace((Object)"DM.sendQuery(): reseting query sent queue");
            this.querySentMDs.clear();
        }
        if (this.querySentMDs.contains(managedDownloader)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("DM.sendQuery(): out of turn:" + queryRequest.getQuery()));
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DM.sendQuery(): requery allowed:" + queryRequest.getQuery()));
        }
        this.querySentMDs.add(managedDownloader);
        this.lastRequeryTime = System.currentTimeMillis();
        this.router.sendDynamicQuery(queryRequest);
        return true;
    }

    private boolean sendPushMulticast(RemoteFileDesc remoteFileDesc, byte[] byArray) {
        if (remoteFileDesc.isReplyToMulticast()) {
            byte[] byArray2 = RouterService.getNonForcedAddress();
            int n = RouterService.getNonForcedPort();
            if (NetworkUtils.isValidAddress(byArray2) && NetworkUtils.isValidPort(n)) {
                PushRequest pushRequest = new PushRequest(byArray, 1, remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), byArray2, n, 3);
                this.router.sendMulticastPushRequest(pushRequest);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Sending push request through multicast " + pushRequest));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendPushUDP(RemoteFileDesc var1_1, byte[] var2_2) {
        var3_3 = new PushRequest(var2_2, 2, var1_1.getClientGUID(), var1_1.getIndex(), RouterService.getAddress(), RouterService.getPort(), 2);
        if (DownloadManager.LOG.isInfoEnabled()) {
            DownloadManager.LOG.info((Object)("Sending push request through udp " + var3_3));
        }
        var4_4 = UDPService.instance();
        try {
            try {
                var5_5 = InetAddress.getByName(var1_1.getHost());
                if (!NetworkUtils.isValidAddress(var5_5)) {
                }
                if (NetworkUtils.isValidPort(var1_1.getPort())) {
                    var4_4.send(var3_3, var5_5, var1_1.getPort());
                }
            }
            catch (UnknownHostException v0) {
            }
        }
        finally {
            var7_8 = IPFilter.instance();
            var8_10 = var1_1.getPushProxies();
            var9_12 = var8_10.iterator();
            ** while (var9_12.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            var10_14 = (IpPort)var9_12.next();
            if (!var7_8.allow(var10_14.getAddress())) continue;
            var4_4.send(var3_3, var10_14.getInetAddress(), var10_14.getPort());
            continue;
        }
lbl26:
        // 1 sources

        return true;
    }

    private boolean sendPushTCP(RemoteFileDesc remoteFileDesc, byte[] byArray) {
        int n;
        boolean bl;
        boolean bl2 = bl = remoteFileDesc.supportsFWTransfer() && UDPService.instance().canDoFWT() && !RouterService.acceptedIncomingConnection();
        if (this.sendPushThroughProxies(remoteFileDesc, byArray, bl)) {
            return true;
        }
        if (bl && !RouterService.acceptedIncomingConnection()) {
            return false;
        }
        byte[] byArray2 = RouterService.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(byArray2, n = RouterService.getPort())) {
            return false;
        }
        PushRequest pushRequest = new PushRequest(byArray, ConnectionSettings.TTL.getValue(), remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), byArray2, n);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Sending push request through Gnutella: " + pushRequest));
        }
        try {
            this.router.sendPushRequest(pushRequest);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendPushThroughProxies(RemoteFileDesc remoteFileDesc, byte[] byArray, boolean bl) {
        Set set = remoteFileDesc.getPushProxies();
        if (set.isEmpty()) {
            return false;
        }
        byte[] byArray2 = RouterService.getExternalAddress();
        if (bl && !NetworkUtils.isValidAddress(byArray2)) {
            return false;
        }
        byte[] byArray3 = RouterService.getAddress();
        int n = RouterService.getPort();
        String string = "/gnutella/push-proxy?ServerID=" + Base32.encode(remoteFileDesc.getClientGUID()) + (bl ? "&file=2147483645" : "");
        String string2 = String.valueOf(NetworkUtils.ip2string(bl ? byArray2 : byArray3)) + ":" + n;
        IPFilter iPFilter = IPFilter.instance();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IpPort ipPort = (IpPort)iterator.next();
            if (!iPFilter.allow(ipPort.getAddress())) continue;
            String string3 = ipPort.getAddress();
            int n2 = ipPort.getPort();
            String string4 = "http://" + string3 + ":" + n2 + string;
            HttpClient httpClient = HttpClientManager.getNewClient();
            HeadMethod headMethod = new HeadMethod(string4);
            headMethod.addRequestHeader("X-Node", string2);
            headMethod.addRequestHeader("Cache-Control", "no-cache");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Push Proxy Requesting with: " + string4));
            }
            try {
                try {
                    httpClient.executeMethod((HttpMethod)headMethod);
                    if (headMethod.getStatusCode() == 202) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Succesful push proxy: " + string4));
                        }
                        if (!bl) return true;
                        this.startFWIncomingThread(remoteFileDesc);
                        return true;
                    }
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("Invalid push proxy: " + string4 + ", response: " + headMethod.getStatusCode()));
                }
                finally {
                    if (headMethod != null) {
                        headMethod.releaseConnection();
                    }
                }
            }
            catch (IOException iOException) {
                LOG.warn((Object)"PushProxy request exception", (Throwable)iOException);
            }
        }
        return false;
    }

    private void startFWIncomingThread(final RemoteFileDesc remoteFileDesc) {
        ManagedThread managedThread = new ManagedThread("FWIncoming"){

            public void managedRun() {
                UDPConnection uDPConnection = null;
                try {
                    uDPConnection = new UDPConnection(remoteFileDesc.getHost(), remoteFileDesc.getPort());
                    DownloadStat.FW_FW_SUCCESS.incrementStat();
                    InputStream inputStream = ((Socket)uDPConnection).getInputStream();
                    String string = IOUtils.readWord(inputStream, 4);
                    if (string.equals("GIV")) {
                        DownloadManager.this.acceptDownload(uDPConnection);
                    } else {
                        ((Socket)uDPConnection).close();
                    }
                }
                catch (IOException iOException) {
                    LOG.debug((Object)"failed to establish UDP connection", (Throwable)iOException);
                    if (uDPConnection != null) {
                        try {
                            ((Socket)uDPConnection).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    DownloadStat.FW_FW_FAILURE.incrementStat();
                }
            }
        };
        managedThread.setDaemon(true);
        managedThread.start();
    }

    public void sendPush(RemoteFileDesc remoteFileDesc) {
        this.sendPush(remoteFileDesc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPush(final RemoteFileDesc remoteFileDesc, final Object object) {
        byte[] byArray = RouterService.getAddress();
        int n = RouterService.getPort();
        if (!NetworkUtils.isValidAddress(byArray) || !NetworkUtils.isValidPort(n)) {
            this.notify(object);
            return;
        }
        final byte[] byArray2 = GUID.makeGuid();
        if (this.sendPushMulticast(remoteFileDesc, byArray2)) {
            return;
        }
        if (!RouterService.acceptedIncomingConnection()) {
            if (!UDPService.instance().canDoFWT() || !this.sendPushTCP(remoteFileDesc, byArray2)) {
                this.notify(object);
            }
            return;
        }
        if (!remoteFileDesc.isFromAlternateLocation()) {
            Map map = this.UDP_FAILOVER;
            synchronized (map) {
                byte[] byArray3 = remoteFileDesc.getClientGUID();
                HashSet<String> hashSet = (HashSet<String>)this.UDP_FAILOVER.get(byArray3);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(remoteFileDesc.getFileName());
                this.UDP_FAILOVER.put(byArray3, hashSet);
            }
            RouterService.schedule(new Runnable(){

                public void run() {
                    DownloadManager.this.FAILOVERS.add(new PushFailoverRequestor(remoteFileDesc, byArray2, object));
                }
            }, UDP_PUSH_FAILTIME, 0L);
        }
        this.sendPushUDP(remoteFileDesc, byArray2);
    }

    private static GIVLine parseGIV(Socket socket) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        ByteReader byteReader = new ByteReader(inputStream);
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        String string2 = byteReader.readLine();
        if (string2 == null || !string2.equals("")) {
            throw new IOException();
        }
        try {
            int n = string.indexOf(":");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = string.indexOf("/", n);
            byte[] byArray = GUID.fromHexString(string.substring(n + 1, n3));
            String string3 = URLDecoder.decode(string.substring(n3 + 1));
            return new GIVLine(string3, n2, byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        ArrayList arrayList;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            arrayList = new ArrayList(this.active);
        }
        float f = 0.0f;
        boolean bl = false;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)object.next();
            bl = true;
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            object = this;
            synchronized (object) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMeasuredBandwidth() {
        ArrayList arrayList;
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            arrayList = new ArrayList(this.active);
        }
        float f = 0.0f;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(Object object) {
        if (object == null) {
            return;
        }
        Object object2 = object;
        synchronized (object2) {
            object.notify();
        }
    }

    private String getFileName(RemoteFileDesc[] remoteFileDescArray, String string) {
        int n = 0;
        while (n < remoteFileDescArray.length && string == null) {
            string = remoteFileDescArray[n].getFileName();
            ++n;
        }
        return CommonUtils.convertFileName(SharingSettings.getSaveDirectory(), string);
    }

    private static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String string, int n, byte[] byArray) {
            this.file = string;
            this.index = n;
            this.clientGUID = byArray;
        }
    }

    private class PushFailoverRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final Object _toNotify;

        public PushFailoverRequestor(RemoteFileDesc remoteFileDesc, byte[] byArray, Object object) {
            this._file = remoteFileDesc;
            this._guid = byArray;
            this._toNotify = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            byte[] byArray = this._file.getClientGUID();
            Map map = DownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                Set set = (Set)DownloadManager.this.UDP_FAILOVER.get(byArray);
                if (set != null && set.contains(this._file.getFileName())) {
                    bl = true;
                    set.remove(this._file.getFileName());
                    if (set.isEmpty()) {
                        DownloadManager.this.UDP_FAILOVER.remove(byArray);
                    }
                }
            }
            if (bl && !DownloadManager.this.sendPushTCP(this._file, this._guid)) {
                DownloadManager.this.notify(this._toNotify);
            }
        }
    }
}

