/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class LimeXMLDocumentHelper {
    private static boolean debugOn = false;

    private LimeXMLDocumentHelper() {
    }

    public static List getDocuments(String string, int n) {
        int n2;
        if (string == null || string.equals("")) {
            return DataUtils.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        DOMParser dOMParser = new DOMParser();
        int n3 = n2 = string.indexOf("<?xml");
        String string2 = "";
        boolean bl = false;
        while (!bl) {
            n2 = n3;
            if (n2 == -1) {
                bl = true;
                continue;
            }
            n3 = string.indexOf("<?xml", n2 + 1);
            string2 = n3 > 0 ? string.substring(n2, n3) : string.substring(n2);
            LimeXMLDocument[] limeXMLDocumentArray = new LimeXMLDocument[n];
            Element element = LimeXMLDocumentHelper.getDOMTree(dOMParser, string2);
            if (element == null) {
                arrayList.add(null);
                continue;
            }
            List list = LimeXMLUtils.getElements(element.getChildNodes());
            int n4 = list.size();
            int n5 = 0;
            while (n5 < n4) {
                block11: {
                    int n6;
                    Node node = (Node)list.get(n5);
                    String string3 = LimeXMLDocumentHelper.getAttributeValue(node, "index");
                    try {
                        n6 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block11;
                    }
                    LimeXMLDocument limeXMLDocument = null;
                    try {
                        limeXMLDocument = new LimeXMLDocument(node, element);
                    }
                    catch (IOException iOException) {
                        break block11;
                    }
                    catch (SchemaNotFoundException schemaNotFoundException) {
                        break block11;
                    }
                    if (n6 < limeXMLDocumentArray.length) {
                        limeXMLDocumentArray[n6] = limeXMLDocument;
                    }
                }
                ++n5;
            }
            arrayList.add((Object)limeXMLDocumentArray);
        }
        return arrayList;
    }

    public static List breakSingleSchemaAggregateString(String string) {
        Element element = LimeXMLDocumentHelper.getDOMTree(new DOMParser(), string);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List list = LimeXMLUtils.getElements(element.getChildNodes());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            LimeXMLDocument limeXMLDocument = null;
            try {
                limeXMLDocument = new LimeXMLDocument(node, element);
            }
            catch (IOException iOException) {
                continue;
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                continue;
            }
            arrayList.add((Object)limeXMLDocument);
        }
        return arrayList;
    }

    public static String getAggregateString(Response[] responseArray) {
        LimeXMLDocument limeXMLDocument;
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < responseArray.length) {
            limeXMLDocument = responseArray[n].getDocument();
            if (limeXMLDocument != null) {
                LimeXMLDocumentHelper.aggregateResponse(hashMap, limeXMLDocument, n);
            }
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        limeXMLDocument = hashMap.values().iterator();
        while (limeXMLDocument.hasNext()) {
            String string = ((StringBuffer)limeXMLDocument.next()).toString();
            int n2 = string.indexOf("<", 2);
            int n3 = string.indexOf(" ", n2);
            stringBuffer.append(string);
            stringBuffer.append("</");
            stringBuffer.append(string.substring(n2 + 1, n3));
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private static void aggregateResponse(HashMap hashMap, LimeXMLDocument limeXMLDocument, int n) {
        if (limeXMLDocument == null) {
            return;
        }
        String string = limeXMLDocument.getSchemaURI();
        StringBuffer stringBuffer = (StringBuffer)hashMap.get((Object)string);
        if (stringBuffer == null) {
            String string2 = null;
            try {
                string2 = limeXMLDocument.getXMLString();
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                return;
            }
            if (string2 == null || string2.equals("")) {
                return;
            }
            int n2 = (string2 = string2.substring(0, string2.lastIndexOf("<"))).indexOf("<");
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            n2 = string2.indexOf("<", n2 + 1);
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            n2 = string2.indexOf("<", n2 + 1);
            Assert.that(n2 >= 0, "LimeXMLDocument is broken");
            int n3 = string2.indexOf(">", n2 + 1);
            int n4 = string2.lastIndexOf("/", n3 - 1);
            n2 = n4 != -1 && n2 < n4 && n4 < n3 ? (string2.substring(n4 + 1, n3).trim().equals("") ? n4 : n3) : n3;
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2);
            StringBuffer stringBuffer2 = new StringBuffer(string3.length() + 15 + string4.length());
            stringBuffer2.append(string3);
            stringBuffer2.append(" index=\"");
            stringBuffer2.append(n);
            stringBuffer2.append("\" ");
            stringBuffer2.append(string4);
            hashMap.put((Object)string, (Object)stringBuffer2);
        } else {
            String string5 = null;
            try {
                string5 = limeXMLDocument.getXMLString();
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                return;
            }
            int n5 = string5.indexOf("<");
            Assert.that(n5 != -1, string5);
            n5 = string5.indexOf("<", n5 + 1);
            Assert.that(n5 != -1, string5);
            n5 = string5.indexOf("<", n5 + 1);
            Assert.that(n5 != -1, string5);
            int n6 = string5.lastIndexOf("<");
            Assert.that(n6 != -1, string5);
            string5 = string5.substring(n5, n6);
            int n7 = string5.indexOf(">");
            int n8 = string5.lastIndexOf("/", n7 - 1);
            if (n8 != -1 && n8 < n7 && string5.substring(n8 + 1, n7).trim().equals("")) {
                n7 = n8;
            }
            String string6 = string5.substring(0, n7);
            String string7 = string5.substring(n7);
            stringBuffer.append(string6);
            stringBuffer.append(" index=\"");
            stringBuffer.append(n);
            stringBuffer.append("\" ");
            stringBuffer.append(string7);
            hashMap.put((Object)string, (Object)stringBuffer);
        }
    }

    private static Element getDOMTree(DOMParser dOMParser, String string) {
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = null;
        try {
            dOMParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        document = dOMParser.getDocument();
        Element element = document.getDocumentElement();
        return element;
    }

    private static String getAttributeValue(Node node, String string) {
        String string2 = string.toLowerCase(Locale.US);
        List list = LimeXMLUtils.getAttributes(node.getAttributes());
        String string3 = "";
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = (Node)list.get(n2);
            String string4 = node2.getNodeName().toLowerCase(Locale.US);
            if (string4.indexOf(string2) >= 0) {
                string3 = node2.getNodeValue();
            }
            ++n2;
        }
        return string3;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }
}

