/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.BandwidthThrottle;
import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends OutputStream {
    private OutputStream _delegate;
    private BandwidthThrottle _throttle;

    public ThrottledOutputStream(OutputStream outputStream, BandwidthThrottle bandwidthThrottle) {
        this._delegate = outputStream;
        this._throttle = bandwidthThrottle;
    }

    public void write(int n) throws IOException {
        int n2 = this._throttle.request(1);
        Assert.that(n2 == 1);
        this._delegate.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this._throttle.request(n2);
            Assert.that(n3 + n <= byArray.length);
            this._delegate.write(byArray, n, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush() throws IOException {
        this._delegate.flush();
    }

    public void close() throws IOException {
        this._delegate.flush();
    }
}

