/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList((List)new LinkedList());
    private static volatile boolean _done = true;
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();
    private final Set TO_REMOVE = Collections.synchronizedSet((Set)new HashSet());

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    public void start() {
        ManagedThread managedThread = new ManagedThread(this, "QueryDispatcher");
        managedThread.setDaemon(true);
        managedThread.start();
    }

    public void addQuery(QueryHandler queryHandler) {
        queryHandler.sendQuery();
        this.NEW_QUERIES.add((Object)queryHandler);
    }

    public void removeReplyHandler(ReplyHandler replyHandler) {
        if (!replyHandler.isSupernodeClientConnection()) {
            return;
        }
        QueryDispatcher.removeFromCollection((Collection)this.NEW_QUERIES, replyHandler);
        QueryDispatcher.removeFromMap(this.QUERIES, replyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID gUID, int n) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler = (QueryHandler)this.QUERIES.get((Object)gUID);
            if (queryHandler != null) {
                queryHandler.updateLeafResults(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID gUID) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler;
            block4: {
                queryHandler = (QueryHandler)this.QUERIES.get((Object)gUID);
                if (queryHandler != null) break block4;
                return -1;
            }
            return queryHandler.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromCollection(Collection collection, ReplyHandler replyHandler) {
        LinkedList linkedList = new LinkedList();
        Collection collection2 = collection;
        synchronized (collection2) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                QueryHandler queryHandler = (QueryHandler)iterator.next();
                ReplyHandler replyHandler2 = queryHandler.getReplyHandler();
                if (replyHandler != replyHandler2) continue;
                linkedList.add((Object)queryHandler);
            }
            collection.removeAll((Collection)linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromMap(Map map, ReplyHandler replyHandler) {
        LinkedList linkedList = new LinkedList();
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                QueryHandler queryHandler = (QueryHandler)((Map.Entry)iterator.next()).getValue();
                if (queryHandler.getReplyHandler() != replyHandler) continue;
                linkedList.add((Object)queryHandler.getGUID());
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                map.remove((Object)((GUID)iterator.next()));
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(400L);
                this.processQueries();
            }
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueries() {
        QueryHandler queryHandler;
        Iterator iterator;
        Map map;
        if (!_done) {
            return;
        }
        _done = false;
        List list = this.NEW_QUERIES;
        synchronized (list) {
            map = this.QUERIES;
            synchronized (map) {
                iterator = this.NEW_QUERIES.iterator();
                while (iterator.hasNext()) {
                    queryHandler = (QueryHandler)iterator.next();
                    this.QUERIES.put((Object)queryHandler.getGUID(), (Object)queryHandler);
                }
            }
            this.NEW_QUERIES.clear();
        }
        list = new LinkedList();
        map = this.QUERIES;
        synchronized (map) {
            iterator = this.QUERIES.entrySet().iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)((Map.Entry)iterator.next()).getValue();
                if (this.TO_REMOVE.contains((Object)queryHandler.getGUID())) {
                    this.TO_REMOVE.remove((Object)queryHandler.getGUID());
                    list.add((Object)queryHandler);
                } else {
                    queryHandler.sendQuery();
                }
                if (!queryHandler.hasEnoughResults()) continue;
                list.add((Object)queryHandler);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)iterator.next();
                this.QUERIES.remove((Object)queryHandler.getGUID());
            }
        }
        _done = true;
    }

    public void addToRemove(GUID gUID) {
        this.TO_REMOVE.add((Object)gUID);
    }
}

