/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UDPCrawlerPong
extends VendorMessage {
    public static final int VERSION = 1;
    List _ultrapeers;
    List _leaves;
    final boolean _connectionTime;
    final boolean _localeInfo;
    final boolean _newOnly;
    private final byte _format;

    public UDPCrawlerPong(UDPCrawlerPing uDPCrawlerPing) {
        super(VendorMessage.F_LIME_VENDOR_ID, 6, 1, UDPCrawlerPong.derivePayload(uDPCrawlerPing));
        this.setGUID(new GUID(uDPCrawlerPing.getGUID()));
        this._format = (byte)(uDPCrawlerPing.getFormat() & 7);
        this._localeInfo = uDPCrawlerPing.hasLocaleInfo();
        this._connectionTime = uDPCrawlerPing.hasConnectionTime();
        this._newOnly = uDPCrawlerPing.hasNewOnly();
    }

    private static byte[] derivePayload(UDPCrawlerPing uDPCrawlerPing) {
        Object object;
        Object object2;
        byte by = (byte)(uDPCrawlerPing.getFormat() & 7);
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = RouterService.getConnectionManager().getInitializedConnections().iterator();
        boolean bl = uDPCrawlerPing.hasNewOnly();
        while (iterator.hasNext()) {
            object2 = (Connection)iterator.next();
            if (bl) {
                if (((Connection)object2).remoteHostSupportsUDPCrawling() < 1) continue;
                linkedList.add(object2);
                continue;
            }
            if (!((Connection)object2).isGoodUltrapeer()) continue;
            linkedList.add(object2);
        }
        iterator = RouterService.getConnectionManager().getInitializedClientConnections().iterator();
        while (iterator.hasNext()) {
            object2 = (Connection)iterator.next();
            linkedList2.add(object2);
        }
        if (!uDPCrawlerPing.hasLocaleInfo()) {
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < linkedList.size()) {
                int n = (int)Math.floor(Math.random() * (double)(linkedList.size() - uDPCrawlerPing.getNumberUP()));
                linkedList = linkedList.subList(n, n + uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < linkedList2.size()) {
                int n = (int)Math.floor(Math.random() * (double)(linkedList2.size() - uDPCrawlerPing.getNumberLeaves()));
                linkedList2 = linkedList2.subList(n, n + uDPCrawlerPing.getNumberLeaves());
            }
        } else {
            object2 = ApplicationSettings.LANGUAGE.getValue();
            object = RouterService.getConnectionManager().getInitializedConnectionsMatchLocale((String)object2);
            linkedList.removeAll((Collection)object);
            object.addAll((Collection)linkedList);
            linkedList = object;
            object = RouterService.getConnectionManager().getInitializedClientConnectionsMatchLocale((String)object2);
            linkedList2.removeAll((Collection)object);
            object.addAll((Collection)linkedList2);
            linkedList2 = object;
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < linkedList.size()) {
                linkedList = linkedList.subList(0, uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < linkedList2.size()) {
                linkedList2 = linkedList2.subList(0, uDPCrawlerPing.getNumberLeaves());
            }
        }
        int n = 6;
        if (uDPCrawlerPing.hasConnectionTime()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasLocaleInfo()) {
            n += 2;
        }
        object = new byte[(linkedList.size() + linkedList2.size()) * n + 3];
        object[0] = (List)((byte)linkedList.size());
        object[1] = (List)((byte)linkedList2.size());
        object[2] = (List)by;
        linkedList.addAll((Collection)linkedList2);
        long l = System.currentTimeMillis();
        int n2 = 3;
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            System.arraycopy(UDPCrawlerPong.packIPAddress(connection.getInetAddress(), connection.getPort()), 0, object, n2, 6);
            n2 += 6;
            if (uDPCrawlerPing.hasConnectionTime()) {
                long l2 = l - connection.getConnectionTime();
                short s = (short)(l2 / Constants.MINUTE);
                ByteOrder.short2leb(s, (byte[])object, n2);
                n2 += 2;
            }
            if (!uDPCrawlerPing.hasLocaleInfo()) continue;
            System.arraycopy(connection.getLocalePref().getBytes(), 0, object, n2, 2);
            n2 += 2;
        }
        return object;
    }

    private static byte[] packIPAddress(InetAddress inetAddress, int n) {
        try {
            QueryReply.IPPortCombo iPPortCombo = new QueryReply.IPPortCombo(inetAddress.getHostAddress(), n);
            return iPPortCombo.toBytes();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
    }

    protected UDPCrawlerPong(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_LIME_VENDOR_ID, 6, n, byArray2);
        String string;
        ExtendedEndpoint extendedEndpoint;
        QueryReply.IPPortCombo iPPortCombo;
        byte[] byArray3;
        int n2;
        this._ultrapeers = new LinkedList();
        this._leaves = new LinkedList();
        if (this.getVersion() == 1 && (byArray2 == null || byArray2.length < 3)) {
            throw new BadPacketException();
        }
        byte by3 = byArray2[0];
        byte by4 = byArray2[1];
        this._format = (byte)(byArray2[2] & 7);
        this._connectionTime = (this._format & 1) == 1;
        this._localeInfo = (this._format & 2) == 2;
        this._newOnly = (this._format & 4) == 4;
        int n3 = 6;
        if (this._connectionTime) {
            n3 += 2;
        }
        if (this._localeInfo) {
            n3 += 2;
        }
        if (this.getVersion() == 1 && byArray2.length != (by3 + by4) * n3 + 3) {
            throw new BadPacketException("size is " + byArray2.length + " but should have been " + (by3 + by4) * n3 + 3);
        }
        int n4 = 3;
        while (n4 < by3 * n3) {
            n2 = n4;
            byArray3 = new byte[6];
            System.arraycopy(byArray2, n2, byArray3, 0, 6);
            n2 += 6;
            iPPortCombo = QueryReply.IPPortCombo.getCombo(byArray3);
            if (iPPortCombo == null || iPPortCombo.getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + byArray3);
            }
            extendedEndpoint = new ExtendedEndpoint(iPPortCombo.getAddress(), iPPortCombo.getPort());
            if (this._connectionTime) {
                extendedEndpoint.setDailyUptime(ByteOrder.leb2short(byArray2, n2));
                n2 += 2;
            }
            if (this._localeInfo) {
                string = new String(byArray2, n2, 2);
                extendedEndpoint.setClientLocale(string);
                n2 += 2;
            }
            this._ultrapeers.add((Object)extendedEndpoint);
            n4 += n3;
        }
        n4 = by3 * n3 + 3;
        while (n4 < byArray2.length) {
            n2 = n4;
            byArray3 = new byte[6];
            System.arraycopy(byArray2, n2, byArray3, 0, 6);
            n2 += 6;
            iPPortCombo = QueryReply.IPPortCombo.getCombo(byArray3);
            if (iPPortCombo == null || iPPortCombo.getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + byArray3);
            }
            extendedEndpoint = new ExtendedEndpoint(iPPortCombo.getAddress(), iPPortCombo.getPort());
            if (this._connectionTime) {
                extendedEndpoint.setDailyUptime(ByteOrder.leb2short(byArray2, n2));
                n2 += 2;
            }
            if (this._localeInfo) {
                string = new String(byArray2, n2, 2);
                extendedEndpoint.setClientLocale(string);
                n2 += 2;
            }
            this._leaves.add((Object)extendedEndpoint);
            n4 += n3;
        }
    }

    public List getUltrapeers() {
        return this._ultrapeers;
    }

    public List getLeaves() {
        return this._leaves;
    }

    public boolean hasConnectionTime() {
        return this._connectionTime;
    }

    public boolean hasLocaleInfo() {
        return this._localeInfo;
    }
}

