/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPHostRanker;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostCache {
    private static final Log LOG;
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List udpHosts = new ArrayList(100);
    private final Set udpHostsSet = new HashSet();
    private final Set attemptedHosts;
    private boolean dirty = false;
    private static final Comparator FAILURE_COMPARATOR;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.bootstrap.UDPHostCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        FAILURE_COMPARATOR = new FailureComparator();
    }

    public UDPHostCache() {
        this(600000L);
    }

    public UDPHostCache(long l) {
        this.attemptedHosts = new FixedSizeExpiringSet(100, l);
    }

    public synchronized void write(Writer writer) throws IOException {
        Iterator iterator = this.udpHosts.iterator();
        while (iterator.hasNext()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            extendedEndpoint.write(writer);
        }
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug((Object)"Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        Iterator iterator = this.attemptedHosts.iterator();
        while (iterator.hasNext()) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            extendedEndpoint.decrementUDPHostCacheFailure();
            if (extendedEndpoint.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(extendedEndpoint);
            }
            this.dirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle((List)this.udpHosts);
            Collections.sort((List)this.udpHosts, (Comparator)FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList arrayList = new ArrayList(Math.min(5, this.udpHosts.size()));
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.udpHosts.iterator();
        while (iterator.hasNext() && arrayList.size() < 5) {
            Object object = iterator.next();
            if (this.attemptedHosts.contains(object)) continue;
            if (NetworkUtils.isPrivateAddress(((ExtendedEndpoint)object).getAddress())) {
                linkedList.add(object);
                continue;
            }
            arrayList.add(object);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.remove((ExtendedEndpoint)iterator.next());
        }
        this.attemptedHosts.addAll((Collection)arrayList);
        return this.fetch((Collection)arrayList);
    }

    protected synchronized boolean fetch(Collection collection) {
        if (collection.isEmpty()) {
            LOG.debug((Object)"No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching endpoints from " + collection + " host caches"));
        }
        UDPHostRanker.rank(collection, new HostExpirer(collection), new Cancellable(){

            public boolean isCancelled() {
                return RouterService.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return PingRequest.createUDPPing();
    }

    public synchronized boolean remove(ExtendedEndpoint extendedEndpoint) {
        boolean bl;
        boolean bl2;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing endpoint: " + extendedEndpoint));
        }
        Assert.that((bl2 = this.udpHosts.remove((Object)extendedEndpoint)) == (bl = this.udpHostsSet.remove((Object)extendedEndpoint)), "Set " + bl2 + " but queue " + bl);
        return bl2;
    }

    public synchronized boolean add(ExtendedEndpoint extendedEndpoint) {
        Assert.that(extendedEndpoint.isUDPHostCache());
        if (this.udpHostsSet.contains((Object)extendedEndpoint)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            Object object = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(object);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ejected: " + object));
            }
        }
        this.udpHosts.add((Object)extendedEndpoint);
        this.udpHostsSet.add((Object)extendedEndpoint);
        this.dirty = true;
        return true;
    }

    public synchronized void hostCachesAdded() {
        if (this.udpHostsSet.isEmpty()) {
            this.loadDefaults();
        }
    }

    protected void loadDefaults() {
    }

    private void createAndAdd(String string, int n) {
        try {
            ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(string, n).setUDPHostCache(true);
            this.add(extendedEndpoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private class HostExpirer
    implements MessageListener {
        private final Set hosts = new TreeSet(IpPort.COMPARATOR);
        private final Set allHosts;
        private byte[] guid;

        public HostExpirer(Collection collection) {
            this.hosts.addAll(collection);
            this.allHosts = new HashSet(collection);
            this.removeDuplicates(collection, (Collection)this.hosts);
        }

        private void removeDuplicates(Collection collection, Collection collection2) {
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(collection2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing duplicate entry: " + extendedEndpoint));
                }
                UDPHostCache.this.remove(extendedEndpoint);
            }
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            if (replyHandler instanceof UDPReplyHandler) {
                if (this.hosts.remove((Object)replyHandler) && LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recieved: " + message));
                }
                if (this.hosts.isEmpty()) {
                    RouterService.getMessageRouter().unregisterMessageListener(this.guid, this);
                }
            }
        }

        public void registered(byte[] byArray) {
            this.guid = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregistered(byte[] byArray) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                ExtendedEndpoint extendedEndpoint;
                Iterator iterator = this.hosts.iterator();
                while (iterator.hasNext()) {
                    extendedEndpoint = (ExtendedEndpoint)iterator.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    if (extendedEndpoint.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(extendedEndpoint);
                }
                this.allHosts.removeAll((Collection)this.hosts);
                iterator = this.allHosts.iterator();
                while (iterator.hasNext()) {
                    extendedEndpoint = (ExtendedEndpoint)iterator.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Valid response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                }
            }
        }
    }

    private static class FailureComparator
    implements Comparator {
        FailureComparator() {
        }

        public int compare(Object object, Object object2) {
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)object;
            ExtendedEndpoint extendedEndpoint2 = (ExtendedEndpoint)object2;
            return extendedEndpoint.getUDPHostCacheFailures() - extendedEndpoint2.getUDPHostCacheFailures();
        }
    }
}

