/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class UrnCache {
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private static UrnCache instance = null;
    private static final Map URN_MAP = UrnCache.createMap();

    public static synchronized UrnCache instance() {
        if (instance == null) {
            instance = new UrnCache();
        }
        return instance;
    }

    private UrnCache() {
        UrnCache.removeOldEntries(URN_MAP);
    }

    public synchronized Set getUrns(File file) {
        if (file.lastModified() == 0L) {
            return DataUtils.EMPTY_SET;
        }
        UrnSetKey urnSetKey = new UrnSetKey(file);
        Set set = (Set)URN_MAP.get((Object)urnSetKey);
        if (set == null) {
            return DataUtils.EMPTY_SET;
        }
        return Collections.unmodifiableSet((Set)set);
    }

    public synchronized void removeUrns(File file) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.remove((Object)urnSetKey);
    }

    public synchronized void addUrns(File file, Set set) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        URN_MAP.put((Object)urnSetKey, (Object)Collections.unmodifiableSet((Set)set));
    }

    private static Map createMap() {
        Map map = UrnCache.readMap(URN_CACHE_FILE);
        if (map == null) {
            map = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private static Map readMap(File file) {
        Map map;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(file));
                map = (Map)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                map = null;
            }
            catch (ClassCastException classCastException) {
                map = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                map = null;
            }
            catch (ArrayStoreException arrayStoreException) {
                map = null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                map = null;
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                map = null;
            }
            catch (IllegalStateException illegalStateException) {
                map = null;
            }
            catch (SecurityException securityException) {
                map = null;
            }
        }
        catch (Throwable throwable) {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (objectInputStream != null) {
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return map;
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof UrnSetKey) {
                File file;
                UrnSetKey urnSetKey = (UrnSetKey)object;
                if (urnSetKey == null || (file = new File(urnSetKey._path)).exists() && file.lastModified() == urnSetKey._modTime) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    public synchronized void persistCache() {
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(URN_CACHE_FILE));
                objectOutputStream.writeObject(URN_MAP);
            }
            catch (Exception exception) {
                ErrorService.error(exception);
            }
        }
        catch (Throwable throwable) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (objectOutputStream != null) {
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int n = 17;
            n = n * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            n = n * 37 + this._path.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey urnSetKey = (UrnSetKey)object;
            return this._modTime == urnSetKey._modTime && this._path.equals(urnSetKey._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeLong(this._modTime);
            objectOutputStream.writeObject(this._path);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._modTime = objectInputStream.readLong();
            this._path = (String)objectInputStream.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }
}

