/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SavedFileManager
implements Runnable {
    private static final Log LOG;
    private static SavedFileManager INSTANCE;
    private Set _urns = new HashSet();
    private Set _names = new TreeSet(Comparators.caseInsensitiveStringComparator());
    private volatile boolean _loading = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.SavedFileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new SavedFileManager();
    }

    public static SavedFileManager instance() {
        return INSTANCE;
    }

    private SavedFileManager() {
        RouterService.schedule(this, 10000L, 180000L);
    }

    public synchronized void addSavedFile(File file, Set set) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding: " + file + " with: " + set));
        }
        this._names.add((Object)file.getName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this._urns.add(iterator.next());
        }
    }

    public synchronized boolean isSaved(URN uRN, String string) {
        return uRN != null && this._urns.contains((Object)uRN) || this._names.contains((Object)string);
    }

    public synchronized boolean isLoading() {
        return this._loading || !RouterService.getFileManager().isLoadFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            if (!this.isLoading()) {
                this._loading = true;
                ManagedThread managedThread = new ManagedThread(new Runnable(){

                    public void run() {
                        try {
                            SavedFileManager.this.load();
                        }
                        finally {
                            SavedFileManager.this._loading = false;
                        }
                    }
                }, "SavedFileProcessor");
                managedThread.setDaemon(true);
                managedThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace((Object)"Loading Saved Files");
        HashSet hashSet = new HashSet();
        TreeSet treeSet = new TreeSet(Comparators.caseInsensitiveStringComparator());
        File file = SharingSettings.getSaveDirectory();
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isFile() && file2.exists()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Loading: " + file2));
                }
                treeSet.add((Object)string);
                try {
                    Set set = FileDesc.calculateAndCacheURN(file2);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        hashSet.add(iterator.next());
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n;
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._names = treeSet;
            this._urns = hashSet;
        }
        LOG.trace((Object)"Finished loading saved Files.");
    }
}

