/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;

public class DecryptCBC
extends DecryptMode {
    private CipherKey key;
    private int ibs;
    private int obs;
    private byte[] buffer = null;
    private byte[] last;
    private int bufPos = 0;

    public CipherKey getKey() {
        return this.key;
    }

    public void setKey(CipherKey cipherKey) {
        this.key = cipherKey;
        this.ibs = cipherKey.cipherBlockSize();
        this.obs = cipherKey.plainBlockSize();
        this.last = new byte[this.obs];
    }

    public int plainBlockSize() {
        return this.key.plainBlockSize();
    }

    public synchronized byte[] decrypt(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.buffer == null) {
            n5 = Math.min(this.last.length - this.bufPos, n2);
            System.arraycopy(byArray, n, this.last, this.bufPos, n5);
            this.bufPos += n5;
            if (this.bufPos < this.last.length) {
                return new byte[0];
            }
            this.buffer = new byte[this.ibs];
            this.bufPos = 0;
            n2 -= n5;
            n += n5;
        }
        n5 = (this.bufPos + n2) / this.ibs;
        byte[] byArray2 = new byte[n5 * this.obs];
        int n6 = 0;
        if (this.bufPos > 0) {
            n4 = Math.min(n2, this.buffer.length - this.bufPos);
            System.arraycopy(byArray, n, this.buffer, this.bufPos, n4);
            this.bufPos += n4;
            n += n4;
            n2 -= n4;
            --n5;
            if (this.bufPos == this.buffer.length) {
                this.key.decrypt(this.buffer, 0, byArray2, 0);
                n3 = 0;
                while (n3 < this.obs) {
                    int n7 = n3;
                    byArray2[n7] = (byte)(byArray2[n7] ^ this.last[n3]);
                    ++n3;
                }
                System.arraycopy(this.buffer, 0, this.last, 0, this.obs);
                n6 += this.obs;
                this.bufPos = 0;
            } else {
                return byArray2;
            }
        }
        n4 = n;
        if (n5 > 0) {
            this.key.decrypt(byArray, n, byArray2, n6);
            n3 = 0;
            while (n3 < this.obs) {
                int n8 = n6 + n3;
                byArray2[n8] = (byte)(byArray2[n8] ^ this.last[n3]);
                ++n3;
            }
            n += this.ibs;
            n6 += this.obs;
            n3 = 1;
            while (n3 < n5) {
                this.key.decrypt(byArray, n, byArray2, n6);
                int n9 = 0;
                while (n9 < this.obs) {
                    int n10 = n6 + n9;
                    byArray2[n10] = (byte)(byArray2[n10] ^ byArray[n + n9 - this.ibs]);
                    ++n9;
                }
                n += this.ibs;
                n6 += this.obs;
                ++n3;
            }
            System.arraycopy(byArray, n - this.ibs, this.last, 0, this.obs);
        }
        this.bufPos = n2 - (n - n4);
        if (this.bufPos != 0) {
            System.arraycopy(byArray, n, this.buffer, 0, this.bufPos);
        }
        return byArray2;
    }

    public DecryptCBC(CipherKey cipherKey) {
        this.setKey(cipherKey);
    }

    public DecryptCBC() {
    }
}

