/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.Crypto;
import org.logi.crypto.Producer;
import org.logi.crypto.keys.CipherKey;

public class OFBProducer
extends Producer {
    CipherKey key;
    int ibs;
    int obs;
    private byte[] lastBlock;
    byte[] IV;

    public void calculate(byte[] byArray) {
        this.key.encrypt(this.lastBlock, 0, byArray, 0);
        int n = this.obs;
        while (n < byArray.length) {
            this.key.encrypt(byArray, n - this.ibs, byArray, n);
            n += this.obs;
        }
        System.arraycopy(byArray, byArray.length - this.ibs, this.lastBlock, 0, this.ibs);
    }

    public OFBProducer(CipherKey cipherKey, int n) {
        super(((n - 1) / cipherKey.cipherBlockSize() / 4 + 1) * cipherKey.cipherBlockSize());
        this.key = cipherKey;
        this.ibs = cipherKey.plainBlockSize();
        this.obs = cipherKey.cipherBlockSize();
        this.lastBlock = new byte[this.ibs];
        this.IV = new byte[this.ibs];
        Crypto.random.nextBytes(this.IV);
        System.arraycopy(this.IV, 0, this.lastBlock, 0, this.ibs);
        this.start();
    }

    protected OFBProducer(CipherKey cipherKey, int n, byte[] byArray, int n2) {
        super(((n - 1) / cipherKey.cipherBlockSize() / 4 + 1) * cipherKey.cipherBlockSize());
        this.key = cipherKey;
        this.ibs = cipherKey.plainBlockSize();
        this.obs = cipherKey.cipherBlockSize();
        this.lastBlock = new byte[this.ibs];
        this.IV = new byte[this.ibs];
        System.arraycopy(byArray, n2, this.IV, 0, this.ibs);
        System.arraycopy(byArray, n2, this.lastBlock, 0, this.ibs);
        this.start();
    }
}

