/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();
    private final ProcessingQueue PROCESSOR = new ProcessingQueue("QueryDispatcher");
    private boolean _active;

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(QueryHandler queryHandler) {
        queryHandler.sendQuery();
        List list = this.NEW_QUERIES;
        synchronized (list) {
            this.NEW_QUERIES.add(queryHandler);
            if (this.NEW_QUERIES.size() == 1 && !this._active) {
                this._active = true;
                this.PROCESSOR.add(this);
            }
        }
    }

    public void removeReplyHandler(ReplyHandler replyHandler) {
        if (!replyHandler.isSupernodeClientConnection()) {
            return;
        }
        this.remove(replyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID gUID, int n) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler = (QueryHandler)this.QUERIES.get(gUID);
            if (queryHandler != null) {
                queryHandler.updateLeafResults(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID gUID) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler queryHandler;
            block4: {
                queryHandler = (QueryHandler)this.QUERIES.get(gUID);
                if (queryHandler != null) break block4;
                return -1;
            }
            return queryHandler.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReplyHandler replyHandler) {
        QueryHandler queryHandler;
        Iterator<Object> iterator;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iterator = this.NEW_QUERIES.iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)iterator.next();
                if (queryHandler.getReplyHandler() != replyHandler) continue;
                iterator.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iterator = this.QUERIES.values().iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)iterator.next();
                if (queryHandler.getReplyHandler() != replyHandler) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(GUID gUID) {
        QueryHandler queryHandler;
        Iterator<Object> iterator;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iterator = this.NEW_QUERIES.iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)iterator.next();
                if (!queryHandler.getGUID().equals(gUID)) continue;
                iterator.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iterator = this.QUERIES.values().iterator();
            while (iterator.hasNext()) {
                queryHandler = (QueryHandler)iterator.next();
                if (!queryHandler.getGUID().equals(gUID)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {}
            try {
                if (this.processQueries()) continue;
                List list = this.NEW_QUERIES;
                synchronized (list) {
                    if (this.NEW_QUERIES.isEmpty()) {
                        this._active = false;
                        return;
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueries() {
        Object object;
        Object object2;
        Object object3 = this.NEW_QUERIES;
        synchronized (object3) {
            object2 = this.QUERIES;
            synchronized (object2) {
                object = this.NEW_QUERIES.iterator();
                while (object.hasNext()) {
                    QueryHandler queryHandler = (QueryHandler)object.next();
                    this.QUERIES.put(queryHandler.getGUID(), queryHandler);
                }
            }
            this.NEW_QUERIES.clear();
        }
        object3 = this.QUERIES;
        synchronized (object3) {
            object2 = this.QUERIES.values().iterator();
            while (object2.hasNext()) {
                object = (QueryHandler)object2.next();
                ((QueryHandler)object).sendQuery();
                if (!((QueryHandler)object).hasEnoughResults()) continue;
                object2.remove();
            }
            return !this.QUERIES.isEmpty();
        }
    }

    public void addToRemove(GUID gUID) {
        this.remove(gUID);
    }
}

