/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.AcceptObserver;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NIOServerSocket
extends ServerSocket
implements AcceptObserver {
    private static final Log LOG;
    private final ServerSocketChannel channel;
    private final ServerSocket socket;
    private final List pendingSockets = new LinkedList();
    private IOException storedException = null;
    private final Object LOCK = new Object();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.NIOServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public NIOServerSocket() throws IOException {
        this.channel = ServerSocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
    }

    public NIOServerSocket(int n) throws IOException {
        this.channel = ServerSocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.bind(new InetSocketAddress(n));
    }

    public NIOServerSocket(int n, int n2) throws IOException {
        this.channel = ServerSocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.bind(new InetSocketAddress(n), n2);
    }

    public NIOServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this.channel = ServerSocketChannel.open();
        this.socket = this.channel.socket();
        this.init();
        this.bind(new InetSocketAddress(inetAddress, n), n2);
    }

    private void init() throws IOException {
        this.channel.configureBlocking(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            int n = this.getSoTimeout();
            while (!this.isClosed() && this.isBound() && this.storedException == null && this.pendingSockets.isEmpty()) {
                if (bl && n != 0) {
                    throw new SocketTimeoutException("accept timed out: " + n);
                }
                LOG.debug((Object)"Waiting for incoming socket...");
                try {
                    this.LOCK.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException(interruptedException);
                }
                bl = true;
            }
            IOException iOException = this.storedException;
            this.storedException = null;
            if (this.isClosed()) {
                throw new SocketException("Socket Closed");
            }
            if (iOException != null) {
                throw iOException;
            }
            if (!this.isBound()) {
                throw new SocketException("Not Bound!");
            }
            LOG.debug((Object)"Retrieved a socket!");
            return new NIOSocket((Socket)this.pendingSockets.remove(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAccept(SocketChannel socketChannel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.pendingSockets.add(socketChannel.socket());
            this.LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIOException(IOException iOException) {
        Object object = this.LOCK;
        synchronized (object) {
            this.storedException = iOException;
        }
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        this.socket.bind(socketAddress, n);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
            this.socket.close();
        }
    }

    public ServerSocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public String toString() {
        return "NIOServerSocket::" + this.socket.toString();
    }
}

