/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.util.Properties;

public final class LeafHandshakeResponder
extends DefaultHandshakeResponder {
    public LeafHandshakeResponder(String string) {
        super(string);
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.isUltrapeer()) {
            HandshakingStat.LEAF_OUTGOING_REJECT_LEAF.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        if (this.getLocalePreferencing() && !ApplicationSettings.LANGUAGE.getValue().equals(handshakeResponse.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        if (!this._manager.allowConnection(handshakeResponse)) {
            HandshakingStat.LEAF_OUTGOING_REJECT_OLD_UP.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        Properties properties = new Properties();
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_OUTGOING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            HandshakingStat.INCOMING_CRAWLER.incrementStat();
            return HandshakeResponse.createCrawlerResponse();
        }
        if (!handshakeResponse.isUltrapeer()) {
            HandshakingStat.LEAF_INCOMING_REJECT.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        LeafHeaders leafHeaders = new LeafHeaders(this.getRemoteIP());
        if (!this._manager.allowConnection(handshakeResponse)) {
            HandshakingStat.LEAF_INCOMING_REJECT.incrementStat();
            return HandshakeResponse.createLeafRejectIncomingResponse(handshakeResponse);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            leafHeaders.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_INCOMING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, leafHeaders);
    }
}

