/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.downloader.SelectionStrategyFactory;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerifyingFile {
    private static final Log LOG;
    private static final ProcessingQueue QUEUE;
    private static final int MAX_CACHED_BUFFERS = 512;
    static final float MAX_CORRUPTION = 0.9f;
    static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final Stack CACHE;
    private static int numCreated;
    private static final Map CHUNK_CACHE;
    private volatile RandomAccessFile fos;
    private volatile boolean isOpen;
    private final int completedSize;
    private int lostSize;
    private final IntervalSet verifiedBlocks;
    private IntervalSet leasedBlocks;
    private IntervalSet partialBlocks;
    private IntervalSet savedCorruptBlocks;
    private IntervalSet pendingBlocks;
    private SelectionStrategy blockChooser = null;
    private HashTree hashTree;
    private String expectedHashRoot;
    private boolean hashTreeRequested;
    private boolean discardBad = true;
    private IOException storedException;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.VerifyingFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        QUEUE = new ProcessingQueue("BlockingVF", true, 6);
        CACHE = new Stack();
        CACHE.ensureCapacity(512);
        RouterService.schedule(new CacheCleaner(), 600000L, 600000L);
        CHUNK_CACHE = new HashMap(20);
    }

    public VerifyingFile() {
        this(-1);
    }

    public VerifyingFile(int n) {
        this.completedSize = n;
        this.verifiedBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
        this.pendingBlocks = new IntervalSet();
        this.partialBlocks = new IntervalSet();
        this.savedCorruptBlocks = new IntervalSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws IOException {
        if (this.completedSize == -1) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
            FileUtils.setWriteable(file2);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        SelectionStrategy selectionStrategy = SelectionStrategyFactory.getStrategyFor(FileUtils.getFileExtension(file), this.completedSize);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            this.storedException = null;
            this.blockChooser = selectionStrategy;
            this.isOpen = true;
        }
    }

    public synchronized void addInterval(Interval interval) {
        this.partialBlocks.add(interval);
    }

    public void writeBlock(long l, byte[] byArray) throws InterruptedException {
        this.writeBlock(l, byArray.length, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlock(long l, int n, byte[] byArray) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(" trying to write block at offset " + l + " with size " + n));
        }
        if (byArray.length == 0) {
            return;
        }
        if (this.fos == null) {
            throw new IllegalStateException("no fos!");
        }
        if (!this.isOpen()) {
            return;
        }
        Interval interval = new Interval(l, l + (long)n - 1L);
        byte[] byArray2 = VerifyingFile.getBuffer();
        Assert.that(byArray2.length >= n);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            if (!this.leasedBlocks.contains(interval)) {
                Assert.that(false, "trying to write an interval " + interval + " that wasn't leased.\n" + this.dumpState());
            }
            if (this.verifiedBlocks.contains(interval) || this.partialBlocks.contains(interval) || this.savedCorruptBlocks.contains(interval) || this.pendingBlocks.contains(interval)) {
                Assert.that(false, "trying to write an interval " + interval + " that was already written" + this.dumpState());
            }
            this.leasedBlocks.delete(interval);
            this.pendingBlocks.add(interval);
        }
        System.arraycopy(byArray, 0, byArray2, 0, n);
        QUEUE.add(new ChunkHandler(byArray2, interval));
    }

    private static byte[] getBuffer() throws InterruptedException {
        byte[] byArray = null;
        Stack stack = CACHE;
        synchronized (stack) {
            while (true) {
                if (!CACHE.isEmpty()) {
                    return (byte[])CACHE.pop();
                }
                if (numCreated < 512) {
                    byArray = new byte[1024];
                    ++numCreated;
                    return byArray;
                }
                CACHE.wait();
            }
        }
    }

    public String dumpState() {
        return "verified:" + this.verifiedBlocks + "\npartial:" + this.partialBlocks + "\ndiscarded:" + this.savedCorruptBlocks + "\npending:" + this.pendingBlocks + "\nleased:" + this.leasedBlocks;
    }

    public Interval leaseWhite() throws NoSuchElementException {
        return this.leaseWhiteHelper(null, this.completedSize);
    }

    public Interval leaseWhite(int n) throws NoSuchElementException {
        return this.leaseWhiteHelper(null, n);
    }

    public Interval leaseWhite(IntervalSet intervalSet) throws NoSuchElementException {
        return this.leaseWhiteHelper(intervalSet, 131072L);
    }

    public Interval leaseWhite(IntervalSet intervalSet, int n) throws NoSuchElementException {
        return this.leaseWhiteHelper(intervalSet, n);
    }

    public synchronized void releaseBlock(Interval interval) {
        if (!this.leasedBlocks.contains(interval)) {
            Assert.that(false, "trying to release an interval " + interval + " that wasn't leased " + this.dumpState());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Releasing interval: " + interval + " state " + this.dumpState()));
        }
        this.leasedBlocks.delete(interval);
    }

    public synchronized Iterator getBlocks() {
        return this.getBlocksAsList().iterator();
    }

    public synchronized Iterator getVerifiedBlocks() {
        return this.verifiedBlocks.getAllIntervals();
    }

    public synchronized byte[] toBytes() {
        return this.verifiedBlocks.toBytes();
    }

    public String toString() {
        return this.dumpState();
    }

    public synchronized List getSerializableBlocks() {
        IntervalSet intervalSet = new IntervalSet();
        Iterator iterator = this.verifiedBlocks.getAllIntervals();
        while (iterator.hasNext()) {
            intervalSet.add((Interval)iterator.next());
        }
        iterator = this.partialBlocks.getAllIntervals();
        while (iterator.hasNext()) {
            intervalSet.add((Interval)iterator.next());
        }
        iterator = this.savedCorruptBlocks.getAllIntervals();
        while (iterator.hasNext()) {
            intervalSet.add((Interval)iterator.next());
        }
        return intervalSet.getAllIntervalsAsList();
    }

    public synchronized List getBlocksAsList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.verifiedBlocks.getAllIntervalsAsList());
        arrayList.addAll(this.partialBlocks.getAllIntervalsAsList());
        arrayList.addAll(this.savedCorruptBlocks.getAllIntervalsAsList());
        arrayList.addAll(this.pendingBlocks.getAllIntervalsAsList());
        IntervalSet intervalSet = new IntervalSet();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            intervalSet.add((Interval)iterator.next());
        }
        return intervalSet.getAllIntervalsAsList();
    }

    public synchronized List getVerifiedBlocksAsList() {
        return this.verifiedBlocks.getAllIntervalsAsList();
    }

    public synchronized int getBlockSize() {
        return this.verifiedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize();
    }

    public synchronized int getPendingSize() {
        return this.pendingBlocks.getSize();
    }

    public static int getNumPendingItems() {
        return QUEUE.size();
    }

    public synchronized int getVerifiedBlockSize() {
        return this.verifiedBlocks.getSize();
    }

    public synchronized int getAmountLost() {
        return this.lostSize;
    }

    public synchronized boolean isComplete() {
        if (this.hashTree != null) {
            return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() == this.completedSize;
        }
        return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.partialBlocks.getSize() == this.completedSize;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void waitForPendingIfNeeded() throws InterruptedException, DiskException {
        if (this.storedException == null) ** GOTO lbl8
        throw new DiskException(this.storedException);
lbl-1000:
        // 1 sources

        {
            if (this.storedException != null) {
                throw new DiskException(this.storedException);
            }
            if (VerifyingFile.LOG.isInfoEnabled()) {
                VerifyingFile.LOG.info((Object)"waiting for a pending chunk to verify or write..");
            }
            this.wait();
lbl8:
            // 2 sources

            ** while (!this.isComplete() && this.getBlockSize() == this.completedSize)
        }
lbl9:
        // 1 sources

    }

    public synchronized boolean isHopeless() {
        return (float)this.lostSize >= 0.9f * (float)this.completedSize;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized int hasFreeBlocksToAssign() {
        return this.completedSize - (this.verifiedBlocks.getSize() + this.leasedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize());
    }

    public void close() {
        this.isOpen = false;
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {}
    }

    private synchronized Interval leaseWhiteHelper(IntervalSet intervalSet, long l) throws NoSuchElementException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("leasing white, state:\n" + this.dumpState()));
        }
        if (intervalSet == null) {
            intervalSet = IntervalSet.createSingletonSet(0L, this.completedSize - 1);
        }
        IntervalSet intervalSet2 = IntervalSet.createSingletonSet(0L, this.completedSize - 1);
        intervalSet2.delete(this.verifiedBlocks);
        intervalSet2.delete(this.leasedBlocks);
        intervalSet2.delete(this.partialBlocks);
        intervalSet2.delete(this.savedCorruptBlocks);
        intervalSet2.delete(this.pendingBlocks);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("needed bytes: " + intervalSet2));
        }
        intervalSet.delete(intervalSet2.invert(this.completedSize));
        Interval interval = this.blockChooser.pickAssignment(intervalSet, intervalSet2, l);
        this.leaseBlock(interval);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("leasing white interval " + interval + "\nof available intervals " + intervalSet2));
        }
        return interval;
    }

    private synchronized void leaseBlock(Interval interval) {
        this.leasedBlocks.add(interval);
    }

    public synchronized void setExpectedHashTreeRoot(String string) {
        this.expectedHashRoot = string;
    }

    public synchronized HashTree getHashTree() {
        return this.hashTree;
    }

    public synchronized void setHashTree(HashTree hashTree) {
        if (this.expectedHashRoot != null && hashTree != null && !hashTree.getRootHash().equalsIgnoreCase(this.expectedHashRoot)) {
            return;
        }
        if (hashTree != null && hashTree.getFileSize() != (long)this.completedSize) {
            return;
        }
        HashTree hashTree2 = this.hashTree;
        this.hashTree = hashTree;
        if (hashTree2 == null && hashTree != null && this.pendingBlocks.getSize() == 0 && this.partialBlocks.getSize() > 0) {
            QUEUE.add(new EmptyVerifier());
        }
    }

    public synchronized void setHashTreeRequested(boolean bl) {
        this.hashTreeRequested = bl;
    }

    public synchronized boolean isHashTreeRequested() {
        return this.hashTreeRequested;
    }

    public synchronized void setDiscardUnverified(boolean bl) {
        this.discardBad = bl;
    }

    public synchronized int getChunkSize() {
        return this.hashTree == null ? 131072 : this.hashTree.getNodeSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyChunks() {
        HashTree hashTree = this.getHashTree();
        if (hashTree != null) {
            Iterator iterator = this.findVerifyableBlocks().iterator();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                boolean bl = this.verifyChunk(interval, hashTree);
                VerifyingFile verifyingFile = this;
                synchronized (verifyingFile) {
                    this.partialBlocks.delete(interval);
                    if (bl) {
                        this.verifiedBlocks.add(interval);
                    } else {
                        if (!this.discardBad) {
                            this.savedCorruptBlocks.add(interval);
                        }
                        this.lostSize += interval.high - interval.low + 1;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyChunk(Interval interval, HashTree hashTree) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("verifying interval " + interval));
        }
        byte[] byArray = VerifyingFile.getChunkBuf(interval.high - interval.low + 1);
        try {
            RandomAccessFile randomAccessFile = this.fos;
            synchronized (randomAccessFile) {
                this.fos.seek(interval.low);
                this.fos.readFully(byArray);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        boolean bl = hashTree.isCorrupt(interval, byArray);
        if (LOG.isDebugEnabled() && bl) {
            LOG.debug((Object)"block corrupt!");
        }
        return !bl;
    }

    private static byte[] getChunkBuf(int n) {
        int n2 = 1;
        while (n2 < n) {
            n2 *= 2;
        }
        if (n2 > n) {
            return new byte[n];
        }
        Integer n3 = new Integer(n);
        byte[] byArray = (byte[])CHUNK_CACHE.get(n3);
        if (byArray == null) {
            byArray = new byte[n];
            CHUNK_CACHE.put(n3, byArray);
        }
        return byArray;
    }

    private synchronized List findVerifyableBlocks() {
        Interval interval;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("trying to find verifyable blocks out of " + this.partialBlocks));
        }
        ArrayList<Interval> arrayList = new ArrayList<Interval>(2);
        List list = this.partialBlocks.getAllIntervalsAsList();
        int n = this.getChunkSize();
        int n2 = 0;
        while (n2 < list.size()) {
            interval = (Interval)list.get(n2);
            int n3 = interval.low - interval.low % n;
            if (interval.low % n != 0) {
                n3 += n;
            }
            while (interval.high >= n3 + n - 1) {
                Interval interval2 = new Interval(n3, n3 + n - 1);
                arrayList.add(interval2);
                n3 += n;
            }
            ++n2;
        }
        if (!list.isEmpty()) {
            n2 = this.completedSize - this.completedSize % n;
            if (n2 == this.completedSize) {
                n2 -= n;
            }
            interval = (Interval)list.get(list.size() - 1);
            if (interval.high == this.completedSize - 1 && interval.low <= n2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"adding the last chunk for verification");
                }
                arrayList.add(new Interval(n2, interval.high));
            }
        }
        return arrayList;
    }

    static /* synthetic */ IntervalSet access$1(VerifyingFile verifyingFile) {
        return verifyingFile.pendingBlocks;
    }

    static /* synthetic */ RandomAccessFile access$3(VerifyingFile verifyingFile) {
        return verifyingFile.fos;
    }

    static /* synthetic */ IntervalSet access$4(VerifyingFile verifyingFile) {
        return verifyingFile.partialBlocks;
    }

    static /* synthetic */ void access$6(VerifyingFile verifyingFile, IOException iOException) {
        verifyingFile.storedException = iOException;
    }

    private class ChunkHandler
    implements Runnable {
        private final byte[] buf;
        private final Interval intvl;

        public ChunkHandler(byte[] byArray, Interval interval) {
            this.buf = byArray;
            this.intvl = interval;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [8 : 293->297)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class EmptyVerifier
    implements Runnable {
        EmptyVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VerifyingFile.this.verifyChunks();
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                VerifyingFile.this.notify();
            }
        }
    }

    private static class CacheCleaner
    implements Runnable {
        CacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info((Object)"clearing cache");
            Stack stack = CACHE;
            synchronized (stack) {
                int n = CACHE.size();
                CACHE.clear();
                numCreated = numCreated - n;
                CACHE.notifyAll();
            }
            QUEUE.add(new ChunkCacheCleaner());
        }
    }

    private static class ChunkCacheCleaner
    implements Runnable {
        ChunkCacheCleaner() {
        }

        public void run() {
            CHUNK_CACHE.clear();
        }
    }
}

