/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.IntWrapper;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class URN
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    public static final URN INVALID = new URN("bad:bad", UrnType.INVALID);
    private static final int MIN_IDLE_TIME = 300000;
    private static final String SPACE = " ";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String TWO = "2";
    private static final String DOT = ".";
    private transient String _urnString;
    private transient UrnType _urnType;
    private volatile transient int hashCode = 0;
    private static final Map progressMap = Collections.synchronizedMap(new HashMap());

    public static int getHashingProgress(File file) {
        IntWrapper intWrapper = (IntWrapper)progressMap.get(file);
        if (intWrapper == null) {
            return -1;
        }
        return intWrapper.getInt();
    }

    public static URN createSHA1Urn(File file) throws IOException, InterruptedException {
        return new URN(URN.createSHA1String(file), UrnType.SHA1);
    }

    public static URN createSHA1Urn(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf("sha1:") == 4) {
            return URN.createSHA1UrnFromString(string);
        }
        if (string2.indexOf("bitprint:") == 4) {
            return URN.createSHA1UrnFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static String getTigerTreeRoot(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf("bitprint:") == 4) {
            return URN.getTTRootFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createSHA1UrnFromURL(URL uRL) throws IOException {
        return URN.createSHA1UrnFromUriRes(uRL.getFile());
    }

    public static URN createSHA1UrnFromUriRes(String string) throws IOException {
        string.trim();
        if (URN.isValidUriResSHA1Format(string)) {
            return URN.createSHA1UrnFromString(string.substring(13));
        }
        throw new IOException("could not parse string format: " + string);
    }

    public static URN createSHA1UrnFromHttpRequest(String string) throws IOException {
        if (!URN.isValidUrnHttpRequest(string)) {
            throw new IOException("INVALID URN HTTP REQUEST");
        }
        String string2 = URN.extractUrnFromHttpRequest(string);
        if (string2 == null) {
            throw new IOException("COULD NOT CONSTRUCT URN");
        }
        return URN.createSHA1Urn(string2);
    }

    private static URN createSHA1UrnFromString(String string) throws IOException {
        if (string == null) {
            throw new IOException("cannot accept null URN string");
        }
        if (!URN.isValidUrn(string)) {
            throw new IOException("invalid urn string: " + string);
        }
        String string2 = URN.getTypeString(string);
        if (!UrnType.isSupportedUrnType(string2)) {
            throw new IOException("urn type not recognized: " + string2);
        }
        UrnType urnType = UrnType.createUrnType(string2);
        return new URN(string, urnType);
    }

    private static URN createSHA1UrnFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(string.indexOf(58, 4) + 1, n);
        return URN.createSHA1UrnFromString("urn:sha1:" + string2);
    }

    private static String getTTRootFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1 || n == string.length() - 1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(n + 1);
        if (string2.length() != 39) {
            throw new IOException("wrong length: " + string2.length());
        }
        return string2;
    }

    private URN(String string, UrnType urnType) {
        int n = string.lastIndexOf(":");
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        this._urnString = String.valueOf(string2.toLowerCase(Locale.US)) + string3.toUpperCase(Locale.US);
        this._urnType = urnType;
    }

    public UrnType getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String string) {
        return URN.isValidUrn(string);
    }

    public boolean isSHA1() {
        return this._urnType.isSHA1();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URN)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        URN uRN = (URN)object;
        return this._urnString.equals(uRN._urnString) && this._urnType.equals(uRN._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this._urnString.hashCode();
            this.hashCode = n = 37 * n + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static boolean isValidUriResSHA1Format(String string) {
        String string2 = string.toLowerCase(Locale.US);
        if (string2.startsWith("/uri-res/n2r?urn:sha1:")) {
            return string.length() == 54;
        }
        return false;
    }

    private static String extractUrnFromHttpRequest(String string) {
        int n = string.indexOf(QUESTION_MARK) + 1;
        int n2 = string.indexOf(SPACE, n);
        if (n == -1 || n2 == -1) {
            return null;
        }
        return string.substring(n, n2);
    }

    private static boolean isValidUrnHttpRequest(String string) {
        return URN.isValidLength(string) && URN.isValidUriRes(string) && URN.isValidResolutionProtocol(string) && URN.isValidHTTPSpecifier(string);
    }

    private static final boolean isValidLength(String string) {
        int n = string.length();
        return n == 63 || n == 107;
    }

    private static final boolean isValidUriRes(String string) {
        int n = string.indexOf(SLASH);
        if (n == -1 || n == string.length()) {
            return false;
        }
        int n2 = string.indexOf(SLASH, n + 1);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static boolean isValidResolutionProtocol(String string) {
        int n = string.indexOf(TWO);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n - 1, n + 3);
        return string2.equalsIgnoreCase("N2R?") || string2.equalsIgnoreCase("N2X?");
    }

    private static boolean isValidHTTPSpecifier(String string) {
        int n = string.lastIndexOf(SPACE);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return string2.equalsIgnoreCase("HTTP/1.0") || string2.equalsIgnoreCase("HTTP/1.1");
    }

    private static String getTypeString(String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() <= 4) {
            throw new IOException("no type string");
        }
        return string2.substring(0, string2.indexOf(58, 4) + 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createSHA1String(File file) throws IOException, InterruptedException {
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[65536];
        IntWrapper intWrapper = new IntWrapper(0);
        progressMap.put(file, intWrapper);
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray)) != -1) {
                long l = System.currentTimeMillis();
                sHA1.update(byArray, 0, n);
                intWrapper.addInt(n);
                if (SystemUtils.getIdleTime() >= 300000L || !SharingSettings.FRIENDLY_HASHING.getValue()) continue;
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 > 0L) {
                    Thread.sleep(l3 * 3L);
                    continue;
                }
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            progressMap.remove(file);
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_12 = null;
            progressMap.remove(file);
        }
        if (fileInputStream != null) {
            try {}
            catch (IOException iOException) {}
            fileInputStream.close();
        }
        byte[] byArray2 = sHA1.digest();
        return "urn:sha1:" + Base32.encode(byArray2);
    }

    private static boolean isValidUrn(String string) {
        int n = string.indexOf(":");
        if (n == -1 || n + 1 > string.length()) {
            return false;
        }
        int n2 = n - 3;
        int n3 = n + 1;
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        int n4 = string.indexOf(":", n + 1);
        if (n4 == -1 || n4 + 1 > string.length()) {
            return false;
        }
        String string2 = string.substring(0, n4 + 1);
        return UrnType.isSupportedUrnType(string2) && URN.isValidNamespaceSpecificString(string.substring(n4 + 1));
    }

    private static boolean isValidNamespaceSpecificString(String string) {
        int n = string.length();
        return n == 32 || n == 72;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._urnString);
        objectOutputStream.writeObject(this._urnType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._urnString = objectInputStream.readUTF();
        this._urnType = (UrnType)objectInputStream.readObject();
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
        if (!this._urnType.isSHA1()) {
            throw new InvalidObjectException("invalid urn type: " + this._urnType);
        }
        this._urnType = UrnType.SHA1;
    }
}

