/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Response {
    private static final Log LOG;
    private static final byte EXT_SEPARATOR = 28;
    private static final int MAX_LOCATIONS = 10;
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private volatile RemoteFileDesc cachedRFD;
    private final GGEPContainer ggepData;
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Response");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public Response(long l, long l2, String string) {
        this(l, l2, string, null, null, null, null);
    }

    public Response(long l, long l2, String string, LimeXMLDocument limeXMLDocument) {
        this(l, l2, string, null, limeXMLDocument, null, null);
    }

    public Response(FileDesc fileDesc) {
        this(fileDesc.getIndex(), fileDesc.getFileSize(), fileDesc.getFileName(), fileDesc.getUrns(), null, new GGEPContainer(Response.getAsEndpoints(RouterService.getAltlocManager().getDirect(fileDesc.getSHA1Urn())), CreationTimeCache.instance().getCreationTimeAsLong(fileDesc.getSHA1Urn())), null);
    }

    private Response(long l, long l2, String string, Set set, LimeXMLDocument limeXMLDocument, GGEPContainer gGEPContainer, byte[] byArray) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (l2 > Integer.MAX_VALUE || l2 < 0L) {
            throw new IllegalArgumentException("invalid size: " + l2);
        }
        this.index = l;
        this.size = l2;
        this.name = string == null ? "" : I18NConvert.instance().compose(string);
        byte[] byArray2 = null;
        try {
            byArray2 = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        this.nameBytes = byArray2;
        this.urns = set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
        this.ggepData = gGEPContainer == null ? GGEPContainer.EMPTY : gGEPContainer;
        this.extBytes = byArray != null ? byArray : Response.createExtBytes(this.urns, this.ggepData);
        this.document = limeXMLDocument;
    }

    public static Response createFromStream(InputStream inputStream) throws IOException {
        int n;
        long l = ByteOrder.uint2long(ByteOrder.leb2int(inputStream));
        long l2 = ByteOrder.uint2long(ByteOrder.leb2int(inputStream));
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + l);
        }
        if (l2 > Integer.MAX_VALUE || l2 < 0L) {
            throw new IOException("invalid size: " + l2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        if (string.length() == 0) {
            throw new IOException("empty name in response");
        }
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray == null || byArray.length == 0) {
            if (inputStream.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(l, l2, string);
        }
        HUGEExtension hUGEExtension = new HUGEExtension(byArray);
        Set set = hUGEExtension.getURNS();
        LimeXMLDocument limeXMLDocument = null;
        Iterator iterator = hUGEExtension.getMiscBlocks().iterator();
        while (iterator.hasNext() && limeXMLDocument == null) {
            limeXMLDocument = Response.createXmlDocument(string, (String)iterator.next());
        }
        GGEPContainer gGEPContainer = GGEPUtil.getGGEP(hUGEExtension.getGGEP());
        return new Response(l, l2, string, set, limeXMLDocument, gGEPContainer, byArray);
    }

    private static LimeXMLDocument createXmlDocument(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() < 2) {
            return null;
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string3 != null) {
            string3 = string3.toLowerCase();
        }
        if (string4 != null) {
            string4 = string4.toLowerCase();
        }
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string4.startsWith(KBPS)) {
            bl = true;
        } else if (string3.endsWith(KBPS)) {
            bl2 = true;
        }
        if (bl) {
            string6 = string3;
        } else if (bl2) {
            n = string3.indexOf(KBPS);
            string6 = string3.substring(0, n);
        }
        if (bl || bl2) {
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        } else if (string2.endsWith(KHZ)) {
            bl3 = true;
            string5 = string3;
            n = string4.indexOf(KBPS);
            if (n > -1) {
                string6 = string4.substring(0, n);
            } else {
                bl3 = false;
            }
        }
        try {
            Integer.parseInt(string6);
            Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (bl || bl2 || bl3) {
            ArrayList<NameValue> arrayList = new ArrayList<NameValue>(3);
            arrayList.add(new NameValue("audios__audio__title__", string));
            arrayList.add(new NameValue("audios__audio__bitrate__", string6));
            arrayList.add(new NameValue("audios__audio__seconds__", string5));
            return new LimeXMLDocument(arrayList, AudioMetaData.schemaURI);
        }
        return null;
    }

    private static byte[] createExtBytes(Set set, GGEPContainer gGEPContainer) {
        try {
            if (Response.isEmpty(set) && gGEPContainer.isEmpty()) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!Response.isEmpty(set)) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    URN uRN = (URN)iterator.next();
                    Assert.that(uRN != null, "Null URN");
                    byteArrayOutputStream.write(uRN.toString().getBytes());
                    if (!iterator.hasNext()) continue;
                    byteArrayOutputStream.write(28);
                }
                if (!gGEPContainer.isEmpty()) {
                    byteArrayOutputStream.write(28);
                }
            }
            if (!gGEPContainer.isEmpty()) {
                GGEPUtil.addGGEP(byteArrayOutputStream, gGEPContainer);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getAsEndpoints(AlternateLocationCollection alternateLocationCollection) {
        if (alternateLocationCollection == null || !alternateLocationCollection.hasAlternateLocations()) {
            return Collections.EMPTY_SET;
        }
        long l = System.currentTimeMillis();
        AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            HashSet<IpPort> hashSet = null;
            int n = 0;
            Iterator iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext() && n < 10) {
                Object e = iterator.next();
                if (!(e instanceof DirectAltLoc)) continue;
                DirectAltLoc directAltLoc = (DirectAltLoc)e;
                if (directAltLoc.canBeSent(2)) {
                    IpPort ipPort = directAltLoc.getHost();
                    if (NetworkUtils.isMe(ipPort)) continue;
                    if (hashSet == null) {
                        hashSet = new HashSet<IpPort>();
                    }
                    if (!(ipPort instanceof Endpoint)) {
                        ipPort = new Endpoint(ipPort.getAddress(), ipPort.getPort());
                    }
                    hashSet.add(ipPort);
                    ++n;
                    directAltLoc.send(l, 2);
                    continue;
                }
                if (directAltLoc.canBeSentAny()) continue;
                iterator.remove();
            }
            return hashSet == null ? Collections.EMPTY_SET : hashSet;
        }
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        ByteOrder.int2leb((int)this.index, outputStream);
        ByteOrder.int2leb((int)this.size, outputStream);
        int n = 0;
        while (n < this.nameBytes.length) {
            outputStream.write(this.nameBytes[n]);
            ++n;
        }
        outputStream.write(0);
        n = 0;
        while (n < this.extBytes.length) {
            outputStream.write(this.extBytes[n]);
            ++n;
        }
        outputStream.write(0);
    }

    public void setDocument(LimeXMLDocument limeXMLDocument) {
        this.document = limeXMLDocument;
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public Set getUrns() {
        return this.urns;
    }

    public Set getLocations() {
        return this.ggepData.locations;
    }

    public long getCreateTime() {
        return this.ggepData.createTime;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData hostData) {
        RemoteFileDesc remoteFileDesc;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == hostData.getPort() && this.cachedRFD.getHost().equals(hostData.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = remoteFileDesc = new RemoteFileDesc(hostData.getIP(), hostData.getPort(), this.getIndex(), this.getName(), (int)this.getSize(), hostData.getClientGUID(), hostData.getSpeed(), hostData.isChatEnabled(), hostData.getQuality(), hostData.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), hostData.isReplyToMulticastQuery(), hostData.isFirewalled(), hostData.getVendorCode(), System.currentTimeMillis(), hostData.getPushProxies(), this.getCreateTime(), hostData.getFWTVersionSupported());
        return remoteFileDesc;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        return this.getIndex() == response.getIndex() && this.getSize() == response.getSize() && this.getName().equals(response.getName()) && (this.getDocument() == null ? response.getDocument() == null : this.getDocument().equals(response.getDocument())) && this.getUrns().equals(response.getUrns());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }

    private static class GGEPUtil {
        GGEPUtil() {
        }

        static void addGGEP(OutputStream outputStream, GGEPContainer gGEPContainer) throws IOException {
            if (gGEPContainer == null || gGEPContainer.locations.size() == 0 && gGEPContainer.createTime <= 0L) {
                throw new NullPointerException("null or empty locations");
            }
            GGEP gGEP = new GGEP();
            if (gGEPContainer.locations.size() > 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    Iterator iterator = gGEPContainer.locations.iterator();
                    while (iterator.hasNext()) {
                        try {
                            Endpoint endpoint = (Endpoint)iterator.next();
                            byteArrayOutputStream.write(endpoint.getHostBytes());
                            ByteOrder.short2leb((short)endpoint.getPort(), byteArrayOutputStream);
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
                gGEP.put("ALT", byteArrayOutputStream.toByteArray());
            }
            if (gGEPContainer.createTime > 0L) {
                gGEP.put("CT", gGEPContainer.createTime / 1000L);
            }
            gGEP.write(outputStream);
        }

        static GGEPContainer getGGEP(GGEP gGEP) {
            if (gGEP == null) {
                return GGEPContainer.EMPTY;
            }
            Set set = null;
            long l = -1L;
            if (gGEP.hasKey("ALT")) {
                try {
                    set = GGEPUtil.parseLocations(gGEP.getBytes("ALT"));
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {}
            }
            if (gGEP.hasKey("CT")) {
                try {
                    l = gGEP.getLong("CT") * 1000L;
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {}
            }
            return set == null && l == -1L ? GGEPContainer.EMPTY : new GGEPContainer(set, l);
        }

        private static Set parseLocations(byte[] byArray) {
            HashSet<Endpoint> hashSet = null;
            IPFilter iPFilter = IPFilter.instance();
            if (byArray.length % 6 == 0) {
                int n = 0;
                while (n < byArray.length) {
                    int n2 = ByteOrder.ushort2int(ByteOrder.leb2short(byArray, n + 4));
                    if (NetworkUtils.isValidPort(n2)) {
                        byte[] byArray2 = new byte[]{byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]};
                        if (NetworkUtils.isValidAddress(byArray2) && iPFilter.allow(byArray2) && !NetworkUtils.isMe(byArray2, n2)) {
                            if (hashSet == null) {
                                hashSet = new HashSet<Endpoint>();
                            }
                            hashSet.add(new Endpoint(byArray2, n2));
                        }
                    }
                    n += 6;
                }
            }
            return hashSet;
        }
    }

    static final class GGEPContainer {
        final Set locations;
        final long createTime;
        private static final GGEPContainer EMPTY = new GGEPContainer();

        private GGEPContainer() {
            this(null, -1L);
        }

        GGEPContainer(Set set, long l) {
            this.locations = set == null ? Collections.EMPTY_SET : set;
            this.createTime = l;
        }

        boolean isEmpty() {
            return this.locations.isEmpty() && this.createTime <= 0L;
        }
    }
}

