/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;

public class AqEvent {
    private static Map stateCache = new Hashtable();
    private static int currentLocalIndex = -1;
    private static final String kSep = "<aq/>";
    protected static final int kLWEventQueryResult = 1;
    protected static final int kLWEventConnectionInitialized = 2;
    protected static final int kLWEventConnectionClosed = 3;
    protected static final int kLWEventConnectionsUpdated = 4;
    protected static final int kLWEventAddDownload = 5;
    protected static final int kLWEventRemoveDownload = 6;
    protected static final int kLWEventUpdateDownloadStats = 7;
    protected static final int kLWEventDownloadsUpdated = 8;
    protected static final int kLWEventAddUpload = 9;
    protected static final int kLWEventRemoveUpload = 10;
    protected static final int kLWEventUpdateUploadStats = 11;
    protected static final int kLWEventUploadsUpdated = 12;
    protected static final int kLWEventAddSharedFile = 13;
    protected static final int kLWEventCoreConnected = 97;
    protected static final int kLWEventCoreSettingRequest = 98;
    protected static final int kLWEventCoreInitialized = 99;

    private static String decodeXMLString(String string) {
        if (string == null) {
            return "";
        }
        string = StringUtils.replace(string, "&amp;", "&");
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&apos;", "'");
        string = StringUtils.replace(string, "&quot;", "\"");
        return string;
    }

    protected static void signalEvent(int n) {
        AqEvent.signalEvent(n, null, null, null);
    }

    protected static void signalEvent(int n, Object object) {
        AqEvent.signalEvent(n, object, null, null);
    }

    protected static void signalEvent(int n, Object object, Object object2) {
        AqEvent.signalEvent(n, object, object2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void signalEvent(int n, Object object, Object object2, Object object3) {
        String string = null;
        try {
            switch (n) {
                case 1: {
                    Object object4;
                    String string2;
                    RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
                    HostData hostData = (HostData)object2;
                    Set set = (Set)object3;
                    Object object5 = AqEventHandler.queriesToIndices;
                    synchronized (object5) {
                        string2 = (String)AqEventHandler.queriesToIndices.get(new GUID(hostData.getMessageGUID()));
                    }
                    object5 = String.valueOf(++currentLocalIndex);
                    String string3 = String.valueOf(string2) + ":" + (String)object5;
                    Map map = AqEventHandler.queryGUIDs;
                    synchronized (map) {
                        AqEventHandler.queryGUIDs.put(string3, new GUID(hostData.getMessageGUID()));
                    }
                    map = AqEventHandler.responses;
                    synchronized (map) {
                        AqEventHandler.responses.put(string3, remoteFileDesc);
                    }
                    map = AqEventHandler.alts;
                    synchronized (map) {
                        AqEventHandler.alts.put(string3, set);
                    }
                    int n2 = 0;
                    int n3 = 0;
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    if (remoteFileDesc.getXMLDocument() != null) {
                        String string7;
                        object4 = remoteFileDesc.getXMLDocument();
                        String string8 = ((LimeXMLDocument)object4).getValue("audios__audio__bitrate__");
                        if (string8 != null) {
                            try {
                                n2 = new Integer(string8);
                            }
                            catch (Exception exception) {}
                            if (n2 > 320) {
                                n2 = 0;
                            }
                        }
                        if ((string7 = ((LimeXMLDocument)object4).getValue("audios__audio__seconds__")) != null) {
                            try {
                                n3 = new Integer(string7);
                            }
                            catch (Exception exception) {}
                            if (n3 > 86400) {
                                n3 = 0;
                            }
                        }
                        string4 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__artist__"));
                        string5 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__album__"));
                        string6 = AqEvent.decodeXMLString(((LimeXMLDocument)object4).getValue("audios__audio__title__"));
                        if (((LimeXMLDocument)object4).getLicenseString() != null) {
                            string4 = "<" + ((LimeXMLDocument)object4).getLicenseString() + "> " + string4;
                        }
                    }
                    object4 = String.valueOf(hostData.getIP()) + ":" + hostData.getPort();
                    int n4 = hostData.isBrowseHostEnabled() ? 1 : 0;
                    string = String.valueOf(n) + kSep + string2 + kSep + (String)object5 + kSep + set.size() + kSep + (String)object4 + kSep + n4 + kSep + remoteFileDesc.getSHA1Urn() + kSep + remoteFileDesc.getFileName() + kSep + remoteFileDesc.getSpeed() + kSep + remoteFileDesc.getSize() + kSep + n2 + kSep + n3 + kSep + string4 + kSep + string5 + kSep + string6;
                    break;
                }
                case 2: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    String string9 = new Locale(managedConnection.getLocalePref(), "").getDisplayLanguage();
                    String string10 = managedConnection.isSupernodeClientConnection() ? "Leaf" : (managedConnection.isClientSupernodeConnection() ? "Ultrapeer" : (managedConnection.isSupernodeSupernodeConnection() ? "Peer" : "Standard"));
                    string = String.valueOf(n) + kSep + managedConnection.getAddress() + ":" + managedConnection.getPort() + kSep + managedConnection.getUserAgent() + kSep + string9 + kSep + string10;
                    break;
                }
                case 3: {
                    ManagedConnection managedConnection = (ManagedConnection)object;
                    string = String.valueOf(n) + kSep + managedConnection.getAddress() + ":" + managedConnection.getPort();
                    break;
                }
                case 5: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode() + kSep + managedDownloader.getSaveFile().getName() + kSep + managedDownloader.getState() + kSep + managedDownloader.getContentLength() + kSep + managedDownloader.getAmountRead() + kSep + managedDownloader.getSHA1Urn();
                    break;
                }
                case 6: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode();
                    stateCache.remove("" + managedDownloader.hashCode());
                    if (managedDownloader.isManualCanceled() && managedDownloader.getFile() != null) {
                        managedDownloader.getFile().delete();
                    }
                    break;
                }
                case 7: {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object;
                    float f = managedDownloader.getMeasuredBandwidth() * 1024.0f;
                    float f2 = managedDownloader.getAverageBandwidth() * 1024.0f;
                    String string11 = managedDownloader.getFile() != null ? managedDownloader.getFile().getAbsolutePath() : "";
                    string = String.valueOf(n) + kSep + managedDownloader.hashCode() + kSep + managedDownloader.getState() + kSep + managedDownloader.getContentLength() + kSep + managedDownloader.getAmountRead() + kSep + f + kSep + f2 + kSep + managedDownloader.getNumHosts() + kSep + managedDownloader.getBusyHostCount() + kSep + managedDownloader.getPossibleHostCount() + kSep + managedDownloader.getQueuedHostCount() + kSep + string11 + kSep + managedDownloader.getActiveHostAddresses();
                    String string12 = "" + managedDownloader.hashCode();
                    if (string.equals((String)stateCache.get(string12))) {
                        string = null;
                        break;
                    }
                    stateCache.put(string12, string);
                    break;
                }
                case 9: {
                    Uploader uploader = (Uploader)object;
                    String string13 = uploader.getFileDesc() != null ? uploader.getFileDesc().getPath() : "";
                    int n5 = uploader.isBrowseHostEnabled() ? 1 : 0;
                    string = String.valueOf(n) + kSep + uploader.hashCode() + kSep + uploader.getFileName() + kSep + uploader.getHost() + kSep + uploader.getGnutellaPort() + kSep + uploader.getUserAgent() + kSep + uploader.getState() + kSep + uploader.getFileSize() + kSep + uploader.getTotalAmountUploaded() + kSep + string13 + kSep + n5;
                    break;
                }
                case 10: {
                    Uploader uploader = (Uploader)object;
                    string = String.valueOf(n) + kSep + uploader.hashCode();
                    stateCache.remove("" + uploader.hashCode());
                    break;
                }
                case 11: {
                    Uploader uploader = (Uploader)object;
                    float f = 0.0f;
                    float f3 = 0.0f;
                    try {
                        f = uploader.getMeasuredBandwidth() * 1024.0f;
                        f3 = uploader.getAverageBandwidth() * 1024.0f;
                    }
                    catch (InsufficientDataException insufficientDataException) {}
                    string = String.valueOf(n) + kSep + uploader.hashCode() + kSep + uploader.getState() + kSep + uploader.getFileSize() + kSep + uploader.getTotalAmountUploaded() + kSep + f + kSep + f3;
                    String string14 = "" + uploader.hashCode();
                    if (string.equals((String)stateCache.get(string14))) {
                        string = null;
                        break;
                    }
                    stateCache.put(string14, string);
                    break;
                }
                case 13: {
                    FileDesc fileDesc = (FileDesc)object;
                    string = String.valueOf(n) + kSep + fileDesc.getSHA1Urn();
                    break;
                }
                default: {
                    String string15 = object != null ? kSep + object : "";
                    String string16 = object2 != null ? kSep + object2 : "";
                    String string17 = object3 != null ? kSep + object3 : "";
                    string = String.valueOf(n) + string15 + string16 + string17;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            AqMain.writeEvent(string);
        }
    }
}

