/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.util.CommonUtils;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private static final boolean USE_CRYPTIX = CommonUtils.isJaguarOrAbove();
    private static final byte[] MARKER;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private ArrayList nodes = new ArrayList();

    static {
        if (USE_CRYPTIX) {
            try {
                Class<?> clazz = Class.forName("cryptix.jce.provider.CryptixCrypto");
                Object obj = clazz.newInstance();
                Security.addProvider((Provider)obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorService.error(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorService.error(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                ErrorService.error(instantiationException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                ErrorService.error(exceptionInInitializerError);
            }
            catch (SecurityException securityException) {
                ErrorService.error(securityException);
            }
            catch (ClassCastException classCastException) {
                ErrorService.error(classCastException);
            }
        }
        MARKER = new byte[0];
    }

    public TigerTree() {
        super("tigertree");
        if (USE_CRYPTIX) {
            try {
                this.tiger = MessageDigest.getInstance("Tiger", "CryptixCrypto");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.tiger = new Tiger();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                this.tiger = new Tiger();
            }
        } else {
            this.tiger = new Tiger();
        }
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.byteCount += (long)n2;
        this.nodes.ensureCapacity(TigerTree.log2Ceil(this.byteCount / 1024L));
        if (this.bufferOffset > 0) {
            int n3 = 1024 - this.bufferOffset;
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.blockUpdate();
            this.bufferOffset = 0;
            n2 -= n3;
            n += n3;
        }
        while (n2 >= 1024) {
            this.blockUpdate(byArray, n, 1024);
            n2 -= 1024;
            n += 1024;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufferOffset = n2;
        }
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        byte[] byArray2 = this.collapse();
        Assert.that(byArray2 != MARKER);
        System.arraycopy(byArray2, 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    private byte[] collapse() {
        byte[] byArray = null;
        int n = 0;
        while (n < this.nodes.size()) {
            byte[] byArray2 = (byte[])this.nodes.get(n);
            if (byArray2 != MARKER) {
                if (byArray == null) {
                    byArray = byArray2;
                } else {
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(byArray2);
                    this.tiger.update(byArray);
                    byArray = this.tiger.digest();
                }
                this.nodes.set(n, MARKER);
            }
            ++n;
        }
        Assert.that(byArray != null);
        return byArray;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new ArrayList();
        this.tiger.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.blockUpdate(this.buffer, 0, this.bufferOffset);
    }

    protected void blockUpdate(byte[] byArray, int n, int n2) {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(byArray, n, n2);
        if (n2 == 0 && this.nodes.size() > 0) {
            return;
        }
        byte[] byArray2 = this.tiger.digest();
        this.push(byArray2);
    }

    private void push(byte[] byArray) {
        if (!this.nodes.isEmpty()) {
            int n = 0;
            while (n < this.nodes.size()) {
                byte[] byArray2 = (byte[])this.nodes.get(n);
                if (byArray2 == MARKER) {
                    this.nodes.set(n, byArray);
                    return;
                }
                this.tiger.reset();
                this.tiger.update((byte)1);
                this.tiger.update(byArray2);
                this.tiger.update(byArray);
                byArray = this.tiger.digest();
                this.nodes.set(n, MARKER);
                ++n;
            }
        }
        this.nodes.add(byArray);
    }

    public static int log2Ceil(long l) {
        int n = 0;
        while (l > 1L) {
            ++l;
            l >>>= 1;
            ++n;
        }
        return n;
    }
}

