/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HeadPing
extends VendorMessage {
    public static final int VERSION = 1;
    public static final int PLAIN = 0;
    public static final int INTERVALS = 1;
    public static final int ALT_LOCS = 2;
    public static final int PUSH_ALTLOCS = 4;
    public static final int FWT_PUSH_ALTLOCS = 8;
    public static final int GGEP_PING = 16;
    private static final String GGEP_PUSH = "PUSH";
    public static final int FEATURE_MASK = 31;
    private final URN _urn;
    private final byte _features;
    private GGEP _ggep;
    private final GUID _clientGUID;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HeadPing(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        GGEP gGEP;
        block13: {
            super(byArray, by, by2, F_LIME_VENDOR_ID, 23, n, byArray2);
            if (this.getVersion() == 1 && (byArray2 == null || byArray2.length < 42)) {
                throw new BadPacketException();
            }
            this._features = (byte)(byArray2[0] & 0x1F);
            String string = new String(byArray2, 1, 41);
            if (!URN.isUrn(string)) {
                throw new BadPacketException("udp head request did not contain an urn");
            }
            URN uRN = null;
            try {
                try {
                    uRN = URN.createSHA1Urn(string);
                }
                catch (IOException iOException) {
                    throw new BadPacketException("failed to parse an urn");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this._urn = uRN;
                throw throwable;
            }
            {
                gGEP = null;
                this._urn = uRN;
                gGEP = null;
                if ((this._features & 0x10) != 16) break block13;
            }
            if (byArray2.length < 43) {
                throw new BadPacketException("no ggep was found.");
            }
            try {
                gGEP = new GGEP(byArray2, 42, null);
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                throw new BadPacketException("invalid ggep block");
            }
        }
        this._ggep = gGEP;
        GUID gUID = null;
        if (this._ggep != null) {
            try {
                gUID = new GUID(this._ggep.getBytes(GGEP_PUSH));
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {}
        }
        this._clientGUID = gUID;
    }

    public HeadPing(GUID gUID, URN uRN, int n) {
        this(gUID, uRN, null, n);
    }

    public HeadPing(GUID gUID, URN uRN, GUID gUID2, int n) {
        super(F_LIME_VENDOR_ID, 23, 1, HeadPing.derivePayload(uRN, gUID2, n));
        this._features = (byte)(n & 0x1F);
        this._urn = uRN;
        this._clientGUID = gUID2;
        this.setGUID(gUID);
    }

    public HeadPing(URN uRN) {
        this(new GUID(GUID.makeGuid()), uRN, 0);
    }

    public HeadPing(HeadPing headPing) {
        super(F_LIME_VENDOR_ID, 23, 1, headPing.getPayload());
        this._features = headPing.getFeatures();
        this._urn = headPing.getUrn();
        this._clientGUID = headPing.getClientGuid();
        this.setGUID(new GUID(headPing.getGUID()));
    }

    private static byte[] derivePayload(URN uRN, GUID gUID, int n) {
        n &= 0x1F;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        String string = uRN.httpStringValue();
        GGEP gGEP = null;
        if (gUID != null) {
            n |= 0x10;
            gGEP = new GGEP(true);
            gGEP.put(GGEP_PUSH, gUID.bytes());
        }
        try {
            dataOutputStream.writeByte(n);
            dataOutputStream.writeBytes(string);
            if (gGEP != null) {
                gGEP.write(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public URN getUrn() {
        return this._urn;
    }

    public boolean requestsRanges() {
        return (this._features & 1) == 1;
    }

    public boolean requestsAltlocs() {
        return (this._features & 2) == 2;
    }

    public boolean requestsPushLocs() {
        return (this._features & 4) == 4;
    }

    public boolean requestsFWTPushLocs() {
        return (this._features & 8) == 8;
    }

    public byte getFeatures() {
        return this._features;
    }

    public GUID getClientGuid() {
        return this._clientGUID;
    }
}

