/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseConstants {
    public static final int NO_LICENSE = 0;
    public static final int CC_LICENSE = 1;
    public static final int WEED_LICENSE = 2;
    public static final int DRM_LICENSE = 3;
    public static final int GPL = 4;
    public static final int LGPL = 5;
    public static final int APACHE_BSD = 6;
    public static final int MIT_X = 7;
    public static final int FDL = 8;
    public static final int ARTISTIC = 9;
    public static final int PUBLIC_DOMAIN = 10;
    public static final int SHAREWARE = 11;
    private static final String[] LICENSE_DESCS;
    private static final Map LICENSE_DESC_CACHE;

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.add("creativecommons.org/licenses/");
        arrayList.add("http://www.shmedlic.com/license/3play.aspx");
        arrayList.add("");
        arrayList.add("http://www.gnu.org/copyleft/gpl.html");
        arrayList.add("http://www.gnu.org/copyleft/lgpl.html");
        arrayList.add("http://opensource.org/licenses/apache2.0.php");
        arrayList.add("http://opensource.org/licenses/mit-license.php");
        arrayList.add("http://www.gnu.org/copyleft/fdl.html");
        arrayList.add("http://www.opensource.org/licenses/artistic-license.php");
        arrayList.add("http://www.public-domain.org");
        arrayList.add("http://en.wikipedia.org/wiki/Shareware");
        LICENSE_DESCS = arrayList.toArray(new String[0]);
        LICENSE_DESC_CACHE = new HashMap();
    }

    public static List getIndivisible(int n) {
        if (n >= LICENSE_DESCS.length) {
            return Collections.EMPTY_LIST;
        }
        if (n == 0 || n == 3) {
            return Collections.EMPTY_LIST;
        }
        Integer n2 = new Integer(n);
        List<String> list = (ArrayList<String>)LICENSE_DESC_CACHE.get(n2);
        if (list != null) {
            return list;
        }
        list = new ArrayList<String>(1);
        list.add(LICENSE_DESCS[n]);
        list = Collections.unmodifiableList(list);
        LICENSE_DESC_CACHE.put(n2, list);
        return list;
    }

    public static int determineLicenseType(String string, String string2) {
        if (LicenseConstants.hasCCLicense(string, string2)) {
            return 1;
        }
        if (LicenseConstants.hasWeedLicense(string2)) {
            return 2;
        }
        if (LicenseConstants.hasDRMLicense(string2)) {
            return 3;
        }
        int n = 0;
        while (n < LICENSE_DESCS.length) {
            if (LICENSE_DESCS[n].equals(string2)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private static boolean hasCCLicense(String string, String string2) {
        return string2 != null && string2.equals("creativecommons.org/licenses/") || string != null && string.indexOf("creativecommons.org/licenses/") != -1 && string.indexOf("verify at") != -1;
    }

    private static boolean hasWeedLicense(String string) {
        return string != null && string.startsWith("http://www.shmedlic.com/license/3play.aspx") && string.indexOf(" vid: ") != -1 && string.indexOf(" cid: ") != -1;
    }

    private static boolean hasDRMLicense(String string) {
        return string != null && string.startsWith("licensed: ");
    }

    public static boolean isDRMLicense(int n) {
        return n == 2 || n == 3;
    }
}

