/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.Container;
import com.limegroup.gnutella.settings.Settings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

public class LibraryData
implements Settings {
    private final Container DATA = new Container("library.dat");
    public final Set DIRECTORIES_NOT_TO_SHARE = this.DATA.getSet("DIRECTORIES_NOT_TO_SHARE");
    public final Set SENSITIVE_DIRECTORIES_VALIDATED = this.DATA.getSet("SENSITIVE_DIRECTORIES_VALIDATED");
    public final Set SENSITIVE_DIRECTORIES_NOT_TO_SHARE = this.DATA.getSet("SENSITIVE_DIRECTORIES_NOT_TO_SHARE");
    public final Set SPECIAL_FILES_TO_SHARE = this.DATA.getSet("SPECIAL_FILES_TO_SHARE");
    public final Set FILES_NOT_TO_SHARE = this.DATA.getSet("FILES_NOT_TO_SHARE");
    private boolean shouldSave = true;

    public LibraryData() {
        SettingsHandler.addSettings(this);
    }

    public void save() {
        if (this.shouldSave) {
            this.DATA.save();
        }
    }

    public void revertToDefault() {
        this.DATA.clear();
    }

    public void setShouldSave(boolean bl) {
        this.shouldSave = bl;
    }

    public void reload() {
        this.DATA.load();
    }

    public final void clean() {
        SharingSettings.DIRECTORIES_TO_SHARE.clean();
        Set set = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
        this.clean(this.DIRECTORIES_NOT_TO_SHARE, set);
        this.clean(this.FILES_NOT_TO_SHARE, set);
        this.clean(this.SENSITIVE_DIRECTORIES_VALIDATED, set);
        this.clean(this.SENSITIVE_DIRECTORIES_NOT_TO_SHARE, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(Set set, Set set2) {
        Set set3 = set;
        synchronized (set3) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof File)) {
                    iterator.remove();
                    continue;
                }
                File file = (File)e;
                if (!file.exists()) {
                    iterator.remove();
                    continue;
                }
                if (set2 == null || this.containsParent(file, set2)) continue;
                iterator.remove();
            }
        }
    }

    private boolean containsParent(File file, Set set) {
        while (file != null) {
            if (set.contains(file)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }
}

