/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.FixedSizeSortedSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

public class AlternateLocationCollection
implements HTTPHeaderValue {
    private static final int MAX_SIZE = 100;
    public static final AlternateLocationCollection EMPTY;
    private final FixedSizeSortedSet LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;
    static /* synthetic */ Class class$0;

    static {
        EmptyCollection emptyCollection = null;
        try {
            emptyCollection = new EmptyCollection();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        EMPTY = emptyCollection;
    }

    public static AlternateLocationCollection create(URN uRN) {
        return new AlternateLocationCollection(uRN);
    }

    public static AlternateLocationCollection createCollectionFromHttpValue(String string) {
        if (string == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        AlternateLocationCollection alternateLocationCollection = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                AlternateLocation alternateLocation = AlternateLocation.create(string2);
                if (alternateLocationCollection == null) {
                    alternateLocationCollection = new AlternateLocationCollection(alternateLocation.getSHA1Urn());
                }
                if (!alternateLocation.getSHA1Urn().equals(alternateLocationCollection.getSHA1Urn())) continue;
                alternateLocationCollection.add(alternateLocation);
            }
            catch (IOException iOException) {}
        }
        return alternateLocationCollection;
    }

    private AlternateLocationCollection(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null URN");
        }
        if (uRN != null && !uRN.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = uRN;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation2 = (AlternateLocation)this.LOCATIONS.get(alternateLocation);
            boolean bl = false;
            if (alternateLocation2 == null) {
                bl = true;
                this.LOCATIONS.add(alternateLocation);
            } else {
                this.LOCATIONS.remove(alternateLocation2);
                alternateLocation2.increment();
                alternateLocation2.promote();
                alternateLocation2.resetSent();
                bl = false;
                this.LOCATIONS.add(alternateLocation2);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation2;
            block7: {
                block6: {
                    alternateLocation2 = (AlternateLocation)this.LOCATIONS.get(alternateLocation);
                    if (alternateLocation2 != null) break block6;
                    return false;
                }
                if (!alternateLocation2.isDemoted()) break block7;
                this.LOCATIONS.remove(alternateLocation2);
                return true;
            }
            this.LOCATIONS.remove(alternateLocation2);
            alternateLocation2.demote();
            this.LOCATIONS.add(alternateLocation2);
            return false;
        }
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation alternateLocation) {
        return this.LOCATIONS.contains(alternateLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String httpStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iterator = this.LOCATIONS.iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.httpStringValue());
                stringBuffer.append(", ");
                bl = true;
            }
        }
        if (bl) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    public Iterator iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            Iterator iterator = this.LOCATIONS.iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = (AlternateLocationCollection)object;
        boolean bl = this.SHA1.equals(alternateLocationCollection.SHA1);
        if (!bl) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.altlocs.AlternateLocationCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            AlternateLocationCollection alternateLocationCollection2 = this;
            synchronized (alternateLocationCollection2) {
                AlternateLocationCollection alternateLocationCollection3 = alternateLocationCollection;
                synchronized (alternateLocationCollection3) {
                    bl = this.LOCATIONS.equals(alternateLocationCollection.LOCATIONS);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl;
        }
    }

    /* synthetic */ AlternateLocationCollection(URN uRN, AlternateLocationCollection alternateLocationCollection) {
        this(uRN);
    }

    private static class EmptyCollection
    extends AlternateLocationCollection {
        EmptyCollection() throws IOException {
            super(URN.createSHA1Urn("urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"), null);
        }

        public boolean add(AlternateLocation alternateLocation) {
            throw new UnsupportedOperationException();
        }
    }
}

