/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.FileInputStream;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.random.PureSpinner;
import org.logi.crypto.random.RandomFromStream;
import org.logi.crypto.random.RandomMD5;
import org.logi.crypto.test.TestIterate;

public class TestRandom
extends Crypto {
    private static int minL = 4;
    private static int maxL = 10;
    private static long randBuf;
    private static double[] mu;
    private static double[] sigma2;
    private static double limitFractile;

    private static void printTime(long l) {
        System.out.println("Time: " + l / 1000L + "." + l % 1000L + " s");
    }

    private static boolean test(Random random) throws Exception {
        double d;
        int n;
        boolean bl = true;
        byte[] byArray = new byte[(int)((randBuf + 999L) / 1000L)];
        System.out.println("Generating " + TestIterate.metricString(randBuf, 1024) + "B");
        DecimalFormat decimalFormat = new DecimalFormat("0.000000000 ");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.0");
        MaurersTest[] maurersTestArray = new MaurersTest[maxL - minL + 1];
        System.out.print("L:\t ");
        int n2 = minL;
        while (n2 <= maxL) {
            maurersTestArray[n2 - TestRandom.minL] = new MaurersTest(n2);
            System.out.print(n2);
            if (n2 < 10) {
                System.out.print(' ');
            }
            System.out.print("           ");
            ++n2;
        }
        System.out.println();
        System.out.print("0%");
        n2 = 0;
        while (n2 < 1000) {
            random.nextBytes(byArray);
            System.out.print('\r');
            if (n2 == 999) {
                System.out.print("X_u  \t");
            } else {
                System.out.print(decimalFormat2.format(0.1 * (double)n2 + 0.1) + "%\t");
            }
            n = minL;
            while (n <= maxL) {
                maurersTestArray[n - minL].feed(byArray);
                d = maurersTestArray[n - minL].result();
                if (d < 10.0) {
                    System.out.print(' ');
                }
                System.out.print(decimalFormat.format(d));
                ++n;
            }
            ++n2;
        }
        System.out.println();
        boolean[] blArray = new boolean[maxL - minL + 1];
        System.out.print("dev.\t");
        n = minL;
        while (n <= maxL) {
            d = maurersTestArray[n - minL].result();
            double d2 = sigma2[n - minL] / (double)maurersTestArray[n - minL].eaten();
            double d3 = Math.abs(d - mu[n - 1]) / Math.sqrt(d2);
            if (d3 < 10.0) {
                System.out.print(' ');
            }
            System.out.print(decimalFormat.format(d3));
            blArray[n - TestRandom.minL] = d3 < limitFractile;
            bl &= blArray[n - minL];
            ++n;
        }
        System.out.println();
        System.out.print("passed\t ");
        n = minL;
        while (n <= maxL) {
            if (blArray[n - minL]) {
                System.out.print("yes          ");
            } else {
                System.out.print("NO!          ");
            }
            ++n;
        }
        System.out.println();
        return bl;
    }

    public static void help(Object object) {
        if (object != null) {
            System.out.println(object);
            System.out.println();
        }
        System.out.println("use: java org.logi.crypto.test.TestRandom [-l n]");
        System.out.println();
        System.out.println("Applies Maurer's test to the random number generators.");
        System.out.println();
        System.out.println("-l sets the block size and should be chosen between 6 and 16,");
        System.out.println(" high for horough testing, low for reasonable running times.");
        System.out.println();
        System.out.println("Note that passing this test does not mean that the generator");
        System.out.println("is good, merely that it doesn't have particular bad statistical");
        System.out.println("properties. In particular, the java.util.Random class passes");
        System.out.println("the test but is *not* useful for cryptographic purposes.");
        System.out.println();
        System.out.println("Similarly, the PureSpinner does *not* pass the test and is in");
        System.out.println("fact not a good generator on its own. However, it collects");
        System.out.println("entropy from the environment, so it can increase the");
        System.out.println("unpredictability of e.g. RandomMD5.");
        System.out.println();
        System.out.println("Finally, even God's Own Dice will sometimes fail the test.");
        System.out.println("Perversely, since a random bit generator is equally likely to");
        System.out.println("generate *any* sequence at all by definition, it is quite");
        System.out.println("capable of generating a sequence which will fail the test.");
        System.out.println("However, this is *very* unlikely. If you see it twice I want");
        System.out.println("to know.");
        System.out.println();
        System.out.println("The usefullness of this program is left as an excercise for");
        System.out.println("the reader.");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Random random;
        Crypto.initRandom();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-h")) {
                TestRandom.help(null);
            } else if (stringArray[n].equals("-f")) {
                bl = true;
            } else {
                if (n + 1 == stringArray.length) {
                    TestRandom.help("Invalid parameters");
                }
                if (stringArray[n].equals("-l")) {
                    try {
                        maxL = Integer.parseInt(stringArray[n + 1]);
                    }
                    catch (Exception exception) {
                        TestRandom.help(exception);
                    }
                } else {
                    TestRandom.help("Invalid parameters");
                }
                ++n;
            }
            ++n;
        }
        if (!bl && maxL < 6) {
            TestRandom.help("You must give a -l parameter of at least 6.");
        }
        if (maxL > 16) {
            TestRandom.help("The maximum block-length is 16 bits.");
        }
        randBuf = maxL * 10110 * (1 << maxL);
        try {
            System.out.println();
            System.out.print("Initializing java.util.Random\t");
            long l = System.currentTimeMillis();
            random = new Random();
            long l2 = System.currentTimeMillis();
            TestRandom.printTime(l2 - l);
            TestRandom.test(random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            System.out.println();
            System.out.print("Initializing org.logi.crypto.random.RandomMD5 (no re-seeding)\t");
            long l = System.currentTimeMillis();
            random = new RandomMD5(new PureSpinner(), 256, 0);
            int n2 = random.nextInt();
            long l3 = System.currentTimeMillis();
            TestRandom.printTime(l3 - l);
            if (!TestRandom.test(random)) {
                System.out.println("The sequence failed one or more tests. This *will* happen occasionally,");
                System.out.println("even with a perfect random bit generator, but very infrequently.");
                System.out.println("If you see it twice you should probably contact the developer");
                System.out.println("of the library.");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            System.out.println();
            System.out.print("Initializing reading of /dev/urandom\t");
            long l = System.currentTimeMillis();
            random = new RandomFromStream(new FileInputStream("/dev/urandom"));
            long l4 = System.currentTimeMillis();
            TestRandom.printTime(l4 - l);
            TestRandom.test(random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            System.out.println();
            System.out.print("Initializing java.security.SecureRandom\t");
            long l = System.currentTimeMillis();
            random = new SecureRandom();
            long l5 = System.currentTimeMillis();
            TestRandom.printTime(l5 - l);
            TestRandom.test(random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            System.out.println();
            System.out.print("Initializing org.logi.crypto.random.PureSpinner\t");
            long l = System.currentTimeMillis();
            random = new PureSpinner();
            long l6 = System.currentTimeMillis();
            TestRandom.printTime(l6 - l);
            System.out.println("(this is not a statistically good RNG but");
            System.out.println(" collects entropy for use in e.g. RandomMD5)");
            TestRandom.test(random);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private TestRandom() {
    }

    static {
        mu = new double[]{0.7326495, 1.5374383, 2.4016068, 3.3112247, 4.2534266, 5.2177052, 6.1962507, 7.1836656, 8.1764218, 9.1723243, 10.170032, 11.168765, 12.16807, 13.167693, 14.167488, 15.167379};
        sigma2 = new double[]{0.69, 1.338, 1.901, 2.358, 2.705, 2.954, 3.125, 3.238, 3.311, 3.356, 3.384, 3.401, 3.41, 3.416, 3.419, 3.421};
        limitFractile = 2.3263;
    }

    private static class MaurersTest {
        long need;
        long N;
        long Q;
        int L;
        long[] T;
        double r;
        int mask;
        int buf;
        int bufL;

        public void feed(byte[] byArray) {
            int n = byArray.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.buf;
            int n5 = this.L - this.bufL;
            while (n5 > 0) {
                if (n5 < 8 - n3) {
                    n4 = n4 << n5 | (byArray[n2] & 0xFF) >> 8 - n5 - n3;
                    n3 += n5;
                    n5 = 0;
                    continue;
                }
                n4 = n4 << 8 - n3 | byArray[n2] & 0xFF;
                n5 -= 8 - n3;
                n3 = 0;
                ++n2;
            }
            n4 &= this.mask;
            while (true) {
                if (this.N < this.Q) {
                    this.T[n4] = this.N;
                } else {
                    this.r += Math.log(this.N - this.T[n4]);
                    this.T[n4] = this.N;
                }
                ++this.N;
                if (8 * (n - n2) - n3 < this.L) break;
                n5 = this.L;
                while (n5 > 0) {
                    if (n5 < 8 - n3) {
                        n4 = n4 << n5 | (byArray[n2] & 0xFF) >> 8 - n5 - n3;
                        n3 += n5;
                        n5 = 0;
                        continue;
                    }
                    n4 = n4 << 8 - n3 | byArray[n2] & 0xFF;
                    n5 -= 8 - n3;
                    n3 = 0;
                    ++n2;
                }
                n4 &= this.mask;
            }
            this.bufL = 8 * (n - n2) - n3;
            n4 = 0;
            n5 = this.bufL;
            while (n5 > 0) {
                if (n5 < 8 - n3) {
                    n4 = n4 << n5 | (byArray[n2] & 0xFF) >> 8 - n5 - n3;
                    n3 += n5;
                    n5 = 0;
                    continue;
                }
                n4 = n4 << 8 - n3 | byArray[n2] & 0xFF;
                n5 -= 8 - n3;
                n3 = 0;
                ++n2;
            }
            this.buf = n4;
        }

        public boolean done() {
            return this.N >= this.need;
        }

        public long eaten() {
            if (this.N <= this.Q) {
                return 0L;
            }
            return this.N - this.Q;
        }

        public double result() {
            return this.r / (double)(this.N - this.Q) / Math.log(2.0);
        }

        public MaurersTest(int n) {
            int n2 = 1 << n;
            this.need = 10110 * n2 * n;
            this.N = 0L;
            this.Q = 10 * n2;
            this.L = n;
            this.T = new long[n2 + 1];
            this.r = 0.0;
            this.mask = n2 - 1;
            this.bufL = 0;
        }
    }
}

