/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.DownloadRetry;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    protected static InputStreamReader reader = null;
    protected static OutputStreamWriter writer = null;
    protected static boolean shouldShutdown = false;

    public static void main(String[] stringArray) {
        try {
            reader = new InputStreamReader(System.in, "UTF-8");
            writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        AqEvent.signalEvent(97);
        AqEventHandler aqEventHandler = new AqEventHandler();
        ErrorService.setErrorCallback(aqEventHandler);
        MessageService.setCallback(aqEventHandler);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        }
        if (!NIODispatcher.instance().isRunning()) {
            AqMain.shutdown();
        }
        AqEvent.signalEvent(98);
        AqMain.readLoop();
        RouterService.shutdown();
        AqMain.shutdown();
    }

    protected static void startup() {
        RouterService routerService = new RouterService((AqEventHandler)ErrorService.getErrorCallback());
        routerService.start();
        RouterService.schedule(new DownloadRetry(), 0x6DDD00L, 0x6DDD00L);
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        AqEvent.signalEvent(99);
    }

    private static void readLoop() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while (!shouldShutdown && (n = reader.read()) != -1) {
                char c = (char)n;
                if (c == '|' || c == '\n') {
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n') continue;
                    try {
                        AqDispatcher.dispatchCommand(linkedList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        block6: {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) break block6;
                OutputStreamWriter outputStreamWriter = writer;
                synchronized (outputStreamWriter) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        System.exit(0);
    }
}

