/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPBufferedOutputStream
extends OutputStream {
    private static final Log LOG;
    private static final int FOREVER = 36000000;
    private ArrayList chunks;
    private byte[] activeChunk;
    private int activeCount;
    private UDPConnectionProcessor _processor;
    private boolean _connectionActive;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.udpconnect.UDPBufferedOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public UDPBufferedOutputStream(UDPConnectionProcessor uDPConnectionProcessor) {
        this._processor = uDPConnectionProcessor;
        this._connectionActive = true;
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
    }

    public synchronized void write(int n) throws IOException {
        if (this._connectionActive && this.getPendingChunks() == 0) {
            this._processor.wakeupWriteEvent();
        }
        while (true) {
            if (!this._connectionActive) {
                throw new IOException("Connection Closed");
            }
            if (this.activeCount < 512) {
                this.activeChunk[this.activeCount] = (byte)n;
                ++this.activeCount;
                return;
            }
            if (this.chunks.size() < this._processor.getChunkLimit()) {
                this.chunks.add(this.activeChunk);
                this.allocateNewChunk();
                continue;
            }
            this.waitOnReader();
            if (this.getPendingChunks() != 0) continue;
            this._processor.wakeupWriteEvent();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("writing len: " + n2 + " bytes"));
        }
        if (this._connectionActive && this.getPendingChunks() == 0) {
            this._processor.wakeupWriteEvent();
        }
        while (true) {
            if (!this._connectionActive) {
                throw new IOException("Connection Closed");
            }
            if (this.activeCount < this.activeChunk.length) {
                int n3 = this.activeChunk.length - this.activeCount;
                int n4 = Math.min(n3, n2);
                System.arraycopy(byArray, n, this.activeChunk, this.activeCount, n4);
                this.activeCount += n4;
                if ((n3 -= n4) > 0) {
                    return;
                }
                n += n4;
                if ((n2 -= n4) > 0) continue;
                return;
            }
            if (this.chunks.size() < this._processor.getChunkLimit()) {
                this.chunks.add(this.activeChunk);
                this.allocateNewChunk();
                continue;
            }
            this.waitOnReader();
            if (this.getPendingChunks() != 0) continue;
            this._processor.wakeupWriteEvent();
        }
    }

    public synchronized void close() throws IOException {
        if (!this._connectionActive) {
            throw new IOException("already closed");
        }
        this._processor.close();
    }

    public void flush() throws IOException {
    }

    private void allocateNewChunk() {
        this.activeChunk = new byte[512];
        this.activeCount = 0;
    }

    synchronized Chunk getChunk() {
        Chunk chunk;
        if (this.chunks.size() > 0) {
            chunk = new Chunk();
            chunk.data = (byte[])this.chunks.remove(0);
            chunk.start = 0;
            chunk.length = chunk.data.length;
        } else if (this.activeCount > 0) {
            chunk = new Chunk();
            chunk.data = this.activeChunk;
            chunk.start = 0;
            chunk.length = this.activeCount;
            this.allocateNewChunk();
        } else {
            return null;
        }
        this.notify();
        return chunk;
    }

    private void waitOnReader() throws IOException {
        try {
            this.wait(36000000L);
        }
        catch (InterruptedException interruptedException) {}
        if (!this._connectionActive) {
            throw new IOException("Connection Closed");
        }
    }

    synchronized void connectionClosed() {
        LOG.debug((Object)"connection closed");
        this._connectionActive = false;
        this.notify();
    }

    synchronized int getPendingChunks() {
        int n = this.chunks.size();
        if (this.activeCount > 0) {
            ++n;
        }
        return n;
    }
}

