/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.BandwidthStat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class StatisticVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    private static final String DELIMITER = " | ";
    private static final String DELIMITER2 = " ^ ";

    public StatisticVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 15, n, byArray2);
    }

    public StatisticVendorMessage(GiveStatsVendorMessage giveStatsVendorMessage) {
        super(F_LIME_VENDOR_ID, 15, 1, StatisticVendorMessage.derivePayload(giveStatsVendorMessage));
    }

    public static boolean isSupported(GiveStatsVendorMessage giveStatsVendorMessage) {
        switch (giveStatsVendorMessage.getStatType()) {
            case 0: 
            case 1: {
                switch (giveStatsVendorMessage.getStatControl()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static byte[] derivePayload(GiveStatsVendorMessage giveStatsVendorMessage) {
        byte[] byArray;
        byte by = giveStatsVendorMessage.getStatControl();
        byte by2 = giveStatsVendorMessage.getStatType();
        byte[] byArray2 = new byte[]{by, by2};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        switch (by2) {
            case 0: 
            case 1: {
                boolean bl = by2 == 0;
                byArray = StatisticVendorMessage.getGnutellaStats(by, bl);
                break;
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.getTotal());
                stringBuffer.append(DELIMITER2);
                stringBuffer.append(BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.getTotal());
                byArray = stringBuffer.toString().getBytes();
                break;
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.getTotal());
                stringBuffer.append(DELIMITER2);
                stringBuffer.append(BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.getTotal());
                byArray = stringBuffer.toString().getBytes();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + by2);
            }
        }
        try {
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] getGnutellaStats(byte by, boolean bl) {
        List list = RouterService.getConnectionManager().getConnections();
        StringBuffer stringBuffer = new StringBuffer();
        switch (by) {
            case 0: {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                    stringBuffer.append(managedConnection.toString());
                    stringBuffer.append(DELIMITER2);
                    if (bl) {
                        stringBuffer.append(managedConnection.getNumMessagesReceived());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumReceivedMessagesDropped());
                    } else {
                        stringBuffer.append(managedConnection.getNumMessagesSent());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumSentMessagesDropped());
                    }
                    stringBuffer.append(DELIMITER2);
                }
                return stringBuffer.toString().getBytes();
            }
            case 1: {
                int n = -1;
                int n2 = -1;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                    n += bl ? managedConnection.getNumMessagesReceived() : managedConnection.getNumMessagesSent();
                    n2 = (int)((long)n2 + (bl ? managedConnection.getNumReceivedMessagesDropped() : (long)managedConnection.getNumSentMessagesDropped()));
                }
                stringBuffer.append(n);
                stringBuffer.append(DELIMITER);
                stringBuffer.append(n2);
                return stringBuffer.toString().getBytes();
            }
            case 3: {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                    if (!managedConnection.isSupernodeConnection()) continue;
                    stringBuffer.append(managedConnection.toString());
                    stringBuffer.append(DELIMITER2);
                    if (bl) {
                        stringBuffer.append(managedConnection.getNumMessagesReceived());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumReceivedMessagesDropped());
                    } else {
                        stringBuffer.append(managedConnection.getNumMessagesSent());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumSentMessagesDropped());
                    }
                    stringBuffer.append(DELIMITER2);
                }
                return stringBuffer.toString().getBytes();
            }
            case 2: {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                    if (!managedConnection.isLeafConnection()) continue;
                    stringBuffer.append(managedConnection.toString());
                    stringBuffer.append(DELIMITER2);
                    if (bl) {
                        stringBuffer.append(managedConnection.getNumMessagesReceived());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumReceivedMessagesDropped());
                    } else {
                        stringBuffer.append(managedConnection.getNumMessagesSent());
                        stringBuffer.append(DELIMITER);
                        stringBuffer.append(managedConnection.getNumSentMessagesDropped());
                    }
                    stringBuffer.append(DELIMITER2);
                }
                return stringBuffer.toString().getBytes();
            }
        }
        throw new IllegalArgumentException("unknown control: " + by);
    }

    public String getReportedStats() {
        return new String(this.getPayload());
    }
}

