/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ByteOrder;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.DESKey;

public final class QueryKey {
    private static SecretKey SECRET_KEY = null;
    private static SecretPad SECRET_PAD = null;
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;

    static {
        Crypto.initRandom();
        SECRET_KEY = new SecretKey();
        SECRET_PAD = new SecretPad();
    }

    private QueryKey(byte[] byArray) throws IllegalArgumentException {
        if (!QueryKey.isValidQueryKeyBytes(byArray)) {
            throw new IllegalArgumentException();
        }
        this._queryKey = new byte[byArray.length];
        System.arraycopy(byArray, 0, this._queryKey, 0, byArray.length);
    }

    public void prepareForNetwork() {
        int n = 0;
        while (n < this._queryKey.length) {
            if (this._queryKey[n] == 28) {
                this._queryKey[n] = -6;
            }
            ++n;
        }
    }

    public static SecretKey generateSecretKey() {
        return new SecretKey();
    }

    public static SecretPad generateSecretPad() {
        return new SecretPad();
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryKey)) {
            return false;
        }
        QueryKey queryKey = (QueryKey)object;
        return Arrays.equals(this._queryKey, queryKey._queryKey);
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this._queryKey[n2] % this._queryKey.length;
            if (n3 < 0) {
                n3 *= -1;
            }
            n += this._queryKey[n3] * 7;
            ++n2;
        }
        return n;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._queryKey);
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(this._queryKey) + "}";
    }

    public static boolean isValidQueryKeyBytes(byte[] byArray) {
        return byArray != null && byArray.length >= 4 && byArray.length <= 16;
    }

    public static QueryKey getQueryKey(byte[] byArray, boolean bl) throws IllegalArgumentException {
        QueryKey queryKey = new QueryKey(byArray);
        if (bl) {
            queryKey.prepareForNetwork();
        }
        return queryKey;
    }

    public static QueryKey getQueryKey(InetAddress inetAddress, int n) {
        return QueryKey.getQueryKey(inetAddress, n, SECRET_KEY, SECRET_PAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static QueryKey getQueryKey(InetAddress var0, int var1_1, SecretKey var2_2, SecretPad var3_3) {
        var4_4 = new byte[8];
        var5_5 = var0.getAddress();
        var6_6 = (short)var1_1;
        var7_7 = new byte[2];
        ByteOrder.short2leb(var6_6, var7_7, 0);
        var8_8 = SecretPad.access$1(var3_3)[0] % 8;
        if (var8_8 < 0) {
            var8_8 *= -1;
        }
        if ((var9_9 = SecretPad.access$1(var3_3)[1] % 8) < 0) {
            var9_9 *= -1;
        }
        if (var9_9 == var8_8) {
            var9_9 = var8_8 == 0 ? 1 : var8_8 - 1;
        }
        var4_4[var8_8] = SecretPad.access$1(var3_3)[0];
        var4_4[var9_9] = SecretPad.access$1(var3_3)[1];
        var10_10 = 0;
        var11_11 = 0;
        ** GOTO lbl23
        {
            ++var10_10;
            do {
                if (var10_10 == var8_8 || var10_10 == var9_9) continue block3;
                var4_4[var10_10++] = var5_5[var11_11];
                ++var11_11;
lbl23:
                // 2 sources

            } while (var11_11 < 4);
        }
        var11_11 = 0;
        ** GOTO lbl31
        {
            ++var10_10;
            do {
                if (var10_10 == var8_8 || var10_10 == var9_9) continue block5;
                var4_4[var10_10++] = var7_7[var11_11];
                ++var11_11;
lbl31:
                // 2 sources

            } while (var11_11 < 2);
        }
        var11_12 = new byte[8];
        var12_13 = var2_2;
        synchronized (var12_13) {
            SecretKey.access$1(var2_2).encrypt(var4_4, 0, var11_12, 0);
        }
        return QueryKey.getQueryKey(var11_12, true);
    }

    public static class SecretKey {
        private DESKey _DESKey = new DESKey();

        private SecretKey() {
        }

        static /* synthetic */ DESKey access$1(SecretKey secretKey) {
            return secretKey._DESKey;
        }
    }

    public static class SecretPad {
        private byte[] _pad = new byte[2];

        private SecretPad() {
            new Random().nextBytes(this._pad);
        }

        static /* synthetic */ byte[] access$1(SecretPad secretPad) {
            return secretPad._pad;
        }
    }
}

