/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.Set;
import java.util.TreeSet;

public final class MutableGUIDFilter
extends SpamFilter {
    private static final MutableGUIDFilter INSTANCE = new MutableGUIDFilter();
    private Set _guids = new TreeSet(new GUID.GUIDByteComparator());
    private final KeywordFilter FILTER = new KeywordFilter();

    private MutableGUIDFilter() {
        this.FILTER.disallowAdult();
    }

    public static MutableGUIDFilter instance() {
        return INSTANCE;
    }

    public synchronized void addGUID(byte[] byArray) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new GUID.GUIDByteComparator());
        treeSet.addAll(treeSet);
        treeSet.add(byArray);
        this._guids = treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] byArray) {
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet treeSet = new TreeSet(new GUID.GUIDByteComparator());
                treeSet.addAll(this._guids);
                treeSet.remove(byArray);
                this._guids = treeSet;
            }
        }
    }

    public boolean allow(QueryReply queryReply) {
        if (this._guids.contains(queryReply.getGUID())) {
            return this.FILTER.allow(queryReply);
        }
        return true;
    }

    public boolean allow(Message message) {
        if (message instanceof QueryReply) {
            return this.allow((QueryReply)message);
        }
        return true;
    }
}

