/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncompleteFileManager
implements Serializable {
    static final long serialVersionUID = -7658285233614679878L;
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private static final Log LOG;
    private Map blocks = new TreeMap(Comparators.fileComparator());
    private Map hashes = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.IncompleteFileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public synchronized boolean purge(boolean bl) {
        File file;
        boolean bl2 = false;
        Iterator<Object> iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (file.exists() && (!IncompleteFileManager.isOld(file) || !bl)) continue;
            bl2 = true;
            RouterService.getFileManager().removeFileIfShared(file);
            file.delete();
            iterator.remove();
        }
        if (bl) {
            iterator = this.hashes.values().iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (file.exists()) continue;
                iterator.remove();
                bl2 = true;
            }
        }
        return bl2;
    }

    private static final boolean isOld(File file) {
        long l = SharingSettings.INCOMPLETE_PURGE_TIME.getValue();
        long l2 = System.currentTimeMillis() - l * 24L * 60L * 60L * 1000L;
        return file.lastModified() < l2;
    }

    static boolean same(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
        return IncompleteFileManager.same(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn(), remoteFileDesc2.getFileName(), remoteFileDesc2.getSize(), remoteFileDesc2.getSHA1Urn());
    }

    static boolean same(String string, int n, URN uRN, String string2, int n2, URN uRN2) {
        if (uRN != null && uRN2 != null) {
            return uRN.equals(uRN2);
        }
        return n == n2 && string.equals(string2);
    }

    private static File canonicalize(File file) throws IOException {
        file = file.getAbsoluteFile();
        if (CommonUtils.isWindows()) {
            return file;
        }
        return file.getCanonicalFile();
    }

    public synchronized File getFile(RemoteFileDesc remoteFileDesc) throws IOException {
        return this.getFile(remoteFileDesc.getFileName(), remoteFileDesc.getSHA1Urn(), remoteFileDesc.getSize());
    }

    public synchronized File getFile(String string, URN uRN, int n) throws IOException {
        return this.getFile(string, uRN, n, SharingSettings.INCOMPLETE_DIRECTORY.getValue());
    }

    public synchronized File getFile(String string, URN uRN, int n, File file) throws IOException {
        boolean bl = false;
        File file2 = null;
        File file3 = null;
        bl = file.mkdirs();
        String string2 = CommonUtils.convertFileName(string);
        try {
            File file4;
            if (uRN != null) {
                File file5 = (File)this.hashes.get(uRN);
                if (file5 != null) {
                    return file5;
                }
                int n2 = 1;
                while (true) {
                    file2 = file5 = new File(file, IncompleteFileManager.tempName(string2, n, n2));
                    file3 = file5 = IncompleteFileManager.canonicalize(file5);
                    if (!this.hashes.values().contains(file5)) break;
                    ++n2;
                }
                this.hashes.put(uRN, file5);
                FileUtils.touch(file5);
                return file5;
            }
            file2 = file4 = new File(file, IncompleteFileManager.tempName(string2, n, 0));
            file3 = file4 = IncompleteFileManager.canonicalize(file4);
            return file4;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("dirsMade: " + bl + "\ndirExist: " + file.exists() + "\nbaseFile: " + file2 + "\ncannFile: " + file3);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public synchronized File getFileForUrn(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null urn");
        }
        return (File)this.hashes.get(uRN);
    }

    private static String tempName(String string, int n, int n2) {
        if (n2 <= 1) {
            return "T-" + n + SEPARATOR + string;
        }
        int n3 = string.lastIndexOf(46);
        if (n3 < 0) {
            return "T-" + n + SEPARATOR + string + " (" + n2 + ")";
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3);
        return "T-" + n + SEPARATOR + string2 + " (" + n2 + ")" + string3;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hashes = new HashMap();
        objectInputStream.defaultReadObject();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blocks before transform " + this.blocks));
        }
        this.blocks = this.transform(this.blocks);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blocks after transform " + this.blocks));
        }
        this.hashes = this.verifyHashes();
        this.registerAllIncompleteFiles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        Map map = this.blocks;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("blocks before invtransform: " + this.blocks));
            }
            this.blocks = this.invTransform();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("blocks after invtransform: " + this.blocks));
            }
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.blocks = map;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.blocks = map;
            return;
        }
    }

    private Map verifyHashes() {
        HashMap<URN, File> hashMap = new HashMap<URN, File>();
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof URN) || !(entry.getValue() instanceof File)) continue;
            URN uRN = (URN)entry.getKey();
            File file = (File)entry.getValue();
            try {
                file = IncompleteFileManager.canonicalize(file);
                if (hashMap.values().contains(file)) continue;
                hashMap.put(uRN, file);
            }
            catch (IOException iOException) {}
        }
        return hashMap;
    }

    private Map transform(Object object) {
        Map map = (Map)object;
        TreeMap<File, VerifyingFile> treeMap = new TreeMap<File, VerifyingFile>(Comparators.fileComparator());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            Object k = iterator.next();
            Object v = map.get(k);
            if (v == null || !(k instanceof File)) continue;
            File file = (File)k;
            try {
                file = IncompleteFileManager.canonicalize(file);
            }
            catch (IOException iOException) {
                continue;
            }
            Iterator iterator2 = ((List)v).iterator();
            try {
                verifyingFile = new VerifyingFile((int)IncompleteFileManager.getCompletedSize(file));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                verifyingFile = new VerifyingFile();
            }
            while (iterator2.hasNext()) {
                Interval interval = (Interval)iterator2.next();
                interval = new Interval(interval.low, interval.high - 1);
                verifyingFile.addInterval(interval);
            }
            treeMap.put(file, verifyingFile);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map invTransform() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            ArrayList<Interval> arrayList = new ArrayList<Interval>();
            Object k = iterator.next();
            VerifyingFile verifyingFile2 = verifyingFile = (VerifyingFile)this.blocks.get(k);
            synchronized (verifyingFile2) {
                List list = verifyingFile.getSerializableBlocks();
                int n = 0;
                while (n < list.size()) {
                    Interval interval = (Interval)list.get(n);
                    Interval interval2 = new Interval(interval.low, interval.high + 1);
                    arrayList.add(interval2);
                    ++n;
                }
            }
            hashMap.put(k, arrayList);
        }
        return hashMap;
    }

    public synchronized void removeEntry(File file) {
        this.blocks.remove(file);
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!file.equals(entry.getValue())) continue;
            iterator.remove();
        }
        RouterService.getFileManager().removeFileIfShared(file);
    }

    public synchronized void addEntry(File file, VerifyingFile verifyingFile) throws IOException {
        try {
            file = IncompleteFileManager.canonicalize(file);
        }
        catch (IOException iOException) {}
        this.blocks.put(file, verifyingFile);
        this.registerIncompleteFile(file);
    }

    public synchronized VerifyingFile getEntry(File file) {
        Object v = this.blocks.get(file);
        return (VerifyingFile)v;
    }

    public synchronized int getBlockSize(File file) {
        Object v = this.blocks.get(file);
        if (v == null) {
            return 0;
        }
        VerifyingFile verifyingFile = (VerifyingFile)v;
        return verifyingFile.getBlockSize();
    }

    public synchronized void registerAllIncompleteFiles() {
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists() || IncompleteFileManager.isOld(file)) continue;
            this.registerIncompleteFile(file);
        }
    }

    private synchronized void registerIncompleteFile(File file) {
        Set set = this.getAllCompletedHashes(file);
        if (set.size() == 0) {
            return;
        }
        RouterService.getFileManager().addIncompleteFile(file, set, IncompleteFileManager.getCompletedName(file), (int)IncompleteFileManager.getCompletedSize(file), this.getEntry(file));
    }

    public static String getCompletedName(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        if (n2 == string.length() - 1) {
            throw new IllegalArgumentException("No name after last separator");
        }
        return string.substring(n2 + 1);
    }

    public static long getCompletedSize(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        try {
            return Long.parseLong(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format: " + string);
        }
    }

    public synchronized URN getCompletedHash(File file) {
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!file.equals(entry.getValue())) continue;
            return (URN)entry.getKey();
        }
        return null;
    }

    public synchronized Set getAllCompletedHashes(File file) {
        HashSet hashSet = new HashSet(1);
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!file.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            File file = (File)iterator.next();
            List list = ((VerifyingFile)this.blocks.get(file)).getVerifiedBlocksAsList();
            stringBuffer.append(file);
            stringBuffer.append(":");
            stringBuffer.append(list.toString());
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public synchronized String dumpHashes() {
        return this.hashes.toString();
    }
}

