/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadManager
implements BandwidthTracker {
    private static final Log LOG;
    private final int BYPASS_QUEUE = -1;
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    private final int BANNED = 3;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private List _activeUploadList = new LinkedList();
    private List _queuedUploads = new ArrayList();
    private volatile boolean _hadSuccesfulUpload = false;
    private int _forcedUploads;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    public static final int BAD_URN_QUERY_INDEX = -3;
    public static final int MALFORMED_REQUEST_INDEX = -4;
    public static final int PUSH_PROXY_FILE_INDEX = -5;
    public static final int FILE_VIEW_FILE_INDEX = -6;
    public static final int RESOURCE_INDEX = -7;
    public static final int BROWSER_CONTROL_INDEX = -8;
    public static final String BROWSER_CONTROL_STR = "/browser-control";
    public static final String SERVICE_ID = "service_id";
    public static final String FV_REQ_BEGIN = "/gnutella/file-view";
    public static final String RESOURCE_GET = "/gnutella/res/";
    private final Map REQUESTS = new FixedsizeForgetfulHashMap(250);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.UploadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptUpload(HTTPRequestMethod var1_1, Socket var2_2, boolean var3_3) {
        block63: {
            block60: {
                block62: {
                    block59: {
                        block61: {
                            block58: {
                                UploadManager.LOG.trace((Object)"accepting upload");
                                var4_4 = null;
                                var5_5 = -1L;
                                try {
                                    try {
                                        var7_6 = -1;
                                        var8_8 = "";
                                        var9_9 = var1_1;
                                        var10_10 = new StalledUploadWatchdog();
                                        var11_11 = null;
                                        var12_12 = false;
                                        while (true) {
                                            if (var4_4 != null) {
                                                this.assertAsComplete(var4_4.getState());
                                            }
                                            if (var11_11 == null) {
                                                var11_11 = new BufferedInputStream(var2_2.getInputStream());
                                            }
                                            UploadManager.LOG.trace((Object)"parsing http line.");
                                            var13_13 = this.parseHttpRequest(var2_2, var11_11);
                                            if (UploadManager.LOG.isTraceEnabled()) {
                                                UploadManager.LOG.trace((Object)("line = " + var13_13));
                                            }
                                            if (UploadManager.LOG.isDebugEnabled()) {
                                                UploadManager.LOG.debug((Object)(var4_4 + " successfully parsed request"));
                                            }
                                            var14_14 = var13_13._fileName;
                                            var12_12 = var4_4 == null || var9_9 != var4_4.getMethod() || var8_8.equalsIgnoreCase(var14_14) == false;
                                            if (var12_12) {
                                                if (UploadManager.LOG.isDebugEnabled()) {
                                                    UploadManager.LOG.debug((Object)(var4_4 + " starting new file " + var13_13._fileName + " index " + var13_13._index));
                                                }
                                                if (var4_4 != null) {
                                                    if (var7_6 != 1) {
                                                        var7_6 = -1;
                                                    } else {
                                                        var4_4.setState(5);
                                                    }
                                                    this.cleanupFinishedUploader(var4_4, var5_5);
                                                }
                                                var4_4 = new HTTPUploader(var9_9, var14_14, var2_2, var13_13._index, var13_13.getParameters(), var10_10, var13_13.hadPassword());
                                            } else {
                                                if (UploadManager.LOG.isDebugEnabled()) {
                                                    UploadManager.LOG.debug((Object)(var4_4 + " continuing old file"));
                                                }
                                                var4_4.reinitialize(var9_9, var13_13.getParameters());
                                            }
                                            this.assertAsConnecting(var4_4.getState());
                                            this.setInitialUploadingState(var4_4);
                                            try {
                                                var4_4.readHeader(var11_11);
                                                this.setUploaderStateOffHeaders(var4_4);
                                            }
                                            catch (ProblemReadingHeaderException v0) {
                                                var4_4.setState(11);
                                            }
                                            catch (FreeloaderUploadingException v1) {
                                                var4_4.setState(1);
                                            }
                                            if (UploadManager.LOG.isDebugEnabled()) {
                                                UploadManager.LOG.debug((Object)(var4_4 + " HTTPUploader created and read all headers"));
                                            }
                                            if (var7_6 != 2 && (var7_6 = this.processNewRequest(var4_4, var2_2, var3_3)) == 2) {
                                                var5_5 = System.currentTimeMillis();
                                            }
                                            if (var12_12) {
                                                this.addToGUI(var4_4);
                                            }
                                            this.doSingleUpload(var4_4);
                                            this.assertAsFinished(var4_4.getState());
                                            var8_8 = var14_14;
                                            if (!var13_13.isHTTP11()) {
                                                var17_17 = null;
                                                if (var4_4 != null && var4_4.getState() != 4) {
                                                    var4_4.setState(5);
                                                }
                                                var19_21 = this;
                                                break block58;
                                            }
                                            if (UploadManager.LOG.isDebugEnabled()) {
                                                UploadManager.LOG.debug((Object)(var4_4 + " waiting for next request with socket "));
                                            }
                                            var15_15 = var2_2.getSoTimeout();
                                            if (var7_6 != 1) {
                                                var2_2.setSoTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
                                            }
                                            var16_16 = IOUtils.readWord(var11_11, 4);
                                            if (UploadManager.LOG.isDebugEnabled()) {
                                                UploadManager.LOG.debug((Object)(var4_4 + " next request arrived "));
                                            }
                                            var2_2.setSoTimeout(var15_15);
                                            if (var16_16.equals("GET")) {
                                                var9_9 = HTTPRequestMethod.GET;
                                                UploadStat.SUBSEQUENT_GET.incrementStat();
                                                continue;
                                            }
                                            if (!var16_16.equals("HEAD")) break;
                                            var9_9 = HTTPRequestMethod.HEAD;
                                            UploadStat.SUBSEQUENT_HEAD.incrementStat();
                                        }
                                        UploadStat.SUBSEQUENT_UNKNOWN.incrementStat();
                                        break block59;
                                    }
                                    catch (IOException var7_7) {
                                        if (UploadManager.LOG.isDebugEnabled()) {
                                            UploadManager.LOG.debug((Object)(var4_4 + " IOE thrown, closing socket"), (Throwable)var7_7);
                                        }
                                        ** GOTO lbl-1000
                                    }
                                }
                                catch (Throwable var18_37) {
                                    var17_19 = null;
                                    if (var4_4 != null && var4_4.getState() != 4) {
                                        var4_4.setState(5);
                                    }
                                    var19_23 = this;
                                    synchronized (var19_23) {
                                        var20_27 = false;
                                        var21_31 = this._queuedUploads.iterator();
                                        while (var21_31.hasNext()) {
                                            var22_35 = (KeyValue)var21_31.next();
                                            if (var22_35.getKey() != var2_2) continue;
                                            var21_31.remove();
                                            var20_27 = true;
                                            break;
                                        }
                                        if (var20_27) {
                                            var4_4.setState(5);
                                        }
                                        break block60;
                                    }
                                }
                            }
                            synchronized (var19_21) {
                                ** try [egrp 3[TRYBLOCK] [7 : 817->895)] { 
lbl114:
                                // 1 sources

                                var20_25 = false;
                                var21_29 = this._queuedUploads.iterator();
                                while (var21_29.hasNext()) {
                                    var22_33 = (KeyValue)var21_29.next();
                                    if (var22_33.getKey() != var2_2) continue;
                                    var21_29.remove();
                                    var20_25 = true;
                                    break;
                                }
                                if (var20_25) {
                                    var4_4.setState(5);
                                }
                                break block61;
lbl125:
                                // 1 sources

                                catch (Throwable v3) {
                                    throw v3;
                                }
                            }
                        }
                        if (var4_4 != null) {
                            var4_4.stop();
                            this.cleanupFinishedUploader(var4_4, var5_5);
                        }
                        if (UploadManager.LOG.isDebugEnabled()) {
                            UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
                        }
                        this.close(var2_2);
                        return;
                    }
                    var17_18 = null;
                    if (var4_4 != null && var4_4.getState() != 4) {
                        var4_4.setState(5);
                    }
                    var19_22 = this;
                    synchronized (var19_22) {
                        ** try [egrp 3[TRYBLOCK] [7 : 817->895)] { 
lbl142:
                        // 1 sources

                        var20_26 = false;
                        var21_30 = this._queuedUploads.iterator();
                        while (var21_30.hasNext()) {
                            var22_34 = (KeyValue)var21_30.next();
                            if (var22_34.getKey() != var2_2) continue;
                            var21_30.remove();
                            var20_26 = true;
                            break;
                        }
                        if (var20_26) {
                            var4_4.setState(5);
                        }
                        break block62;
lbl153:
                        // 1 sources

                        catch (Throwable v4) {
                            throw v4;
                        }
                    }
                }
                if (var4_4 != null) {
                    var4_4.stop();
                    this.cleanupFinishedUploader(var4_4, var5_5);
                }
                if (UploadManager.LOG.isDebugEnabled()) {
                    UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
                }
                this.close(var2_2);
                return;
            }
            if (var4_4 != null) {
                var4_4.stop();
                this.cleanupFinishedUploader(var4_4, var5_5);
            }
            if (UploadManager.LOG.isDebugEnabled()) {
                UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
            }
            this.close(var2_2);
            throw var18_37;
lbl-1000:
            // 1 sources

            {
                var17_20 = null;
                if (var4_4 != null && var4_4.getState() != 4) {
                    var4_4.setState(5);
                }
                var19_24 = this;
            }
            synchronized (var19_24) {
                ** try [egrp 3[TRYBLOCK] [7 : 817->895)] { 
lbl177:
                // 1 sources

                var20_28 = false;
                var21_32 = this._queuedUploads.iterator();
                while (var21_32.hasNext()) {
                    var22_36 = (KeyValue)var21_32.next();
                    if (var22_36.getKey() != var2_2) continue;
                    var21_32.remove();
                    var20_28 = true;
                    break;
                }
                if (var20_28) {
                    var4_4.setState(5);
                }
                break block63;
lbl188:
                // 1 sources

                catch (Throwable v5) {
                    throw v5;
                }
            }
        }
        if (var4_4 != null) {
            var4_4.stop();
            this.cleanupFinishedUploader(var4_4, var5_5);
        }
        if (UploadManager.LOG.isDebugEnabled()) {
            UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
        }
        this.close(var2_2);
    }

    private boolean shouldShowInGUI(HTTPUploader hTTPUploader) {
        return hTTPUploader.getIndex() != -1 && hTTPUploader.getIndex() != -5 && hTTPUploader.getIndex() != -2 && hTTPUploader.getIndex() != -4 && hTTPUploader.getIndex() != -3 && hTTPUploader.getIndex() != -6 && hTTPUploader.getIndex() != -7 && hTTPUploader.getIndex() != -8 && hTTPUploader.getMethod() != HTTPRequestMethod.HEAD && !hTTPUploader.isForcedShare();
    }

    private boolean shouldBypassQueue(HTTPUploader hTTPUploader) {
        return hTTPUploader.getState() != 0 || hTTPUploader.getMethod() == HTTPRequestMethod.HEAD || hTTPUploader.isForcedShare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFinishedUploader(HTTPUploader hTTPUploader, long l) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " cleaning up finished."));
        }
        int n = hTTPUploader.getState();
        int n2 = hTTPUploader.getLastTransferState();
        this.assertAsFinished(n);
        long l2 = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            if (l > 0L) {
                this.reportUploadSpeed(l2 - l, hTTPUploader.getTotalAmountUploaded());
            }
            this.removeFromList(hTTPUploader);
        }
        hTTPUploader.closeFileStreams();
        switch (n) {
            case 4: {
                UploadStat.COMPLETED.incrementStat();
                if (n2 != 3 && n2 != 15) break;
                UploadStat.COMPLETED_FILE.incrementStat();
                break;
            }
            case 5: {
                UploadStat.INTERRUPTED.incrementStat();
            }
        }
        if (this.shouldShowInGUI(hTTPUploader)) {
            object = hTTPUploader.getFileDesc();
            if (object != null && n == 4 && (n2 == 3 || n2 == 15)) {
                ((FileDesc)object).incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(((FileDesc)object).getFile());
            }
            RouterService.getCallback().removeUpload(hTTPUploader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialUploadingState(HTTPUploader hTTPUploader) {
        switch (hTTPUploader.getIndex()) {
            case -1: {
                hTTPUploader.setState(8);
                return;
            }
            case -8: {
                hTTPUploader.setState(16);
                return;
            }
            case -5: {
                hTTPUploader.setState(12);
                return;
            }
            case -2: {
                hTTPUploader.setState(10);
                return;
            }
            case -3: {
                hTTPUploader.setState(7);
                return;
            }
            case -4: {
                hTTPUploader.setState(11);
                return;
            }
        }
        FileManager fileManager = RouterService.getFileManager();
        FileDesc fileDesc = null;
        int n = hTTPUploader.getIndex();
        FileManager fileManager2 = fileManager;
        synchronized (fileManager2) {
            if (fileManager.isValidIndex(n)) {
                fileDesc = fileManager.get(n);
            }
        }
        if (fileDesc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " fd is null"));
            }
            hTTPUploader.setState(7);
            return;
        }
        if (!hTTPUploader.getFileName().equals(fileDesc.getFileName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " wrong file name"));
            }
            hTTPUploader.setState(7);
            return;
        }
        try {
            hTTPUploader.setFileDesc(fileDesc);
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " could not create file stream " + iOException));
            }
            hTTPUploader.setState(7);
            return;
        }
        this.assertAsConnecting(hTTPUploader.getState());
    }

    private void setUploaderStateOffHeaders(HTTPUploader hTTPUploader) {
        FileDesc fileDesc = hTTPUploader.getFileDesc();
        if (hTTPUploader.getState() == 0) {
            URN uRN = hTTPUploader.getRequestedURN();
            if (fileDesc != null && uRN != null && !fileDesc.containsUrn(uRN)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " wrong content urn"));
                }
                hTTPUploader.setState(7);
                return;
            }
            if (hTTPUploader.isTHEXRequest()) {
                if (hTTPUploader.getFileDesc().getHashTree() != null) {
                    hTTPUploader.setState(15);
                } else {
                    hTTPUploader.setState(7);
                }
                return;
            }
            if (fileDesc instanceof IncompleteFileDesc) {
                if (!UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                    hTTPUploader.setState(7);
                    return;
                }
                if (hTTPUploader.isTHEXRequest()) {
                    hTTPUploader.setState(7);
                    return;
                }
                IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
                int n = hTTPUploader.getUploadBegin();
                int n2 = hTTPUploader.getUploadEnd() - 1;
                if (hTTPUploader.containedRangeRequest()) {
                    Interval interval = incompleteFileDesc.getAvailableSubRange(n, n2);
                    if (interval == null) {
                        hTTPUploader.setState(13);
                        return;
                    }
                    hTTPUploader.setUploadBeginAndEnd(interval.low, interval.high + 1);
                } else if (!incompleteFileDesc.isRangeSatisfiable(n, n2)) {
                    hTTPUploader.setState(13);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processNewRequest(HTTPUploader hTTPUploader, Socket socket, boolean bl) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " processing new request."));
        }
        int n = -1;
        n = !this.shouldBypassQueue(hTTPUploader) ? (bl ? 2 : this.checkAndQueue(hTTPUploader, socket)) : -1;
        switch (n) {
            case 0: {
                hTTPUploader.setState(2);
                break;
            }
            case 3: {
                hTTPUploader.setState(14);
                break;
            }
            case 1: {
                hTTPUploader.setState(9);
                socket.setSoTimeout(120000);
                break;
            }
            case 2: {
                this.assertAsConnecting(hTTPUploader.getState());
                UploadManager uploadManager = this;
                synchronized (uploadManager) {
                    if (hTTPUploader.isForcedShare()) {
                        ++this._forcedUploads;
                    }
                    this._activeUploadList.add(hTTPUploader);
                    break;
                }
            }
            case -1: {
                break;
            }
            default: {
                Assert.that(false, "Invalid queued state: " + n);
            }
        }
        return n;
    }

    private void addToGUI(HTTPUploader hTTPUploader) {
        UploadStat.ATTEMPTED.incrementStat();
        if (this.shouldShowInGUI(hTTPUploader)) {
            RouterService.getCallback().addUpload(hTTPUploader);
            FileDesc fileDesc = hTTPUploader.getFileDesc();
            if (fileDesc != null) {
                fileDesc.incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSingleUpload(HTTPUploader hTTPUploader) throws IOException {
        block15: {
            switch (hTTPUploader.getState()) {
                case 13: {
                    UploadStat.UNAVAILABLE_RANGE.incrementStat();
                    break;
                }
                case 7: {
                    UploadStat.FILE_NOT_FOUND.incrementStat();
                    break;
                }
                case 1: {
                    UploadStat.FREELOADER.incrementStat();
                    break;
                }
                case 2: {
                    UploadStat.LIMIT_REACHED.incrementStat();
                    break;
                }
                case 9: {
                    UploadStat.QUEUED.incrementStat();
                    break;
                }
                case 14: {
                    UploadStat.BANNED.incrementStat();
                    break;
                }
                case 0: {
                    hTTPUploader.setState(3);
                    UploadStat.UPLOADING.incrementStat();
                    break;
                }
                case 15: {
                    UploadStat.THEX.incrementStat();
                    break;
                }
                case 4: 
                case 5: {
                    Assert.that(false, "invalid state in doSingleUpload");
                    break;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(hTTPUploader + " doing single upload"));
            }
            boolean bl = false;
            try {
                hTTPUploader.initializeStreams();
                hTTPUploader.writeResponse();
                bl = hTTPUploader.getCloseConnection();
                hTTPUploader.setState(4);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                hTTPUploader.closeFileStreams();
                throw throwable;
            }
            {
                Object var3_5 = null;
                hTTPUploader.closeFileStreams();
                if (!bl) break block15;
            }
            throw new IOException("close connection");
        }
    }

    public void close(Socket socket) {
        try {
            if (socket != null) {
                socket.getOutputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (socket != null) {
                socket.getInputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {}
    }

    public synchronized boolean isServiceable() {
        return this.hasFreeSlot(this.uploadsInProgress() + this.getNumQueuedUploads());
    }

    public synchronized int uploadsInProgress() {
        return this._activeUploadList.size() - this._forcedUploads;
    }

    public synchronized int getNumQueuedUploads() {
        return this._queuedUploads.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    public synchronized boolean isConnectedTo(InetAddress inetAddress) {
        Object object;
        Object object2;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object2 = (KeyValue)iterator.next();
            object = (Socket)((KeyValue)object2).getKey();
            if (object == null || !((Socket)object).getInetAddress().equals(inetAddress)) continue;
            return true;
        }
        iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object2 = (HTTPUploader)iterator.next();
            object = ((HTTPUploader)object2).getConnectedHost();
            if (object == null || !((InetAddress)object).equals(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean killUploadsForFileDesc(FileDesc fileDesc) {
        boolean bl = false;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)iterator.next();
            FileDesc fileDesc2 = hTTPUploader.getFileDesc();
            if (fileDesc2 == null || !fileDesc2.equals(fileDesc)) continue;
            bl = true;
            hTTPUploader.stop();
        }
        return bl;
    }

    private synchronized int checkAndQueue(Uploader uploader, Socket socket) throws IOException {
        RequestCache requestCache = (RequestCache)this.REQUESTS.get(uploader.getHost());
        if (requestCache == null) {
            requestCache = new RequestCache();
        }
        this.REQUESTS.put(uploader.getHost(), requestCache);
        requestCache.countRequest();
        if (requestCache.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " banned."));
            }
            return 3;
        }
        boolean bl = requestCache.isGreedy(uploader.getFileDesc().getSHA1Urn());
        int n = this._queuedUploads.size();
        int n2 = this.positionInQueue(socket);
        int n3 = UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
        boolean bl2 = n >= n3 || requestCache.isDupe(uploader.getFileDesc().getSHA1Urn());
        int n4 = -1;
        boolean bl3 = false;
        if (bl && n >= 1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " greedy -- limit reached."));
            }
            UploadStat.LIMIT_REACHED_GREEDY.incrementStat();
            bl3 = true;
        } else if (n2 < 0 && (bl3 = this.hostLimitReached(uploader.getHost()))) {
            requestCache.limitReached(uploader.getFileDesc().getSHA1Urn());
        }
        boolean bl4 = uploader.supportsQueueing();
        Assert.that(n3 > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() == 0, "Bad state: " + uploader.getState());
        Assert.that(uploader.getMethod() == HTTPRequestMethod.GET);
        if (n2 == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + "Uploader not in que(capacity:" + n3 + ")"));
            }
            if (bl3 || bl2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " limited? " + bl3 + " wontAccept? " + bl2));
                }
                return 0;
            }
            this.addToQueue(socket);
            n2 = n;
            n4 = 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " new uploader added to queue"));
            }
        } else {
            KeyValue keyValue = (KeyValue)this._queuedUploads.get(n2);
            Long l = (Long)keyValue.getValue();
            if (l + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(n2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " queued uploader flooding-throwing exception"));
                }
                throw new IOException();
            }
            if (requestCache.isDupe(uploader.getFileDesc().getSHA1Urn())) {
                return 0;
            }
            keyValue.setValue(new Long(System.currentTimeMillis()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " updated queued uploader"));
            }
            n4 = 1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploader + " checking if given uploader is can be accomodated "));
        }
        if (this.hasFreeSlot(n2 + this.uploadsInProgress())) {
            n4 = 2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " accepting upload"));
            }
            this._queuedUploads.remove(n2);
        } else if (!bl4) {
            this._queuedUploads.remove(n2);
            n4 = 0;
        }
        if (n4 == 2) {
            requestCache.startedUpload(uploader.getFileDesc().getSHA1Urn());
        }
        return n4;
    }

    private synchronized void addToQueue(Socket socket) {
        Long l = new Long(System.currentTimeMillis());
        this._queuedUploads.add(new KeyValue(socket, l));
    }

    public synchronized int positionInQueue(Socket socket) {
        int n = 0;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            Object object = ((KeyValue)iterator.next()).getKey();
            if (object == socket) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        if (this._activeUploadList.remove(uploader)) {
            RequestCache requestCache;
            if (((HTTPUploader)uploader).isForcedShare()) {
                --this._forcedUploads;
            }
            if ((requestCache = (RequestCache)this.REQUESTS.get(uploader.getHost())) != null && uploader != null && uploader.getFileDesc() != null) {
                requestCache.uploadDone(uploader.getFileDesc().getSHA1Urn());
            }
        }
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String string) {
        Object object;
        int n = UploadSettings.UPLOADS_PER_PERSON.getValue();
        int n2 = 0;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object = (Uploader)iterator.next();
            if (!object.getHost().equals(string)) continue;
            ++n2;
        }
        iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object = (Socket)((KeyValue)iterator.next()).getKey();
            if (!((Socket)object).getInetAddress().getHostAddress().equals(string)) continue;
            ++n2;
        }
        return n2 >= n;
    }

    private boolean hasFreeSlot(int n) {
        if (n >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (n < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
        }
        return f > 3.0f;
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        float f = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float f2 = UploadSettings.UPLOAD_SPEED.getValue();
        float f3 = f * f2 / 100.0f;
        return f3;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        this.speeds.add(new Integer(n));
        if (this.speeds.size() >= 5) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.speeds.size()) {
                n2 = Math.max(n2, (Integer)this.speeds.get(n3));
                ++n3;
            }
            this.highestSpeed = n2;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket, InputStream inputStream) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader byteReader = new ByteReader(inputStream);
        LOG.trace((Object)"trying to read request.");
        String string = byteReader.readLine();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("request is: " + string));
        }
        try {
            if (string == null) {
                throw new IOException();
            }
            string.trim();
            if (this.isURNGet(string)) {
                return this.parseURNGet(string);
            }
            return UploadManager.parseTraditionalGet(string);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"http request failed", (Throwable)iOException);
            UploadStat.MALFORMED_REQUEST.incrementStat();
            if (string == null) {
                return new HttpRequestLine(-4, "Malformed Request", false);
            }
            return new HttpRequestLine(-4, "Malformed Request", UploadManager.isHTTP11Request(string));
        }
    }

    private boolean isURNGet(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        if (n == -1 || n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static HttpRequestLine parseTraditionalGet(String string) throws IOException {
        try {
            int n;
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 2) {
                throw new IOException("invalid request: " + string);
            }
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = null;
            HashMap<String, Integer> hashMap = null;
            boolean bl = false;
            if (string2.equals("/")) {
                n2 = -1;
                string3 = "Browse-Host Request";
                UploadStat.BROWSE_HOST.incrementStat();
            } else if (string2.startsWith(BROWSER_CONTROL_STR)) {
                n2 = -8;
                string3 = string2;
            } else if (string2.startsWith(FV_REQ_BEGIN)) {
                n2 = -6;
                string3 = string2;
            } else if (string2.startsWith(RESOURCE_GET)) {
                n2 = -7;
                string3 = string2.substring(RESOURCE_GET.length());
            } else if (string2.equals("/update.xml")) {
                n2 = -2;
                string3 = "Update-File Request";
                UploadStat.UPDATE_FILE.incrementStat();
            } else if (string2.startsWith("/gnutella/push-proxy") || string2.startsWith("/gnet/push-proxy")) {
                n = string2.indexOf(63);
                if (n == -1) {
                    throw new IOException("Malformed PushProxy Req");
                }
                string2 = string2.substring(n + 1);
                n2 = -5;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=&");
                if (stringTokenizer2.countTokens() < 2 || stringTokenizer2.countTokens() % 2 != 0) {
                    throw new IOException("Malformed PushProxy HTTP Request");
                }
                Integer n3 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    String string5 = stringTokenizer2.nextToken();
                    if (string4.equalsIgnoreCase("ServerId")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        byte[] byArray = Base32.decode(string5);
                        if (byArray.length != 16) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = new GUID(byArray).toHexString();
                        continue;
                    }
                    if (string4.equalsIgnoreCase("guid")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        if (string5.length() != 32) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = string5;
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("file")) continue;
                    if (n3 != null) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    n3 = Integer.valueOf(string5);
                    if (n3 < 0) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap<String, Integer>();
                    }
                    hashMap.put("file", n3);
                }
                UploadStat.PUSH_PROXY.incrementStat();
            } else {
                n = string.indexOf("/get/");
                int n4 = string.indexOf("/", n + 5);
                String string6 = string.substring(n + 5, n4);
                n2 = Integer.parseInt(string6);
                int n5 = string.indexOf(" HTTP/", n4);
                try {
                    string3 = URLDecoder.decode(string.substring(n4 + 1, n5));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string3 = string.substring(n4 + 1, n5);
                }
                UploadStat.TRADITIONAL_GET.incrementStat();
            }
            n = UploadManager.isHTTP11Request(string);
            return new HttpRequestLine(n2, string3, n != 0, hashMap, bl);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String string) throws IOException {
        URN uRN = URN.createSHA1UrnFromHttpRequest(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string.toUpperCase(Locale.US);
        if (string2.indexOf("N2X?") > 0) {
            hashMap.put(SERVICE_ID, "N2X?");
        } else if (string2.indexOf("N2R?") > 0) {
            hashMap.put(SERVICE_ID, "N2R?");
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid URN query: " + string));
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            UploadStat.UNKNOWN_URN_GET.incrementStat();
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        UploadStat.URN_GET.incrementStat();
        return new HttpRequestLine(fileDesc.getIndex(), fileDesc.getFileName(), UploadManager.isHTTP11Request(string), hashMap, false);
    }

    private static boolean isHTTP11Request(String string) {
        return string.endsWith("1.1");
    }

    private void assertAsConnecting(int n) {
        Assert.that(n == 0, "invalid state: " + n);
    }

    private void assertAsComplete(int n) {
        Assert.that(n == 4, "invalid state: " + n);
    }

    private void assertAsFinished(int n) {
        Assert.that(n == 5 || n == 4, "invalid state: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        ArrayList arrayList;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            arrayList = new ArrayList(this._activeUploadList);
        }
        float f = 0.0f;
        boolean bl = false;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)object.next();
            if (hTTPUploader.isForcedShare()) continue;
            bl = true;
            hTTPUploader.measureBandwidth();
            f += hTTPUploader.getAverageBandwidth();
        }
        if (bl) {
            object = this;
            synchronized (object) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMeasuredBandwidth() {
        ArrayList arrayList;
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            arrayList = new ArrayList(this._activeUploadList);
        }
        float f = 0.0f;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)iterator.next();
            if (hTTPUploader.isForcedShare()) continue;
            f += hTTPUploader.getMeasuredBandwidth();
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    static void tBandwidthTracker(UploadManager uploadManager) {
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 2000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 3000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 4000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 5000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 400);
        uploadManager.reportUploadSpeed(100000L, 6000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(1L, 1000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 80);
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;
        final Map _params;
        final boolean _hadPass;

        public String toString() {
            return "Index = " + this._index + ", FileName = " + this._fileName + ", is HTTP1.1? " + this._http11 + ", Parameters = " + this._params;
        }

        HttpRequestLine(int n, String string, boolean bl) {
            this(n, string, bl, Collections.EMPTY_MAP, false);
        }

        HttpRequestLine(int n, String string, boolean bl, Map map, boolean bl2) {
            this._index = n;
            this._fileName = string;
            this._http11 = bl;
            this._params = map == null ? Collections.EMPTY_MAP : map;
            this._hadPass = bl2;
        }

        boolean isHTTP11() {
            return this._http11;
        }

        Map getParameters() {
            return this._params;
        }

        boolean hadPassword() {
            return this._hadPass;
        }
    }

    private static class RequestCache {
        private static final double MAX_REQUESTS = 5000.0;
        private static final int MAX_ENTRIES = 10;
        static long WAIT_TIME = 900000L;
        static long FIRST_CHECK_TIME = 30000L;
        private final Set REQUESTS = new FixedSizeExpiringSet(10, WAIT_TIME);
        private final Set ACTIVE_UPLOADS = new HashSet();
        private double _numRequests = 0.0;
        private long _lastRequest = this._firstRequest = System.currentTimeMillis();
        private long _firstRequest;

        RequestCache() {
        }

        boolean isGreedy(URN uRN) {
            return this.REQUESTS.contains(uRN);
        }

        void startedUpload(URN uRN) {
            this.ACTIVE_UPLOADS.add(uRN);
        }

        boolean isHammering() {
            if (this._lastRequest - this._firstRequest <= FIRST_CHECK_TIME) {
                return false;
            }
            return (double)(this._lastRequest - this._firstRequest) / this._numRequests < 5000.0;
        }

        void limitReached(URN uRN) {
            this.REQUESTS.add(uRN);
        }

        void countRequest() {
            this._numRequests += 1.0;
            this._lastRequest = System.currentTimeMillis();
        }

        boolean isDupe(URN uRN) {
            return this.ACTIVE_UPLOADS.contains(uRN);
        }

        void uploadDone(URN uRN) {
            this.ACTIVE_UPLOADS.remove(uRN);
        }
    }
}

