package com.limegroup.gnutella.gui.library;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import com.limegroup.gnutella.gui.GUIMediator;

/**
 * This class contains the popup menu that is visible on right-click events in
 * the library table window.
 */
final class LibraryTablePopupMenu {
	
	/**
	 * Constant for the <tt>JPopupMenu</tt> that contains all of the menu items.
	 */
	private final JPopupMenu MENU = new JPopupMenu();

	/**
	 * The index of the launch menu item.
	 */
	static final int LAUNCH_INDEX = 0;

	/**
	 * The index of the delete menu item.
	 */
	static final int DELETE_INDEX = 1;

	/**
	 * The index of the annotate menu item.
	 */
	static final int ANNOTATE_INDEX = 2;
	
	/**
	 * Rename index.
	 */
	static final int RENAME_INDEX = 3;
	
	/**
	 * The index of the resume item.
	 */
	static final int RESUME_INDEX = 4;
	
	/**
	 * Index of the license item.
	 */
	static final int LICENSE_INDEX = 5;

	/**
	 * The index of the playlist menu item.
	 */
	static final int PLAYLIST_INDEX = 6;

	/**
	 * The index of the bitzi menu item.
	 */
	static final int BITZI_INDEX = 7;

	/**
	 * The index of the magnet menu item.
	 */
	static final int MAGNET_INDEX = 8;
	
	/**
	 * The index of the html file-view menu item.
	 */
	static final int HTTP_INDEX = 9;
	
	LibraryTablePopupMenu(final LibraryTableMediator ltm) {
    	JMenuItem LAUNCH_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_LAUNCH_BUTTON_LABEL"));
    	 JMenuItem DELETE_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_DELETE_BUTTON_LABEL"));
    	JMenuItem ANNOTATE_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_ANNOTATE_BUTTON_LABEL"));
    	JMenuItem RENAME_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_RENAME_BUTTON_LABEL"));    	    
        JMenuItem RESUME_ITEM = new JMenuItem(
            GUIMediator.getStringResource("LIBRARY_RESUME_BUTTON_LABEL"));
    	JMenuItem PLAYLIST_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_PLAYLIST_BUTTON_LABEL"));
    	JMenuItem BITZI_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("SEARCH_PUBLIC_BITZI_LOOKUP_STRING"));
    	JMenuItem MAGNET_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("SEARCH_PUBLIC_MAGNET_LOOKUP_STRING"));
    	JMenuItem HTTP_ITEM = new JMenuItem(
            GUIMediator.getStringResource("SEARCH_PUBLIC_HTTP_PAGE_STRING"));
        JMenuItem LICENSE_ITEM = new JMenuItem(
            GUIMediator.getStringResource("LICENSE_CC_VIEW_LICENSE"));
    
        LICENSE_ITEM.addActionListener( ltm.LICENSE_LISTENER );
   		LAUNCH_ITEM.addActionListener( LibraryTableMediator.LAUNCH_LISTENER );
		DELETE_ITEM.addActionListener( ltm.REMOVE_LISTENER );
		ANNOTATE_ITEM.addActionListener( LibraryTableMediator.ANNOTATE_LISTENER );
		RENAME_ITEM.addActionListener( LibraryTableMediator.RENAME_LISTENER );
		RESUME_ITEM.addActionListener( LibraryTableMediator.RESUME_LISTENER );
		PLAYLIST_ITEM.addActionListener( LibraryTableMediator.ADD_PLAY_LIST_LISTENER );
        BITZI_ITEM.addActionListener( LibraryTableMediator.BITZI_LOOKUP_LISTENER );
        MAGNET_ITEM.addActionListener( LibraryTableMediator.MAGNET_LOOKUP_LISTENER );
        HTTP_ITEM.addActionListener( LibraryTableMediator.HTTP_LOOKUP_LISTENER );
		MENU.add(LAUNCH_ITEM);
		MENU.add(DELETE_ITEM);
		MENU.add(ANNOTATE_ITEM);
		MENU.add(RENAME_ITEM);
		MENU.add(RESUME_ITEM);
		MENU.add(LICENSE_ITEM);
		// if it's visible, add the playlist item.
        // otherwise, add a separator so that the indexes are still right. :)
        if (GUIMediator.isPlaylistVisible())
        	MENU.add(PLAYLIST_ITEM);
        else
        	MENU.addSeparator();
        MENU.add(BITZI_ITEM);
        MENU.add(MAGNET_ITEM);
        if (LibraryTableMediator.shouldShowHTTPOption())
            MENU.add(HTTP_ITEM);
    }
    
    JPopupMenu getComponent() { return MENU; }
    
}
