package com.limegroup.gnutella.gui;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPasswordField;

/**
 * A class for accepting user's login/password
 * @author Anurag Singla
 * @version 
 */
public class PasswordDialog
{
    
    /**
	 * The return code for when the user has pressed ok 
	 */
	public static final int OK = 77;
	
	/**
	 * The return code for when the user cancelled the action.
	 */
	public static final int CANCELLED = 78;

	/**
	 * The <tt>JDialog</tt> instance for the dialog window.
	 */
	private JDialog _dialog;

	/**
	 * The main panel of the dialog.
	 */
	private final PaddedPanel MAIN_PANEL = new PaddedPanel();

	/**
	 * The username field displayed in the dialog.
	 */
	private final SizedTextField _usernameField = new SizedTextField();
    
    /**
     * Label for username field
     */
    private final String USERNAME_FIELD_LABEL 
        = "PASSWORD_DIALOG_USERNAME_FIELD_LABEL";

    /**
	 * The password field displayed in the dialog.
	 */
	private final JPasswordField _passwordField = new JPasswordField();

    /**
     * Label for password field
     */
    private final String PASSWORD_FIELD_LABEL 
        = "PASSWORD_DIALOG_PASSWORD_FIELD_LABEL";
    
	/**
	 * Stored value for the return code specifying what action
	 * the user took.
	 */
	private int _returnCode = CANCELLED;
 
	/**
	 * Constructs the diaog with a field for username, and for password
	 */
	public PasswordDialog(String title) {
        _passwordField.setPreferredSize(SizedTextField.STANDARD_DIMENSION);
        _passwordField.setMaximumSize(SizedTextField.STANDARD_DIMENSION);
        
		Frame frame = GUIMediator.getAppFrame();
		_dialog = new JDialog(frame, title, true);
		_dialog.setSize(340, 180);
		LabeledComponent usernameComponent = 
		    new LabeledComponent(USERNAME_FIELD_LABEL, _usernameField, 
								 LabeledComponent.LEFT_GLUE);
        LabeledComponent passwordComponent = 
		    new LabeledComponent(PASSWORD_FIELD_LABEL, _passwordField, 
								 LabeledComponent.LEFT_GLUE);
		
		String[] buttonLabelKeys = {
			"GENERAL_OK_BUTTON_LABEL",
			"GENERAL_CANCEL_BUTTON_LABEL"
		};

		String[] buttonLabelTips = {
			"GENERAL_OK_BUTTON_TIP",
			"GENERAL_CANCEL_BUTTON_TIP"
		};

		ActionListener[] buttonListeners = {
			new OKListener(),
			new CancelListener()
		};
		
		ButtonRow buttons = new ButtonRow(buttonLabelKeys,
										  buttonLabelTips,
										  buttonListeners,
										  ButtonRow.X_AXIS,
										  ButtonRow.LEFT_GLUE);
		Container contentPane = _dialog.getContentPane();
		BoxPanel componentPanel = new BoxPanel(BoxPanel.Y_AXIS);

		componentPanel.add(Box.createVerticalGlue());
		componentPanel.add(usernameComponent.getComponent());
        componentPanel.add(GUIMediator.getVerticalSeparator());
        componentPanel.add(passwordComponent.getComponent());
		componentPanel.add(Box.createVerticalGlue());

		MAIN_PANEL.add(componentPanel);
		MAIN_PANEL.add(Box.createVerticalGlue());
		MAIN_PANEL.add(buttons);
		contentPane.add(MAIN_PANEL);
	}

	/**
	 * Displays the modal dialog, returning the appropriate return code to
	 * the caller. The return code can be one of the following:
	 *
	 * NO_TEXT_ENTERED
	 * CANCELLED
	 * TEXT_ENTERED<p>
	 *
	 * @return the return code for the window
	 */
	public int showDialog() {
		setVisible(true);
		return _returnCode;
	}

	/**
	 * Makes the dialog visible or invisible depending on the parameter.
	 *
	 * @param visible specifies whether the dialog should be made visible or
	 *  invisible
	 */
	private void setVisible(boolean visible) {
		if(visible) {
			_dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
		}
		_dialog.setVisible(visible);
	}

	/**
	 * Returns the text contained in the wrapped text field.
	 *
	 * @return the text contained in the text field
	 */
	public String getUsername() {
		return _usernameField.getText();
	}

    /**
	 * Returns the text contained in the wrapped text field.
	 *
	 * @return the text contained in the text field
	 */
	public String getPassword() {
		return _passwordField.getText();
	}
    

	/**
	 * Returns the return code of the input window.  
     * @return the return code of the input window. This can be one of:<p>
	 * <ul>
     * <li>
	 * OK
     * </li><li>
	 * CANCELLED
     * </li></ul>
	 */
    public int getReturnCode() {
        return _returnCode;
    }

	/**
	 * This class handles the clicking of the ok button in the dialog.
	 */
	private class OKListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			_returnCode = OK;
			setVisible(false);
		}
	}

	/**
	 * This class handles the clicking of the cancel button in the dialog.
	 */
	private class CancelListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			_returnCode = CANCELLED;
			setVisible(false);
		}
	}
    
    //Unit Test
    /*
    public static void main(String[] args){
        PasswordDialog dialog = new PasswordDialog("test");
        dialog.showDialog();
        System.out.println("Hi Adam");
        
    } */
    
}
