/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.acquisitionx;

import com.limegroup.gnutella.*;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.security.User;
import java.io.File;
import java.io.PrintStream;
import java.util.*;


public class AqEventHandler implements ActivityCallback
{
    
/* Instances */
    
    public static Vector responses = new Vector();
    public static Vector alts      = new Vector();
    public static Vector queryGUIDs = new Vector();
    public static Vector downloads = new Vector();
    public static Vector queries   = new Vector();
    public static Map    hosts     = new HashMap();
    public static Vector connections = new Vector();
    public static Map downloadsToIndices = new HashMap();
    public static Map indicesToDownloads = new HashMap();
    public static int currentDownloadIndex = 0;
            

/* Callbacks */
    
    /* Connections */
        
        public void connectionInitializing(Connection connection) {
        }

        public void connectionInitialized(Connection c1) 
        {
            ManagedConnection c = (ManagedConnection)c1;
            
            if(c.isTempConnection() || c.getAddress().startsWith("0") || c.getUserAgent() == null)
            {
                c.close();
                return;
            }
            
            connections.add(c);
            AqEvent.signalEvent(AqEvent.kLWEventConnectionInitialized, c);
        }

        public void connectionClosed(Connection c) {
            if (connections.contains(c)) {
                AqEvent.signalEvent(AqEvent.kLWEventConnectionClosed, c);
                connections.remove(c);
            }
        }

    /* Queries */
   
        public void handleQueryResult(RemoteFileDesc r, HostData d, Set locs)
        {
            AqEvent.signalEvent(AqEvent.kLWEventQueryResult, r, d, locs);
            return;
        }

        public void handleQueryString(String query) {
        }

    /* Downloads */

        public void addDownload(Downloader d) {
			String index = "" + currentDownloadIndex;
			currentDownloadIndex++;
			indicesToDownloads.put(index, d);
			downloadsToIndices.put(d, index);
            AqEvent.signalEvent(AqEvent.kLWEventAddDownload, d);
        }
    
        public void removeDownload(Downloader d) {
            AqEvent.signalEvent(AqEvent.kLWEventUpdateDownloadStats, d);
            AqEvent.signalEvent(AqEvent.kLWEventRemoveDownload, d);
			String index = (String)downloadsToIndices.get(d);
			downloadsToIndices.remove(d);
			indicesToDownloads.remove(index);
        }

        public void downloadsComplete() {
        }

    /* Uploads */
    
        public void addUpload(Uploader u) {
            /*　heavy
            int s = u.getState();
            if (s != Uploader.LIMIT_REACHED && s != Uploader.COMPLETE && s != Uploader.FILE_NOT_FOUND) {
                AqEvent.signalEvent(AqEvent.kLWEventAddUpload, u);
            }
            */
            AqEvent.signalEvent(AqEvent.kLWEventAddUpload, u);
        }
    
        public void removeUpload(Uploader u) {
            AqEvent.signalEvent(AqEvent.kLWEventRemoveUpload, u);
        }
        
        public void uploaderStateChanged(Uploader u) {
            AqEvent.signalEvent(AqEvent.kLWEventUpdateUploadStats, u);
        }

        public void uploadsComplete() {
        }
    
    /* Browse */

        public void browseHostFailed(GUID guid) {
            System.err.println("browseHostFailed: " + guid);
        }
    
    /* Sharing */
    
        public void addSharedDirectory(File f, File parent) {
        }

        public void addSharedFile(FileDesc f, File parent) {
        }

        public void handleSharedFileUpdate(File f) {
        }

		public void clearSharedFiles() {
        }
    
    /* Misc */

        public void fileManagerLoaded() {
        }

		public void restoreApplication() {
        }
        
		public void showDownloads() {
        }

        public User getUserAuthenticationInfo(String host) {
            return null;
        }

        public void promptAboutCorruptDownload(Downloader dloader) {
            final Downloader theDownloader = dloader;
            new Thread() {
                public void run() {
                    theDownloader.discardCorruptDownload(false);
                }
            }.start();
        }

        public String getHostValue(String key) {
            return null;
        }
        
        public boolean isQueryAlive(GUID guid) {
            return true;
        }
        
        public void componentLoading(String component) {
            System.err.println(component);
        }

        public void setAnnotateEnabled(boolean enabled) {
            DaapManager.instance().setAnnotateEnabled(enabled);
        }
    
        public void handleFileManagerEvent(FileManagerEvent evt) {
            DaapManager.instance().handleFileManagerEvent(evt); 
        }
}