//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.user;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.selections.*;


/**
 *<PRE>
 * 
 * UserInfoNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class UserInfo implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	[Uԍ
	 */
	private int m_uno = 0;
	/**
	 *	[UID
	 */
	private String m_uid = null;
	/**
	 *	pX[h
	 */
	private String m_password = null;
	/**
	 *	O
	 */
	private String m_name = null;
	/**
	 *	
	 */
	private String m_nickname = null;
	/**
	 *	e[
	 */
	private String m_email = null;
	/**
	 *	Ж
	 */
	private String m_company = null;
	/**
	 *	
	 */
	private String m_section = null;
	/**
	 *	db
	 */
	private String m_tel = null;
	/**
	 *	
	 */
	private String m_memo = null;
	/**
	 *	\tO
	 */
	private byte m_dispFlag = DISPLAY;
	public static final int NOT_DISPLAY	= 0;	//\s
	public static final int DISPLAY	= 1;		//\
	/**
	 *	[U
	 */
	private String m_info = null;
	/**
	 *	
	 */
	private int m_permission = GUEST;
	public static final int SYSTEM_MANAGER	= 32;	//VXeǗ
	public static final int PROJECT_MANAGER	= 16;	//vWFNgǗ
	public static final int DEVELOPER		= 8;	//J
	public static final int TESTER		 	= 4;	//eX^[
	public static final int USER		 	= 2;	//[U
	public static final int GUEST		 	= 1;	//QXg
	/**
	 *	ŏIOIt
	 */
	private Date m_lastLogoffDate = null;

	//--------------------- add wani 07/10/18
	/**
	 *	OC
	 */
	private byte m_enableLogin = ENABLE_LOGIN;
	public static final byte DISABLE_LOGIN	= 0;	//OCs
	public static final byte ENABLE_LOGIN	= 1;	//OC
	/**
	 *	fBXpb`
	 */
	private byte m_enableDispatch = ENABLE_DISPATCH;
	public static final byte DISABLE_DISPATCH	= 0;//fBXpb`s
	public static final byte ENABLE_DISPATCH	= 1;	//fBXpb`
	/**
	 *	STuVXe
	 */
	private String m_defSubsystem = null;
	/**
	 *	S@\
	 */
	private String m_defFunctionName = null;
	/**
	 *	SH
	 */
	private String m_defPno = null;
	/**
	 *	gp
	 */
	private String m_defLocation = null;
	/**
	 *	
	 */
	private int m_role;
	
	public static final int ROLE_TESTER = 1;//{
	public static final int ROLE_LEADER = 2;//[_
	public static final int ROLE_TRANSLATER = 3;//|
	public static final int ROLE_ON_SITE = 4;//I-FLEX ON SITE
	public static final int ROLE_DEVELOPER = 5;//I-FLEX developer
	public static final int ROLE_BUILDER = 6;//\ǗS
	public static final int ROLE_MANAGER = 7;//Ǘ
	public static final int ROLE_USER = 8;//[U
	public static final int ROLE_OTHER = 10;//̑
	public static final String ROLE_TESTER_NAME = "{";
	public static final String ROLE_LEADER_NAME = "[_";
	public static final String ROLE_TRANSLATER_NAME = "|";
	public static final String ROLE_ON_SITE_NAME = "I-FLEX ON SITE";
	public static final String ROLE_DEVELOPER_NAME = "I-FLEX developer";
	public static final String ROLE_BUILDER_NAME = "\ǗS";
	public static final String ROLE_MANAGER_NAME = "Ǘ";
	public static final String ROLE_USER_NAME = "[U";
	public static final String ROLE_OTHER_NAME = "̑";
	public static final String[] ROLE_NAMES = {
	        "",ROLE_TESTER_NAME,ROLE_LEADER_NAME,
	        ROLE_TRANSLATER_NAME,ROLE_ON_SITE_NAME,ROLE_DEVELOPER_NAME,
	        ROLE_BUILDER_NAME,ROLE_MANAGER_NAME,ROLE_USER_NAME,ROLE_OTHER_NAME
			};
	
	//--------------------- add wani end
	/**
	 *	[w
	 */
	private int m_mailSubscription;
	public static final int MAIL_DETAIL0	= 0x40000000;	//VK
	public static final int MAIL_DETAIL1	= 0x20000000;	//̏
	public static final int MAIL_DETAIL2	= 0x10000000;	//j
	public static final int MAIL_DETAIL3	= 0x08000000;	//
	public static final int MAIL_DETAIL4	= 0x04000000;	//C
	public static final int MAIL_DETAIL5	= 0x01000000;	//mF
	//--------------------- add wani 07/10/18
	/**
	 *	[wǃTuVXe
	 */
	private String m_mailSubsystem;
	/**
	 *	[wǋ@\
	 */
	private String m_mailFunctionName;
	/**
	 *	gp
	 */
	private int m_language;
	//--------------------- add wani end
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
//=====================================
// [URNV
//=====================================
	/**
	 *	[U
	 */
//	private static Map m_map = null;
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean m_exclusion = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean m_atoIncrement = true;	//
	/**
	 * PK 
	 */
	private static final String[] PK = {"uno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"uid","password","name",
									"nickname","email","company",
									"section","tel","memo", "dispFlag",
									"permission","mailSubscription","lastLogoffDate",
									"enableLogin", "enableDispatch", "defSubsystem",
								    "defFunctionName", "defPno", "defLocation","role",
								    "mailSubsystem", "mailFunctionName",
								    "language",
									"info","updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public UserInfo()
	{
		
	}
	/**
	 *	RXgN^([Uԍj
	 *
	 * @param	uid		String^
	 */
	public UserInfo(int uno)
	{
		setUno(uno);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		setUpdateDate(new Date());
		int uno = DAO.insert(this);
		setUno(uno);
		
		load();		//ŏIXVق̂ōă[h
		
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		
		load();		//ŏIXVق̂ōă[h
		
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
		
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		
		DAO.load(this);
		
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		
		return DAO.findAll(new UserInfo());
		
	}
	/**
	 *	findUid
	 *
	 * @return	
	 */
	public static UserInfo findUid(String uid)
	{
		
		String sql = "SELECT * FROM UserInfo WHERE uid = ?";
		ArrayList params = new ArrayList();
		params.add(uid);
		
		ArrayList list = DAO.find(new UserInfo(), sql, params);
		
		UserInfo userInfo = null;
		if ((list != null) && (list.size() > 0)) {
			userInfo = (UserInfo)list.get(0);
		}
		return userInfo;
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return true;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return true;
	}
//======================================
// Collection
//======================================
	/**
	 *	S[U̎擾
	 *
	 * @return	
	 */
	public static Collection getAllUser()
	{
		String sql = "SELECT * FROM UserInfo WHERE dispFlag = 1 ORDER BY defSubsystem,uid";
		ArrayList params = new ArrayList();
		
		return (DAO.find(new UserInfo(), sql, params));
	}
	/**
	 *	[U̎擾iwj
	 *
	 * @return	
	 */
	public static Collection getPermissionUser(int permission)
	{
		String sql = "SELECT * FROM UserInfo WHERE permission >= ? AND dispFlag = 1 ORDER BY defSubsystem,uid";
		ArrayList params = new ArrayList();
		params.add(new Integer(permission));
		
		return (DAO.find(new UserInfo(), sql, params));
	}
	/**
	 *	[U̎擾i[Uԍwj
	 *
	 * @return	
	 */
	public static UserInfo getUser(int uno)
	{
		String sql = "SELECT * FROM UserInfo WHERE uno = ?";
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));
		
		ArrayList list = DAO.find(new UserInfo(), sql, params);
		
		UserInfo userInfo = null;
		if ((list != null) && (list.size() > 0)) {
			userInfo = (UserInfo)list.get(0);
		}
		return userInfo;
	}
	/**
	 *	[U̎擾iE-mailwj
	 *
	 * @return	
	 */
	public static UserInfo getUserForEmail(String email)
	{
		String sql = "SELECT * FROM UserInfo WHERE email = ?";
		ArrayList params = new ArrayList();
		params.add(email);
		
		ArrayList list = DAO.find(new UserInfo(), sql, params);
		
		UserInfo userInfo = null;
		if ((list != null) && (list.size() > 0)) {
			userInfo = (UserInfo)list.get(0);
		}
		return userInfo;
	}
	/**
	 *	[U̎擾iE-mailwǎwj
	 *
	 * @return	
	 */
	public static Collection getUserForMailType(int type)
	{
		String sql = "SELECT * FROM UserInfo WHERE mailSubscription & ?";
		ArrayList params = new ArrayList();
		params.add(new Integer(type));
		
		return DAO.find(new UserInfo(), sql, params);
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
	
		HashMap map = new HashMap();
		map.put("uno", Integer.toString(getUno()));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * [Uԍ̎擾
	 * 
	 * @return [Uԍ
	 */
	public int getUno()
	{
		return m_uno;
	}
	/**
	 * [Uԍ̃Zbg
	 * 
	 * @param uno [Uԍ
	 */
	public void setUno(int uno)
	{
		m_uno = uno;
	}
	/**
	 * [Uԍ̎擾ij
	 * 
	 * @return [Uԍ
	 */
	public String getUnoString()
	{
		String s;
		if (m_uno == 0) {
			s = "#";
		} else {
			s = new Integer(m_uno).toString();
		}
		return s;
	}
	/**
	 * [Uhc̎擾
	 * 
	 * @return [Uhc
	 */
	public String getUid()
	{
		return m_uid;
	}
	/**
	 * [Uhc̃Zbg
	 * 
	 * @param uid [Uhc
	 */
	public void setUid(String uid)
	{
		m_uid = uid;
	}
	/**
	 * pX[h̎擾
	 * 
	 * @return pX[h
	 */
	public String getPassword()
	{
		return m_password;
	}
	/**
	 * pX[h̃Zbg
	 * 
	 * @param password pX[h
	 */
	public void setPassword(String password)
	{
		m_password = password;
	}
	/**
	 * O̎擾
	 * 
	 * @return O
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * ÕZbg
	 * 
	 * @param name O
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * ̂̎擾
	 * 
	 * @return 
	 */
	public String getNickname()
	{
		return m_nickname;
	}
	/**
	 * ̂̃Zbg
	 * 
	 * @param nickname 
	 */
	public void setNickname(String nickname)
	{
		m_nickname = nickname;
	}
	/**
	 * ̂̎擾()
	 * 
	 * @return 
	 */
	public String getNicknameString()
	{
		//VK̏ꍇnullɂȂȂl
		return (m_uno == 0 ? "" : m_nickname);
	}
	/**
	 *	E[̃Zbg
	 *
	 * @param	email		E[
	 */
	public void setEmail(String email)
	{
		m_email = email;
	}
	/**
	 *	E[̎擾
	 *
	 * @return	email		E[
	 */
	public String getEmail()
	{
		return m_email;
	}
	/**
	 *	Ђ̃Zbg
	 *
	 * @param	company		
	 */
	public void setCompany(String company)
	{
		m_company = company;
	}
	/**
	 *	Ђ̎擾
	 *
	 * @return	company		
	 */
	public String getCompany()
	{
		return m_company;
	}
	/**
	 *	̃Zbg
	 *
	 * @param	section		
	 */
	public void setSection(String section)
	{
		m_section = section;
	}
	/**
	 *	̎擾
	 *
	 * @return	section		
	 */
	public String getSection()
	{
		return m_section;
	}
	/**
	 *	TEL̃Zbg
	 *
	 */
	public void setTel(String tel)
	{
		m_tel = tel;
	}
	/**
	 *	TEL̎擾
	 *
	 * @return	tel		TEL
	 */
	public String getTel()
	{
		return m_tel;
	}
	/**
	 *	̎擾
	 *
	 * @return	permission		
	 */
	public int getPermission()
	{
		return m_permission;
	}
	/**
	 *	̃`FbN
	 *
	 * @return	permission		
	 */
	public boolean isForgiven(int permission)
	{
		return ((m_permission & permission) >= 0 ? true : false);
	}
	/**
	 *	̎擾
	 *
	 * @return	permission		
	 */
	public void setPermission(int permission)
	{
		m_permission = permission;
	}
	/**
	 *	()̎擾
	 *
	 * @return	permission		
	 */
	public String getPermissionString()
	{
		StringBuffer sb = new StringBuffer();
		if ((m_permission & SYSTEM_MANAGER) > 0) {
			sb.append("VXeǗ<br>");
		}
		if ((m_permission & PROJECT_MANAGER) > 0) {
			sb.append("vWFNgǗ<br>");
		}
		if ((m_permission & DEVELOPER) > 0) {
			sb.append("J<br>");
		}
		if ((m_permission & TESTER) > 0) {
			sb.append("eX^[<br>");
		}
		if ((m_permission & USER) > 0) {
			sb.append("[U<br>");
		}
		if ((m_permission & GUEST) > 0) {
			sb.append("QXg<br>");
		}
		return new String(sb);
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getMemo()
	{
		return m_memo;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param memo 
	 */
	public void setMemo(String memo)
	{
		m_memo = memo;
	}
	/**
	 * \tO̎擾
	 * 
	 * @return \tO
	 */
	public byte getDispFlag()
	{
		return m_dispFlag;
	}
	/**
	 * \tÕZbg
	 * 
	 * @param dispFlag \tO
	 */
	public void setDispFlag(byte dispFlag)
	{
		m_dispFlag = dispFlag;
	}
	/**
	 * \tOs
	 * 
	 * @return \tO
	 */
	public boolean isDisplay()
	{
		return (m_dispFlag == DISPLAY);
	}
	/**
	 * [U̎擾
	 * 
	 * @return [U
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * [ŨZbg
	 * 
	 * @param Info [U
	 */
	public void setInfo(String info)
	{
		m_info = info;
	}
	/**
	 * ŏIOIt̎擾
	 * 
	 * @return ŏIOIt
	 */
	public Date getLastLogoffDate()
	{
		return m_lastLogoffDate;
	}
	/**
	 * ŏIOIt̎擾
	 * 
	 * @return ŏIOIt
	 */
	public String getLastLogoffDateString()
	{
		return Converter.getDateString(m_lastLogoffDate, Converter.SHORT_DATE_TIME);
	}
	/**
	 * ŏIOIt̃Zbg
	 * 
	 * @param lastLogoffDate ŏIOIt
	 */
	public void setLastLogoffDate(Date lastLogoffDate)
	{
		m_lastLogoffDate = lastLogoffDate;
	}
	/**
	 * [wǂ̎擾
	 * 
	 * @return [w
	 */
	public int getMailSubscription()
	{
		return m_mailSubscription;
	}
	/**
	 * [wǂ̊mF
	 * 
	 * @return 
	 */
	public boolean isSubscription(int mailType)
	{
		return ((m_mailSubscription & mailType) > 0 ? true : false);
	}
	/**
	 * [wǂ̃Zbg
	 * 
	 * @param mailSubscription1 [wǂP
	 */
	public void setMailSubscription(int mailSubscription)
	{
		m_mailSubscription = mailSubscription;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	//add wani 07/10/18 ===========================================
	/**
	 *	OC̎擾
	 *
	 * @return	update		OC
	 */
	public byte getEnableLogin()
	{
		return m_enableLogin;
	}
	/**
	 *	OC̔
	 *
	 * @return	OC
	 */
	public boolean checkEnableLogin()
	{
		return (m_enableLogin == ENABLE_LOGIN);
	}
	/**
	 *	OC̃Zbg
	 *
	 * @return	update		OC
	 */
	public void setEnableLogin(byte enableLogin)
	{
		m_enableLogin = enableLogin;
	}

	/**
	 *	fBXpb`̎擾
	 *
	 * @return	update		fBXpb`
	 */
	public byte getEnableDispatch()
	{
		return m_enableDispatch;
	}
	/**
	 *	fBXpb`̔
	 *
	 * @return	update		fBXpb`
	 */
	public boolean checkEnableDispatch()
	{
		return (m_enableDispatch == ENABLE_DISPATCH);
	}
	/**
	 *	fBXpb`̃Zbg
	 *
	 * @return	update		fBXpb`
	 */
	public void setEnableDispatch(byte enableDispatch)
	{
		m_enableDispatch = enableDispatch;
	}
	/**
	 *	STuVXe̎擾
	 *
	 * @return	update		STuVXe
	 */
	public String getDefSubsystem()
	{
		return m_defSubsystem;
	}
	/**
	 *	STuVXê̎擾
	 *
	 * @return	update		STuVXe
	 */
	public String getDefSubsystemString()
	{
	    String name = null;
	    Subsystem ss = Subsystem.getSubsystem(m_defSubsystem); 
	    if (ss != null) {
	        name = ss.getName();
	    }
	    return  ((name == null) || (name.length() == 0) ? "***" : ss.getName());
	}
	/**
	 *	STuVXẽZbg
	 *
	 * @return	update		STuVXe
	 */
	public void setDefSubsystem(String defSubsystem)
	{
		m_defSubsystem = defSubsystem;
	}
	/**
	 *	S@\̎擾
	 *
	 * @return	update		S@\
	 */
	public String getDefFunctionName()
	{
		return m_defFunctionName;
	}
	/**
	 *	STuVXê̎擾
	 *
	 * @return	update		STuVXe
	 */
	public String getDefFunctionNameString()
	{
	    String name = null;
	    FunctionName func = FunctionName.getFunctionName(m_defFunctionName); 
	    if (func != null) {
	        name = func.getName();
	    }
	    return  ((name == null) || (name.length() == 0) ? "***" : func.getName());
	}
	/**
	 *	S@\̃Zbg
	 *
	 * @return	update		S@\
	 */
	public void setDefFunctionName(String defFunctionName)
	{
		m_defFunctionName = defFunctionName;
	}
	/**
	 *	SH̎擾
	 *
	 * @return	update		SH
	 */
	public String getDefPno()
	{
		return m_defPno;
	}
	/**
	 *	SH̃Zbg
	 *
	 * @return	update		SH
	 */
	public void setDefPno(String defPno)
	{
		m_defPno = defPno;
	}
	/**
	 *	gp̎擾
	 *
	 * @return	update		gp
	 */
	public String getDefLocation()
	{
		return m_defLocation;
	}
	/**
	 *	gp̃Zbg
	 *
	 * @return	update		gp
	 */
	public void setDefLocation(String defLocation)
	{
		m_defLocation = defLocation;
	}
	/**
	 *	[̎擾
	 *
	 * @return	role		[
	 */
	public int getRole()
	{
		return m_role;
	}
	/**
	 *	[̎擾
	 *
	 * @return	role		[
	 */
	public String getRoleName()
	{
		return ROLE_NAMES[m_role];
	}
	
	/**
	 *	[̃Zbg
	 *
	 * @return	role		[
	 */
	public void setRole(int role)
	{
		m_role = role;
	}
	/**
	 *	[wǃTuVXe̎擾
	 *
	 * @return	mailSubsystem		[wǃTuVXe
	 */
	public String getMailSubsystem()
	{
		return m_mailSubsystem;
	}
	/**
	 *	[wǃTuVXẽZbg
	 *
	 * @return	mailSubsystem		[wǃTuVXe
	 */
	public void setMailSubsystem(String mailSubsystem)
	{
		m_mailSubsystem = mailSubsystem;
	}
	/**
	 *	[wǋ@\̎擾
	 *
	 * @return	mailFunctionName		[wǋ@\
	 */
	public String getMailFunctionName()
	{
		return m_mailFunctionName;
	}
	/**
	 *	[wǋ@\̃Zbg
	 *
	 * @return	mailFunctionName		[wǋ@\
	 */
	public void setMailFunctionName(String mailFunctionName)
	{
		m_mailFunctionName = mailFunctionName;
	}
	/**
	 *	gp̎擾
	 *
	 * @return	gp
	 */
	public int getLanguage()
	{
		return m_language;
	}
	/**
	 *	gp̃Zbg
	 *
	 * @return	language		gp
	 */
	public void setLanguage(int language)
	{
		m_language = language;
	}
	
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [USER INFO] --- \n");
		sb.append("uno     : " + m_uno + "\n");
		sb.append("uid     : " + m_uid + "\n");
		sb.append("password: " + m_password + "\n");
		sb.append("name    : " + m_name + "\n");
		sb.append("nickname: " + m_nickname + "\n");
		sb.append("email   : " + m_email + "\n");
		sb.append("company : " + m_company + "\n");
		sb.append("section : " + m_section + "\n");
		sb.append("tel     : " + m_tel + "\n");
		sb.append("memo    : " + m_memo + "\n");
		sb.append("dispFlag: " + m_dispFlag + "\n");
		sb.append("info    : " + m_info + "\n");
		sb.append("permission : " + m_permission + "\n");
		
		sb.append("enableLogin    : " + m_enableLogin + "(login:" + checkEnableLogin() +")\n");
		sb.append("enableDispatch : " + m_enableDispatch + "(dispatch:" + checkEnableDispatch() +")\n");
		sb.append("defSubsystem   : " + m_defSubsystem + "\n");
		sb.append("defFunctionName: " + m_defFunctionName + "\n");
		sb.append("defPno         : " + m_defPno + "\n");
		sb.append("defLocation    : " + m_defLocation + "\n");
		sb.append("role           : " + m_role + "\n");
		sb.append("mailSubsystem  : " + m_mailSubsystem + "\n");
		sb.append("mailFunctionName: " + m_mailFunctionName + "\n");
		sb.append("language       : " + m_language + "\n");

		sb.append("updateUno  : " + m_updateUno + "\n");
		sb.append("updateDate : " + m_updateDate + "\n");
		sb.append("--- [USER INFO] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[UserInfo]" + s);
		 
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << UserInfo Test Start >> -----------");
		
/*-------------------------------
		unitTest1();	//VK[U쐬eXg
		unitTest2();	//[UXVeXg
		unitTest3();	//[U폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//[UIDeXg
		unitTest6();	//[UԍwRXgNgeXg
		unitTest7();	//S[U擾eXg
		unitTest8();	//[U擾eXg
-------------------------------*/
		unitTest9();	//[wǎw擾eXg
		
		System.out.println("------- << UserInfo Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK[U쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		UserInfo userInfo = new UserInfo();
		
		userInfo.setUid("test");
		userInfo.setPassword("test");
		userInfo.setName("\");
		userInfo.setName("eXgY");
		userInfo.setEmail("test@email.co.jp");
		userInfo.setCompany("\");
		userInfo.setSection("ƕPO[v");
		userInfo.setTel("012-3456-7890");
		userInfo.setMemo("");
		userInfo.setDispFlag((byte)1);
		userInfo.setInfo("̃[U̒ǉ");
		userInfo.setPermission(8+4+2+1);
		userInfo.setUpdateUno(1);
		//폜
//		userInfo.delete();
		//ǉ
		userInfo.insert(0);
		
		System.out.println(userInfo.toString());
	}
	/**
	 *	unitTest2
	 *
	 * [UXVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		UserInfo userInfo = new UserInfo();
		
		//ǂݍ
		userInfo.setUno(3);
		userInfo.load();
		System.out.println(userInfo.toString());
		
		userInfo.setUid("test");
		userInfo.setPassword("test");
		userInfo.setName("XV2");
		userInfo.setEmail("test@email.co.jp");
		userInfo.setCompany("\");
		userInfo.setSection("ƕPO[v");
		userInfo.setTel("012-3456-7890");
		userInfo.setMemo("");
		userInfo.setDispFlag((byte)1);
		userInfo.setInfo("̃[U̒ǉ");
		userInfo.setPermission(8+4+2+1);
		userInfo.setUpdateUno(1);
		//XV
		userInfo.update(0);
		
		System.out.println(userInfo.toString());
	}
	/**
	 *	unitTest3
	 *
	 * [U폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		UserInfo userInfo = new UserInfo();
		
		//ǂݍ
		userInfo.setUno(2);
		userInfo.load();
		System.out.println(userInfo.toString());
		
		//폜
		userInfo.delete(2);
		
		UserInfo userInfo2 = new UserInfo();
		
		//ǂݍ
		userInfo2.setUno(2);
		userInfo2.load();
		System.out.println(userInfo.toString());
	}
	/**
	 *	unitTest4
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		Collection users = UserInfo.findAll();
		dispUser(users);
	}
	/**
	 *	unitTest5
	 *
	 * [UIDeXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		UserInfo userInfo = UserInfo.findUid("TESTER");
		
		System.out.println(userInfo.toString());
	}
	/**
	 *	unitTest6
	 *
	 * [UԍRXgNgeXg
	 *
	 */
	public static void unitTest6()
	{
		System.out.println("------- unitTest6 -----------");
		
		UserInfo userInfo = new UserInfo(4);
		
		System.out.println(userInfo.toString());
	}
	/**
	 *	unitTest7
	 *
	 * S[U擾eXg
	 *
	 */
	public static void unitTest7()
	{
		System.out.println("------- unitTest7 -----------");
		
		Collection users = UserInfo.getAllUser();
		dispUser(users);
		
	}
	/**
	 *	unitTest8
	 *
	 * [U擾eXgip[~bVwj
	 *
	 */
	public static void unitTest8()
	{
		System.out.println("------- unitTest8 -----------");
		
		Collection users = null;
		
		users = UserInfo.getPermissionUser(SYSTEM_MANAGER);
		System.out.println("SYSTEM_MANAGER");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(PROJECT_MANAGER);
		System.out.println("PROJECT_MANAGER");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(DEVELOPER);
		System.out.println("DEVELOPER");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(TESTER);
		System.out.println("TESTER");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(USER);
		System.out.println("USER");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(GUEST);
		System.out.println("GUEST");
		dispUser(users);
		
		users = UserInfo.getPermissionUser(PROJECT_MANAGER + DEVELOPER);
		System.out.println("PROJECT_MANAGER + DEVELOPER");
		dispUser(users);
	}
	/**
	 *	unitTest9
	 *
	 * [U擾eXgi[wǎwj
	 *
	 */
	public static void unitTest9()
	{
		System.out.println("------- unitTest9 -----------");
		
		Collection users = null;
		
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL0);
		System.out.println("VK");
		dispUser(users);
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL1);
		System.out.println("̏");
		dispUser(users);
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL2);
		System.out.println("j");
		dispUser(users);
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL3);
		System.out.println("");
		dispUser(users);
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL4);
		System.out.println("C");
		dispUser(users);
		users = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL5);
		System.out.println("mF");
		dispUser(users);
	}
	/**
	 * [UXg̕\
	 *
	 */
	private static void dispUser(Collection users)
	{
		Iterator ite = users.iterator();
		
		while(ite.hasNext()) {
			UserInfo user = (UserInfo)ite.next();
			
			System.out.println(user.getUno() + "-" + user.getNickname());
		}
	}
}