//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * SpecVersionNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class SpecVersion implements IUpdatable, ILoadable, ISelection
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	R[h
	 */
	private String m_code = null;
	/**
	 *	O
	 */
	private String m_name = null;
	/**
	 *	
	 */
	private String m_shortName = null;
	/**
	 *	
	 */
	private String m_info = null;
	//add 08.02.11
	/**
	 *	\tO
	 */
	private byte m_dispFlag = 1;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"code"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"code","name","shortName",
									"dispFlag",					//08.02.11
									"info","updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public SpecVersion()
	{
		
	}
	/**
	 *	RXgN^(R[hwj
	 *
	 * @param	 code		String^
	 */
	public SpecVersion(String code)
	{
		setCode(code);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
//		setUpdateDate(new Date());
		DAO.insert(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new SpecVersion());
	}
	/**
	 *	SpecVersion̎擾iR[hwj
	 *
	 * @return	
	 */
	public static SpecVersion getSpecVersion(String code)
	{
		String sql = "SELECT * FROM SpecVersion WHERE code = ?";
		ArrayList params = new ArrayList();
		params.add(code);
		
		ArrayList list = DAO.find(new SpecVersion(), sql, params);
		
		SpecVersion resolution = null;
		if ((list != null) && (list.size() > 0)) {
			resolution = (SpecVersion)list.get(0);
		}
		return resolution;
	}
	//add  08.02.11
	/**
	 * x\pRNV
	 */
	public static Collection getLabelCollection()
	{
		String sql = "SELECT code,name,shortName FROM SpecVersion where dispFlag = 1 ORDER BY code";
		ArrayList params = new ArrayList();
		
		ArrayList list = DAO.find(new SpecVersion(), sql, params);
		
		return list;
	}
	/**
	 * x\pRNV(\܂ށj
	 */
	public static Collection getLabelCollectionForAdmin()
	{
		String sql = "SELECT code,name,shortName FROM SpecVersion ORDER BY code";
		ArrayList params = new ArrayList();
		
		ArrayList list = DAO.find(new SpecVersion(), sql, params);
		
		return list;
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("t", "SpecVersion");
		map.put("code", m_code);
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * R[h̎擾
	 * 
	 * @return R[h
	 */
	public String getCode()
	{
		return m_code;
	}
	/**
	 * R[h̃Zbg
	 * 
	 * @param code R[h
	 */
	public void setCode(String code)
	{
		m_code = code;
	}
	/**
	 * O̎擾
	 * 
	 * @return O
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * O̎擾(xp)
	 * 
	 * @return O
	 */
	public String getNameLabel()
	{
		String s = null;
		if (m_code.equals("00")) {
			s = "";
		} else {
			s = m_code + "-" + m_name;
		}
		return s;
	}
	/**
	 * ÕZbg
	 * 
	 * @param name O
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * ̂̎擾
	 * 
	 * @return 
	 */
	public String getShortName()
	{
		return m_shortName;
	}
	/**
	 * ̂̃Zbg
	 * 
	 * @param shortName 
	 */
	public void setShortName(String shortName)
	{
		m_shortName = shortName;
	}
	/**
	 * ̂̎擾()
	 * 
	 * @return 
	 */
	public String getShortnameString()
	{
		//VK̏ꍇnullɂȂȂl
		return (m_code == null ? "" : m_shortName);
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param info 
	 */
	public void setInfo(String info)
	{
		m_info = info;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		String s = null;
		if (m_updateDate != null) {
			s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(m_updateDate);
		}
		return s;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
    /**
     * @return \tO ߂܂B
     */
    public byte getDispFlag() {
        return m_dispFlag;
    }
    /**
     * @param pFlag \tO ݒB
     */
    public void setDispFlag(byte pFlag) {
        m_dispFlag = pFlag;
    }
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [SpecVersion] --- \n");
		sb.append("code     : " + m_code + "\n");
		sb.append("name     : " + m_name + "\n");
		sb.append("shortName: " + m_shortName + "\n");
		sb.append("info     : " + m_info + "\n");
		//08.02.11
		sb.append("dispflag : " + m_dispFlag + "\n");
		
		sb.append("updateUno  : " + m_updateUno + "\n");
		sb.append("updateDate : " + getUpdateDateString() + "\n");
		sb.append("--- [SpecVersion] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[SpecVersion]" + s);
		 
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << SpecVersion Test Start >> -----------");
		
		unitTest1();	//VK쐬eXg
		unitTest2();	//XVeXg
		unitTest3();	//폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//R[hwRXgNgeXg
		
		System.out.println("------- << SpecVersion Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//݃`FbN
		SpecVersion target = SpecVersion.getSpecVersion("99");
		if (target != null) {
			//݂Ă폜
			target.delete(1);
		}
		//l̃Zbg
		SpecVersion resolution = new SpecVersion();
		resolution.setCode("99");
		resolution.setName("O");
		resolution.setShortName("");
		resolution.setInfo("");
		
		//ǉ
		resolution.insert(0);
		
		System.out.println(resolution.toString());
	}
	/**
	 *	unitTest2
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		SpecVersion resolution = SpecVersion.getSpecVersion("99");
		if (resolution == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(resolution.toString());
		
		resolution.setName("OQ");
		resolution.setShortName("̂Q");
		resolution.setInfo("Q");
		//XV
		resolution.update(1);
		
		System.out.println(resolution.toString());
	}
	/**
	 *	unitTest3
	 *
	 * [U폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		SpecVersion resolution = SpecVersion.getSpecVersion("99");
		if (resolution == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(resolution.toString());
		
		//폜
		resolution.delete(2);
		
		//݃`FbN
		resolution = SpecVersion.getSpecVersion("99");
		if (resolution != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest4
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		Collection list = SpecVersion.findAll();
		display(list);
	}
	/**
	 *	unitTest5
	 *
	 * R[hRXgNgeXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		SpecVersion resolution = new SpecVersion("01");
		
		System.out.println(resolution.toString());
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			SpecVersion resolution = (SpecVersion)ite.next();
			
			System.out.println(resolution.getCode() + "-" + resolution.getName());
		}
	}
}