//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * ComponentNameNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class ComponentName implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	R|[lghc
	 */
	private String m_cpid = null;
	/**
	 *	R|[lg
	 */
	private String m_name = null;
	/**
	 *	\[X
	 */
	private String m_resource = null;
	/**
	 *	
	 */
	private String m_info = null;
	//add 08.02.11
	/**
	 *	\tO
	 */
	private byte m_dispFlag = 1;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"cpid"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"cpid","name","resource",
									"dispFlag",					//08.02.11
									"info","updateUno" };
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public ComponentName()
	{
		
	}
	/**
	 *	RXgN^(hcwj
	 *
	 * @param	 cpid		String^
	 */
	public ComponentName(String cpid)
	{
		setCpid(cpid);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new ComponentName());
	}
	/**
	 *	ComponentName̎擾iR[hwj
	 *
	 * @return	
	 */
	public static ComponentName getComponentName(String cpid)
	{
		String sql = "SELECT * FROM ComponentName WHERE cpid = ?";
		ArrayList params = new ArrayList();
		params.add(cpid);
		
		ArrayList list = DAO.find(new ComponentName(), sql, params);
		
		ComponentName ComponentName = null;
		if ((list != null) && (list.size() > 0)) {
			ComponentName = (ComponentName)list.get(0);
		}
		return ComponentName;
	}
	//add  08.02.11
	/**
	 * x\pRNV
	 */
	public static Collection getLabelCollection()
	{
		String sql = "SELECT cpid,name FROM ComponentName where dispFlag = 1 ORDER BY cpid";
		ArrayList params = new ArrayList();
		
		ArrayList list = DAO.find(new ComponentName(), sql, params);
		
		return list;
	}
	/**
	 * x\pRNV(\܂ށj
	 */
	public static Collection getLabelCollectionForAdmin()
	{
		String sql = "SELECT cpid,name FROM ComponentName ORDER BY cpid";
		ArrayList params = new ArrayList();
		
		ArrayList list = DAO.find(new ComponentName(), sql, params);
		
		return list;
	}

//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("t", "ComponentName");
		map.put("cpid", m_cpid);
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * ID̎擾
	 * 
	 * @return ID
	 */
	public String getCpid()
	{
		return m_cpid;
	}
	/**
	 * ID̃Zbg
	 * 
	 * @param cpid ID
	 */
	public void setCpid(String cpid)
	{
		m_cpid = cpid;
	}
	/**
	 * O̎擾
	 * 
	 * @return O
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * ÕZbg
	 * 
	 * @param name O
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * \[X̎擾
	 * 
	 * @return \[X
	 */
	public String getResource()
	{
		return m_resource;
	}
	/**
	 * \[X̃Zbg
	 * 
	 * @param resource \[X
	 */
	public void setResource(String resource)
	{
		m_resource = resource;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param info 
	 */
	public void setInfo(String info)
	{
		m_info = info;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
    /**
     * @return \tO ߂܂B
     */
    public byte getDispFlag() {
        return m_dispFlag;
    }
    /**
     * @param pFlag \tO ݒB
     */
    public void setDispFlag(byte pFlag) {
        m_dispFlag = pFlag;
    }
//===========================================================================
// debug methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [ComponentName] --- \n");
		sb.append("cpid     : " + m_cpid + "\n");
		sb.append("name     : " + m_name + "\n");
		sb.append("resource : " + m_resource + "\n");
		sb.append("info     : " + m_info + "\n");
		//08.02.11
		sb.append("dispflag : " + m_dispFlag + "\n");
		
		sb.append("updateUno: " + m_updateUno + "\n");
		sb.append("updateDat: " + getUpdateDateString() + "\n");
		sb.append("--- [ComponentName] --- \n");
		return sb.toString();
	}
//===========================================================================
// test codes
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << ComponentName Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//XVeXg
		unitTest3();	//폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//R[hwRXgNgeXg
		unitTest6();	//xpRNVeXg
		
		System.out.println("------- << ComponentName Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//݃`FbN
		ComponentName target = ComponentName.getComponentName("ALL");
		if (target != null) {
			//݂Ă폜
			target.delete(1);
		}
		//l̃Zbg
		ComponentName compo = new ComponentName();
		compo.setCpid("ALL");
		compo.setName("S");
		compo.setResource("\[X");
		compo.setInfo("");
		
		//ǉ
		compo.insert(0);
		
		System.out.println(compo.toString());
	}
	/**
	 *	unitTest2
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		ComponentName compo = ComponentName.getComponentName("ALL");
		if (compo == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(compo.toString());
		
		compo.setName("SQ");
		compo.setResource("\[XQ");
		compo.setInfo("Q");
		//XV
		compo.update(1);
		
		System.out.println(compo.toString());
	}
	/**
	 *	unitTest3
	 *
	 * 폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		ComponentName compo = ComponentName.getComponentName("ALL");
		if (compo == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(compo.toString());
		
		//폜
		compo.delete(2);
		
		//݃`FbN
		compo = ComponentName.getComponentName("ALL");
		if (compo != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest4
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		Collection list = ComponentName.findAll();
		display(list);
	}
	/**
	 *	unitTest5
	 *
	 * R[hRXgNgeXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		ComponentName ComponentName = new ComponentName("ASP");
		
		System.out.println(ComponentName.toString());
	}
	/**
	 *	unitTest6
	 *
	 * xpRNV̎擾
	 *
	 */
	public static void unitTest6()
	{
		System.out.println("------- unitTest6 -----------");
		
		display(ComponentName.getLabelCollection());
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			ComponentName ComponentName = (ComponentName)ite.next();
			
			System.out.println(ComponentName.getName());
		}
	}
}