//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * StatisticsNX
 * 
 * vp̃~jNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Statistics implements ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	
	 */
	private long m_count;
	/**
	 *	R[h
	 */
	private String m_code;
	/**
	 *	
	 */
	private String m_name;
	/**
	 *	g[^
	 */
	private int m_total;
	
	/**
	 *	䗦tH[}bg
	 */
	private NumberFormat RATIO_FORMAT = new DecimalFormat("0.0");
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * PK 
	 */
	private static final String[] PK = {"count"};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Statistics()
	{
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
//======================================
// Property
//======================================
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public long getCount()
	{
		return m_count;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param count 
	 */
	public void setCount(long count)
	{
		m_count = count;
	}
	/**
	 * R[h̎擾
	 * 
	 * @return R[h
	 */
	public String getCode()
	{
		return m_code;
	}
	/**
	 * R[h̃Zbg
	 * 
	 * @param code R[h
	 */
	public void setCode(String code)
	{
		m_code = code;
	}
	/**
	 * ̂̎擾
	 * 
	 * @return 
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * ̂̃Zbg
	 * 
	 * @param name 
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * g[^̃Zbg
	 * 
	 * @param total g[^
	 */
	public void setTotal(int total)
	{
		m_total = total;
	}
	/**
	 * 䗦̎擾
	 * 
	 * @return 䗦
	 */
	public double getRatio()
	{
		double ret = 0;
		
		if (m_total != 0) {
			ret = ((double)m_count / (double)m_total) * (double)100;
		}
		return ret;
	}
	/**
	 * 䗦̎擾()
	 * 
	 * @return 䗦
	 */
	public String getRatioString()
	{
		return RATIO_FORMAT.format(getRatio());
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [Statistics] --- \n");
		sb.append("count: " + m_count + "\n");
		sb.append("code : " + m_code + "\n");
		sb.append("name : " + m_name + "\n");
		sb.append("total: " + m_total + "\n");
		sb.append("ratio: " + getRatioString() + "\n");
		sb.append("--- [Statistics] --- \n");
		return sb.toString();
	}
}