//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.selections.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugScreenNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugScreen implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	ʂhc
	 */
	private String m_scid = null;
	/**
	 *	Xe[^X
	 */
	private byte m_status = STS_TROUBLE;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// ca
//=====================================
	/**
	 *	ʖ
	 */
	private String m_name = null;
//=====================================
// 萔`
//=====================================
	/**
	 * Xe[^X
	 */
	public static final byte STS_TROUBLE = 0;	//̏
	public static final byte STS_REPAIRED = 1;	//
	public static final byte STS_PENDING = 2;	//ۗ
//=====================================
// ̑`
//=====================================
	/**
	 *	cap
	 */
	private byte m_mode = MODE_NONE;
	public static final byte MODE_NONE   = 0;	//ȂɂȂ
	public static final byte MODE_INSERT = 1;	//ǉ
	public static final byte MODE_DELETE = 2;	//폜
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"bno", "scid"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","scid","status",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public BugScreen()
	{
		
	}
	/**
	 *	RXgN^(hcwj
	 *
	 * @param	 scid		String^
	 */
	public BugScreen(int bno, String scid)
	{
		setBno(bno);
		setScid(scid);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
//		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
//		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	store
	 *
	 * @return	
	 */
	public void store(int uno)
	{
		switch(m_mode) {
		case MODE_INSERT :
			insert(uno);
			break;
		case MODE_DELETE :
			delete(uno);
			break;
		}
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new BugScreen());
	}
	/**
	 *	BugScreen̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static BugScreen getBugScreen(int bno, String scid)
	{
		String sql = 
			"SELECT" +
			" A.bno as bno," +
			" A.scid as scid," +
			" A.status as status," +
			" A.updateUno as updateUno," +
			" A.updateDate as updateDate," +
			" B.name as name" +
			" FROM BugScreen AS A" +
			" LEFT JOIN Screen AS B ON A.scid = B.scid" +
			" WHERE A.bno = ? AND A.scid = ?" +
			" ORDER BY A.bno,A.scid";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		params.add(scid);
		
		ArrayList list = DAO.find(new BugScreen(), sql, params);
		
		BugScreen bugScreen = null;
		if ((list != null) && (list.size() > 0)) {
			bugScreen = (BugScreen)list.get(0);
		}
		return bugScreen;
	}
	/**
	 *	BugScreen̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getScreens(int bno)
	{
		String sql = 
			"SELECT" +
			" A.bno as bno," +
			" A.scid as scid," +
			" A.status as status," +
			" A.updateUno as updateUno," +
			" A.updateDate as updateDate," +
			" B.name as name" +
			" FROM BugScreen AS A" +
			" LEFT JOIN Screen AS B ON A.scid = B.scid" +
			" WHERE A.bno = ?" +
			" ORDER BY A.bno,A.scid";
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return (DAO.find(new BugScreen(), sql, params));
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("bno", new Integer(m_bno));
		map.put("scid", m_scid);
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * oOhc̎擾
	 * 
	 * @return oOhc
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOhc̃Zbg
	 * 
	 * @param bno oOhc
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * ID̎擾
	 * 
	 * @return ID
	 */
	public String getScid()
	{
		return m_scid;
	}
	/**
	 * ID̃Zbg
	 * 
	 * @param scid ID
	 */
	public void setScid(String scid)
	{
		m_scid = scid;
	}
	/**
	 * ʖ̂̎擾
	 * 
	 * @return ʖ
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * ʖ̂̎擾(xp)
	 * 
	 * @return ʖ
	 */
	public String getDisplayName()
	{
		return  m_name + "(" + m_scid + ")";
	}
	/**
	 * ʖ̂̃Zbg
	 * 
	 * @param name ʖ
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * Xe[^X̎擾
	 * 
	 * @return Xe[^X
	 */
	public byte getStatus()
	{
		return m_status;
	}
	/**
	 * Xe[^X̎擾()
	 * 
	 * @return Xe[^X
	 */
	public String getStatusString()
	{
		String s = null;
		switch(m_status) {
		case STS_TROUBLE :
			s = "̏";
			break;
		case STS_REPAIRED :
			s = "";
			break;
		case STS_PENDING :
			s = "ۗ";
			break;
		default :
			s = "(unknown):" + m_status;
			break;
		}
		return s;
	}
	/**
	 * mF󋵂̎擾
	 * 
	 * @return 
	 */
	public boolean getComfirm()
	{
		return (m_status == STS_REPAIRED);
	}
	/**
	 * Xe[^X̃Zbg
	 * 
	 * @param status Xe[^X
	 */
	public void setStatus(byte status)
	{
		m_status = status;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		String s = null;
		if (m_updateDate != null) {
			s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(m_updateDate);
		}
		return s;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	
	/**
	 * ǉ폜[h̎擾
	 * 
	 * @return ǉ폜[h
	 */
	public byte getMode()
	{
		return m_mode;
	}
	/**
	 * ǉ폜[h̎擾
	 * 
	 * @return ǉ폜[h
	 */
	public String getModeString()
	{
		String s = null;
		switch(m_mode) {
		case MODE_NONE :
			s = "NONE";
			break;
		case MODE_INSERT :
			s = "ǉ";
			break;
		case MODE_DELETE :
			s = "폜";
			break;
		default :
			s = "(unknown):" + m_mode;
			break;
		}
		return s;
	}
	/**
	 * ǉ폜[h̃Zbg
	 * 
	 * @param mode ǉ폜[h
	 */
	public void setMode(byte mode)
	{
		m_mode = mode;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugScreen] --- \n");
		sb.append("bno      : " + m_bno + "\n");
		sb.append("scid     : " + m_scid + "\n");
		sb.append("status   : " + getStatusString() + "(" + m_status + ")\n");
		sb.append("mode     : " + getModeString() + "(" + m_mode + ")\n");
		sb.append("updateUno: " + m_updateUno + "\n");
		sb.append("updateDat: " + getUpdateDateString() + "\n");
		sb.append("--- [BugScreen] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugScreen Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//XVeXg
		unitTest3();	//폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//R[hwRXgNgeXg
		unitTest6();	//oOIDw
		
		System.out.println("------- << BugScreen Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//݃`FbN
		BugScreen target = BugScreen.getBugScreen(1, "NOF_AXXDXX");
		if (target != null) {
			//݂Ă폜
			target.delete(1);
		}
		//l̃Zbg
		BugScreen BugScreen = new BugScreen();
		BugScreen.setBno(1);
		BugScreen.setScid("NOF_AXXDXX");
		
		//ǉ
		BugScreen.insert(0);
		
		System.out.println(BugScreen.toString());
	}
	/**
	 *	unitTest2
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		BugScreen bugScreen = BugScreen.getBugScreen(1, "NOF_AXXDXX");
		if (bugScreen == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(bugScreen.toString());
		
		bugScreen.setStatus(STS_REPAIRED);
		//XV
		bugScreen.update(1);
		
		System.out.println(bugScreen.toString());
	}
	/**
	 *	unitTest3
	 *
	 * 폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		BugScreen bugScreen = BugScreen.getBugScreen(1, "NOF_AXXDXX");
		if (bugScreen == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(bugScreen.toString());
		
		//폜
		bugScreen.delete(2);
		
		//݃`FbN
		bugScreen = BugScreen.getBugScreen(1, "NOF_AXXDXX");
		if (bugScreen != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest4
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		Collection list = BugScreen.findAll();
		display(list);
	}
	/**
	 *	unitTest5
	 *
	 * R[hRXgNgeXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		BugScreen BugScreen = new BugScreen(1, "NOF_A01D01");
		
		System.out.println(BugScreen.toString());
	}
	/**
	 *	unitTest6
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest6()
	{
		System.out.println("------- unitTest6 -----------");
		
		//ǉ
		BugScreen bugScreen = new BugScreen();
		bugScreen.setBno(10);
		
		bugScreen.setScid("NOF_A01D01");
		bugScreen.insert(1);
		bugScreen.setScid("NOF_A02D02");
		bugScreen.insert(1);
		bugScreen.setScid("NOF_A03D03");
		bugScreen.insert(1);
		bugScreen.setScid("NOF_C01D01");
		bugScreen.insert(1);
		bugScreen.setScid("NOF_N02D02");
		bugScreen.insert(1);
		
		Collection list = BugScreen.getScreens(10);
		display(list);
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			BugScreen BugScreen = (BugScreen)ite.next();
			
			System.out.println(BugScreen.toString());
		}
	}
}