//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugListStatisticsNX
 * 
 * TATvp̃~jNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugListStatistics
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	SҖ
	 */
	private String m_name = null;
	/**
	 *	
	 */
	private int m_count1 = 0;
	/**
	 *	
	 */
	private int m_count2 = 0;
	/**
	 *	v
	 */
	private int m_total = 0;
	/**
	 *	Xe[^XʃoOz
	 */
	private ArrayList[] m_bugs;
	
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public BugListStatistics()
	{
		//oOz̏
		m_bugs = new ArrayList[7];
		for (int i = 0; i < 7; i++) {
			m_bugs[i] = new ArrayList();
		}
	}
//======================================
// methods
//======================================
	/**
	 * oOṽZbg
	 * 
	 * @param oOv
	 */
	public void setMemberStatistics(MemberStatistics bug)
	{
		//SҖZbg
		if (m_name == null) {
			m_name = bug.getName();
		}
		
		switch(bug.getStatus()) {
		// mF
		case Bug.STS_UNCONFIRMED :
			m_bugs[0].add(bug);
			m_count1++;
			m_total++;
			break;
		// VK
		case Bug.STS_NEW :
			m_bugs[1].add(bug);
			m_count1++;
			m_total++;
			break;
		// ĊJ
		case Bug.STS_REOPEN :
			m_bugs[2].add(bug);
			m_count1++;
			m_total++;
			break;
		// ͒
		case Bug.STS_INVESTIGATION :
			m_bugs[3].add(bug);
			m_count1++;
			m_total++;
			break;
		// C
		case Bug.STS_REPAIRED :
			m_bugs[4].add(bug);
			m_count1++;
			m_total++;
			break;
		// mF
		case Bug.STS_RESOLVED :
			m_bugs[5].add(bug);
			m_count1++;
			m_total++;
			break;
		// 
		case Bug.STS_CLOSE :
			m_bugs[6].add(bug);
			m_count2++;			//Z
			m_total++;
			break;
		}
		
	}
	/**
	 * S̎擾
	 * 
	 * @return S
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public int getCount1()
	{
		return m_count1;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public int getCount2()
	{
		return m_count2;
	}
	/**
	 * v̎擾
	 * 
	 * @return 
	 */
	public int getTotal()
	{
		return m_total;
	}
	/**
	 * bno̎擾
	 * 
	 * @return bno
	 */
	public Collection getBugs(int i)
	{
		return m_bugs[i];
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugListStatistics] --- \n");
		sb.append("name  : " + m_name + "\n");
		sb.append("count1: " + m_count1 + "\n");
		sb.append("count2: " + m_count2 + "\n");
		sb.append("total: " + m_total + "\n");
		for (int i = 0; i < 7; i++) {
			sb.append("status[" + i + "] ");
			Iterator ite = ((Collection)m_bugs[i]).iterator();
			while(ite.hasNext()) {
				MemberStatistics bug = (MemberStatistics)ite.next();
				sb.append(bug.getBnoString() + " ");
			}
		}
		sb.append("--- [BugListStatistics] --- \n");
		return sb.toString();
	}
}