//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;

import org.apache.struts.action.*;
import org.apache.struts.util.*;

/**
 *<PRE>
 * 
 * BugActivityNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class BugActivity implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	bno
	 */
	private int m_bno = 0;
	/**
	 *	seq
	 */
	private int m_seq = 0;
	/**
	 *	item
	 */
	private String m_item;
	/**
	 *	oldValue
	 */
	private String m_oldValue;
	/**
	 *	newValue
	 */
	private String m_newValue;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XVҖ
	 */
	private String m_updateUname;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * message resources
	 */
	private static MessageResources m_messages =
		MessageResources.getMessageResources("ApplicationResources");
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = false;		//Ȃ
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = true;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"seq"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"bno","seq",
									"item", "oldValue", "newValue",
									"updateUno", "updateDate" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public BugActivity()
	{
		
	}
//======================================
// db aBugActivityess methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		//ӁI
		//̕\ƂɊYoO
		//titjAACeɏoׂ
		//XVtł̓ZbgAaddBugActivityŃZbgĂ
		
//		setSeq(0);
		setUpdateUno(updateUno);
		int seq = DAO.insert(this);
//		setSeq(seq);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new BugActivity());
	}
	/**
	 *	BugActivity̎擾ioOԍwj
	 *
	 * @return	
	 */
	public static Collection getBugActivity(int bno)
	{
		String sql = 
		"SELECT" +
		" A.bno as bno," +
		" A.seq as seq," +
		" A.item as item," +
		" A.oldValue as oldValue," +
		" A.newValue as newValue," +
		" A.updateUno as updateUno," +
		" A.updateDate as updateDate," +
		" B.nickname as updateUname" +
		" FROM BugActivity AS A" +
		" LEFT JOIN UserInfo AS B ON A.updateUno = B.uno" +
		" WHERE A.bno = ?" +
		" ORDER BY A.bno,A.updateDate DESC, A.seq";
		
		ArrayList params = new ArrayList();
		params.add(new Integer(bno));
		
		return DAO.find(new BugActivity(), sql, params);
	}
	/**
	 *	BugActivity̕ۑ
	 *
	 * @return	
	 */
	public static void addBugActivity(Collection col, int bno, int uno)
	{
		
		BugActivity bAct = new BugActivity();
		bAct.setBno(bno);
		bAct.setUpdateDate(new Date());
		
		Iterator ite = col.iterator();
		while(ite.hasNext()) {
			Activity act = (Activity)ite.next();
			bAct.setSeq(0);
			bAct.setItem(act.getId());
			bAct.setOldValue(act.getOldValueString());
			bAct.setNewValue(act.getNewValueString());
			bAct.insert(uno);
		}
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// Property
//======================================
	/**
	 * oOԍ̎擾
	 * 
	 * @return oOԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * oOԍ̃Zbg
	 * 
	 * @param bno oOԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * seq̎擾
	 * 
	 * @return seq
	 */
	public int getSeq()
	{
		return m_seq;
	}
	/**
	 * seq̃Zbg
	 * 
	 * @param seq seq
	 */
	public void setSeq(int seq)
	{
		m_seq = seq;
	}
	/**
	 * item̎擾
	 * 
	 * @return item
	 */
	public String getItem()
	{
		return m_item;
	}
	/**
	 * item̃Zbg
	 * 
	 * @param item item
	 */
	public void setItem(String item)
	{
		m_item = item;
	}
	/**
	 * oldValue̎擾
	 * 
	 * @return oldValue
	 */
	public String getOldValue()
	{
		return m_oldValue;
	}
	/**
	 * oldValuẽZbg
	 * 
	 * @param oldValue oldValue
	 */
	public void setOldValue(String oldValue)
	{
		m_oldValue = oldValue;
	}
	/**
	 * newValue̎擾
	 * 
	 * @return newValue
	 */
	public String getNewValue()
	{
		return m_newValue;
	}
	/**
	 * newValuẽZbg
	 * 
	 * @param newValue newValue
	 */
	public void setNewValue(String newValue)
	{
		m_newValue = newValue;
	}
	/**
	 * XVҖ̎擾
	 * 
	 * @return XVҖ
	 */
	public String getUpdateUname()
	{
		return m_updateUname;
	}
	/**
	 * XVҖ̃Zbg
	 * 
	 * @param updateUname XVҖ
	 */
	public void setUpdateUname(String updateUname)
	{
		m_updateUname = updateUname;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		return Converter.getDateString(m_updateDate, Converter.DATE_TIME);
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	/**
	 *	ACe̎擾
	 *
	 * @return	ACe
	 */
	public String getName() {
		String s = m_messages.getMessage(m_item + ".displayname");
		//OȂꍇږ𖄂߂
		if(s == null) {
			s = "(" + m_item + ")";
		}
		return s;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugActivity] --- \n");
		sb.append("bno       : " + m_bno + "\n");
		sb.append("seq       : " + m_seq + "\n");
		sb.append("item      : " + m_item + "\n");
		sb.append("name      : " + getName() + "\n");
		sb.append("oldValue  : " + m_oldValue + "\n");
		sb.append("newValue  : " + m_newValue + "\n");
		sb.append("upUname   : " + m_updateUname + "\n");
		sb.append("updateUno : " + m_updateUno + "\n");
		sb.append("updateDate: " + getUpdateDateString() + "\n");
		sb.append("--- [BugActivity] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugActivity Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		
		System.out.println("------- << BugActivity Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		
		String[] items = {
						"bno", "bid", "title","location",
						"subsystem","functionName","browser",
						"os","tid", "appVersion"
						};
		
		//l̃Zbg
		BugActivity BugActivity = new BugActivity();
		
		for(int i = 0; i < 10; i++) {
			BugActivity.setBno(2);
			BugActivity.setItem(items[i]);
			BugActivity.setOldValue("old value" + i+1);
			BugActivity.setNewValue("new value" + i+2);
			BugActivity.insert(1);	//ǉ
		}
		
		//\
		display(BugActivity.getBugActivity(2));
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			BugActivity BugActivity = (BugActivity)ite.next();
			
			System.out.println(BugActivity.toString());
		}
	}
}