//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;
import org.apache.struts.util.PropertyMessageResources;
// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;

import org.apache.struts.action.*;
import org.apache.struts.util.*;

/**
 *<PRE>
 * 
 * ActivityNX
 * 
 * NX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Activity
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	Id
	 */
	private String m_id;
	/**
	 *	oldval
	 */
	private Object m_oldValue;
	/**
	 *	newValue
	 */
	private Object m_newValue;
	
	/**
	 * message resources
	 */
//	private static MessageResources m_messages =
//		MessageResources.getMessageResources("ApplicationResources");
//	private ResourceBundle m_messages = ResourceBundle.getBundle("ApplicationResources");
	private MessageString m_ms = new MessageString();

	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	RXgN^
	 *
	 */
	public Activity(String id, Object oldValue, Object newValue)
	{
		m_id = id;
		if (oldValue == null) {
			m_oldValue = "";
		} else {
			m_oldValue = oldValue;
		}
		if (newValue == null) {
			m_newValue = "";
		} else {
			m_newValue = newValue;
		}
	}
//======================================
// Property
//======================================
	/**
	 * hc̎擾
	 * 
	 * @return hc
	 */
	public String getId()
	{
		return m_id;
	}
	/**
	 * OldValue̎擾
	 * 
	 * @return OldValue
	 */
	public String getOldValueString()
	{
		return getValueString(m_oldValue);
	}
	/**
	 * NewValue̎擾
	 * 
	 * @return NewValue
	 */
	public String getNewValueString()
	{
		return getValueString(m_newValue);
	}
	/**
	 * IuWFNg̕\̎擾
	 * 
	 * @return \
	 */
	private String getValueString(Object o)
	{
		StringBuffer sb = new StringBuffer();
		Class clazz = o.getClass();
		//z^
		if (clazz.isArray()) {
			Object[] array = (Object[])o;
			for (int i = 0; i < array.length; i++) {
				//Qڈȍ~̓J}łȂ
				sb.append(sb.length() > 0 ? "," : "");
				sb.append(array[i].toString());
			}
		//Colleciton^H
		} else if (o instanceof Collection) {
			Iterator ite = ((Collection)o).iterator();
			while(ite.hasNext()) {
				//Qڈȍ~̓J}łȂ
				sb.append(sb.length() > 0 ? "," : "");
				sb.append(ite.next().toString());
			}
		//ȊOH
		} else {
			sb.append(o.toString());
		}
		
		return new String(sb);
	}
	public String getName() {
//		String s = m_messages.getMessage(m_id + ".bugitem");
	    //2007/10/27 wani
	    //ʃ\[Xƍ킹邽
//		String s = m_messages.getMessage(m_id + ".displayname");
//		String s = m_messages.getString(m_id + ".displayname");
	    String s = m_ms.get(m_id + ".displayname");
	    
	    System.out.println(m_id + ".displayname:" + s);
		
		//OȂꍇږ𖄂߂
		if(s == null) {
			s = "(" + m_id + ")";
		}
		return s;
	}
	public String toStringForMail() {
		StringBuffer sb = new StringBuffer();
//		sb.append("[" + getName() + "]");
		String newVal = getNewValueString();
		if (getNewValueString().length() > 0) {
			sb.append(getNewValueString());
		} else {
			sb.append("(none)");
		}
		if (getOldValueString().length() > 0) {
			sb.append(" <- " + getOldValueString());
		}
		return new String(sb);
	}
//===========================================================================
// debugging method
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [ACTIVITY] --- \n");
		sb.append("id : " + m_id + "\n");
		sb.append("old: " + getOldValueString() + "\n");
		sb.append("new: " + getNewValueString() + "\n");
		sb.append("--- [ACTIVITY] --- \n");
		return sb.toString();
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */ 
	public static void main(String[] args)
	{
		//eXgJn
		System.out.println("----------Activity class Unit Test start!");
		
		//
		runUnitTest1();
	}
	/**
	 * checkTypẽeXg
	 */ 
	public static void runUnitTest1()
	{
		
		//eXgJn
		System.out.println("<Unit Test1>");
		
		
		Activity act;
		
		//String
		act = new Activity("test1", "old value", "new value");
		System.out.println("act1 = " + act);
		
		//Array
		String[] s1 = new String[] {"str1", "str2", "str3" };
		String[] s2 = new String[] {"str4", "str5", "str6" };
		act = new Activity("test2", s1, s2);
		System.out.println("act2 = " + act);
		
		//Collection
		ArrayList list1 = new ArrayList();
		list1.add("list1");
		list1.add("list2");
		list1.add("list3");
		ArrayList list2 = new ArrayList();
		list2.add("list4");
		list2.add("list5");
		list2.add("list6");
		
		act = new Activity("test2", list1, list2);
		System.out.println("act3 = " + act);
		
		
	}
}