/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;

public class StepPattern
extends NodeTest
implements SubContextList {
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow) {
        super(whatToShow);
    }

    public StepPattern(int whatToShow, String namespace, String name) {
        super(whatToShow, namespace, name);
    }

    protected void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if (this.m_name == "*") {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int i = 0;
        while (i < n) {
            if (this.getPredicate(i).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject score = this.executeStep(xctxt);
        if (score != NodeTest.SCORE_NONE && this.m_relativePathPattern != null) {
            score = this.m_relativePathPattern.executeRelativePathPattern(xctxt);
        }
        return score;
    }

    public XObject executeRelativePathPattern(XPathContext xctxt) throws TransformerException {
        XObject score;
        block4: {
            block3: {
                block2: {
                    Node parent = xctxt.getDOMHelper().getParentOfNode(xctxt.getCurrentNode());
                    if (parent == null) break block3;
                    try {
                        xctxt.pushCurrentNode(parent);
                        score = this.execute(xctxt);
                        if (score == NodeTest.SCORE_NONE) break block2;
                        score = NodeTest.SCORE_OTHER;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        xctxt.popCurrentNode();
                        throw throwable;
                    }
                }
                Object var5_4 = null;
                xctxt.popCurrentNode();
                break block4;
            }
            score = NodeTest.SCORE_NONE;
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject executeStep(XPathContext xctxt) throws TransformerException {
        XObject score = super.execute(xctxt);
        if (score == NodeTest.SCORE_NONE) {
            return score;
        }
        int n = this.getPredicateCount();
        if (n == 0) {
            return score;
        }
        try {
            xctxt.pushSubContextList(this);
            int i = 0;
            while (i < n) {
                XObject pred = this.m_predicates[i].execute(xctxt);
                if (pred.getType() == 2) {
                    if (this.getProximityPosition(xctxt) != (int)pred.num()) {
                        score = NodeTest.SCORE_NONE;
                        break;
                    }
                } else if (!pred.bool()) {
                    score = NodeTest.SCORE_NONE;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            xctxt.popSubContextList();
            throw throwable;
        }
        Object var5_6 = null;
        xctxt.popSubContextList();
        return score;
    }

    public int getLastPos(XPathContext xctxt) {
        Node context = xctxt.getCurrentNode();
        Node parentContext = xctxt.getDOMHelper().getParentOfNode(context);
        try {
            try {
                xctxt.pushCurrentNode(parentContext);
                int count = 0;
                Node child = parentContext.getFirstChild();
                while (child != null) {
                    Object var10_7;
                    block7: {
                        try {
                            xctxt.pushCurrentNode(child);
                            if (NodeTest.SCORE_NONE == super.execute(xctxt)) break block7;
                            ++count;
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xctxt.popCurrentNode();
                            throw throwable;
                        }
                    }
                    var10_7 = null;
                    xctxt.popCurrentNode();
                    child = child.getNextSibling();
                }
                int n = count;
                Object var6_10 = null;
                xctxt.popCurrentNode();
                return n;
            }
            catch (TransformerException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xctxt.popCurrentNode();
            throw throwable;
        }
    }

    public double getMatchScore(XPathContext xctxt, Node context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d = score.num();
            Object var6_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public Expression getPredicate(int i) {
        return this.m_predicates[i];
    }

    public final int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProximityPosition(XPathContext xctxt) {
        Node context = xctxt.getCurrentNode();
        Node parentContext = xctxt.getDOMHelper().getParentOfNode(context);
        try {
            try {
                xctxt.pushCurrentNode(parentContext);
                int pos = 0;
                Node child = parentContext.getFirstChild();
                while (child != null) {
                    Object var10_7;
                    block7: {
                        int n;
                        try {
                            xctxt.pushCurrentNode(child);
                            if (NodeTest.SCORE_NONE == super.execute(xctxt)) break block7;
                            ++pos;
                            if (!child.equals(context)) break block7;
                            n = pos;
                            var10_7 = null;
                            xctxt.popCurrentNode();
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xctxt.popCurrentNode();
                            throw throwable;
                        }
                        Object var6_9 = null;
                        xctxt.popCurrentNode();
                        return n;
                    }
                    var10_7 = null;
                    xctxt.popCurrentNode();
                    child = child.getNextSibling();
                }
            }
            catch (TransformerException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xctxt.popCurrentNode();
            throw throwable;
        }
        Object var6_10 = null;
        xctxt.popCurrentNode();
        return 0;
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        this.calcScore();
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        this.calcScore();
    }
}

