/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GUnzip
extends Task {
    private File source;
    private File dest;

    public void setSrc(String string) {
        this.source = this.project.resolveFile(string);
    }

    public void setDest(String string) {
        this.dest = this.project.resolveFile(string);
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block21: {
            Object object;
            if (this.source == null) {
                throw new BuildException("No source for gunzip specified", this.location);
            }
            if (!this.source.exists()) {
                throw new BuildException("source doesn't exist", this.location);
            }
            if (this.source.isDirectory()) {
                throw new BuildException("Cannot expand a directory", this.location);
            }
            if (this.dest == null) {
                this.dest = new File(this.source.getParent());
            }
            if (this.dest.isDirectory()) {
                object = this.source.getName();
                int n = ((String)object).length();
                this.dest = n > 3 && ".gz".equalsIgnoreCase(((String)object).substring(n - 3)) ? new File(this.dest, ((String)object).substring(0, n - 3)) : new File(this.dest, (String)object);
            }
            if (this.source.lastModified() > this.dest.lastModified()) {
                IOException iOException2222;
                GZIPInputStream gZIPInputStream;
                block20: {
                    this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
                    object = null;
                    gZIPInputStream = null;
                    object = new FileOutputStream(this.dest);
                    gZIPInputStream = new GZIPInputStream(new FileInputStream(this.source));
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        ((FileOutputStream)object).write(byArray, 0, n);
                    } while ((n = gZIPInputStream.read(byArray, 0, byArray.length)) != -1);
                    Object var6_8 = null;
                    if (object == null) break block20;
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (gZIPInputStream != null) {
                    try {
                        gZIPInputStream.close();
                    }
                    catch (IOException iOException2222) {}
                }
                break block21;
                {
                    catch (IOException iOException3) {
                        String string = "Problem expanding gzip " + iOException3.getMessage();
                        throw new BuildException(string, iOException3, this.location);
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException42222;
                    Object var6_9 = null;
                    if (object != null) {
                        try {
                            ((FileOutputStream)object).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (gZIPInputStream != null) {
                        try {
                            gZIPInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

