<?
//==================================================================
//
//    実績データ取得
//	  getACTDATA.php
//		パラメタ	$p_voucher_date		伝票日付
//					$p_voucher_no		伝票番号
//					$p_acc_cd			科目コード
//
//-----------------------------------------------------------------
//  ログイン画面表示
//  作成者	  株式会社クロスキャット
//  更新日	  2012/06/26
//=================================================================

include("./cmn/define.php");
include("./cmn/c_database.php");
include("./cmn/f_html.php");

session_start();

	f_get_act();


// 実績訂正用データ取得
function f_get_act()
{
	global  $g_db;

	$g_db -> logon(1);
	$wstr = "";

	$query = "select A.ACT_REC_NO,  A.VOUCHER_NO, " .
						"to_char(to_date(A.VOUCHER_DATE, 'yyyymmdd'), 'yyyy/mm/dd') AS VOUCHER_DATE, " .
						"A.BUMON_CD, A.ACC_CD, K.ACC_NM, A.REMARKS, " .
						"A.AMOUNT, A.BILL_NO, ".						
						"B.BUMON_NM " .
						// 2014/04/28 
						// 部門マスタ廃止対応
						// 取得項目に年度追加
						", A.FISCAL_YEAR " .
				"FROM TCT_ACT A " .
				"left outer join TCM_ACC K " .
					"on A.ACC_CD=K.ACC_CD " .
				//====================================================
				//	部門マスタ廃止対応 
				//	部門マスタビューを使用するように変更
				//	2014/04/15 XCAT S.SATO
				//	実績データは複数年度分の取込があるため年度も結合条件に追加する必要があったため修正
				//====================================================
				//"left outer join TCM_BUMON B " .
				"left outer join TCM_BUMON2 B " .
					"on A.BUMON_CD=B.BUMON_CD " .
					"and  A.FISCAL_YEAR=B.FISCAL_YEAR " .
				" where ";

	if($_POST["p_voucher_date"] != ""){
		$wstr = " A.VOUCHER_DATE = '" . $_POST["p_voucher_date"] . "'";
	}

	if($_POST["p_voucher_no"] != ""){
		if($wstr == ""){
			$wstr = " A.VOUCHER_NO = '" . $_POST["p_voucher_no"] . "'";
		} else {
			$wstr .= " AND A.VOUCHER_NO = '" . $_POST["p_voucher_no"] . "'";
		}
	}

	if($_POST["p_acc_cd"] != ""){
		if($wstr == ""){
			$wstr = " A.ACC_CD = '" . $_POST["p_acc_cd"] . "'";
		} else {
			$wstr .= " AND A.ACC_CD = '" . $_POST["p_acc_cd"] . "'";
		}
	}

	$query .= $wstr . " order by A.VOUCHER_DATE, A.VOUCHER_NO, A.ACC_CD";
//echo $query;
//exit;
	$result = $g_db -> getdata($query);

	$g_db ->logoff();

	for( $i=0; $i<$result["nrows"]; $i++ ){
		$tsv =	$result["ACT_REC_NO"][$i] . "\t" .		// 実績レコード番号
				"0" . "\t" .							// 処理区分
				$result["VOUCHER_DATE"][$i] . "\t" .	// 伝票日付
				$result["VOUCHER_NO"][$i] . "\t" .		// 伝票番号
				$result["BUMON_CD"][$i] . "\t" .		// 部門コード
				$result["BUMON_NM"][$i] . "\t" .		// 部門名
				$result["ACC_CD"][$i] . "\t" .			// 勘定科目コード
				$result["ACC_NM"][$i] . "\t" .			// 勘定科目名称
				$result["REMARKS"][$i] . "\t" .			// 摘要
				$result["AMOUNT"][$i] . "\t" .			// 金額
				$result["BILL_NO"][$i] . "\t" .			// 手形番号
				// 2014/04/28 
				// 取得項目に年度追加
				$result["FISCAL_YEAR"][$i] . "\n";		// 年度
		echo $tsv;
	}
}
?>
