using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Browser
{
    /// <summary>
    /// ݒ_CAO\tH[łB
    /// </summary>
    public partial class SettingsForm : Form
    {

        /// <summary>
        /// ݒێBoonSerializableConfigIuWFNgłB
        /// IuWFNgɏ܂B
        /// </summary>
        private BoonSerializableConfig boonConfig_;

        /// <summary>
        /// RXgN^łB
        /// OĂяo邱Ƃ͂܂B
        /// </summary>
        private SettingsForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// RXgN^łB
        /// </summary>
        /// <param name="boonConfig">ݒێBoonSerializableConfigIuWFNg</param>
        public SettingsForm(BoonSerializableConfig boonConfig)
        {
            this.boonConfig_ = boonConfig;
            this.InitializeComponent();
            this.setConfigValue();
        }

        /// <summary>
        /// ݒێBoonSerializableConfigIuWFNgAݒtH[ɐݒ肵܂B
        /// </summary>
        private void setConfigValue()
        {
            this.comboBox101_StartUpStatus.SelectedIndex = this.boonConfig_.startUpStatus;
            this.textBox101_HomeUrl.Text = this.boonConfig_.homeUrl;
            this.textBox102_SaveFolder.Text = this.boonConfig_.saveFolderPath;
            this.textBox103_MaxDownloadConnections.Text = this.boonConfig_.maxDownloadConnections.ToString();

            this.textBox201_MaxTabTitleTextCount.Text = this.boonConfig_.maxTitleTextCount.ToString();
            this.checkBox201_IsTitleStringDeleted.Checked = this.boonConfig_.isTitleStringDeleted;
            this.textBox202_DeleteTitleString.Text = this.boonConfig_.deleteTitleString;
            this.textBox203_HistoryExpireDate.Text = this.boonConfig_.historyExpiredDate.ToString();
            this.radioButton201_DefaultBrowser.Checked = this.boonConfig_.isDefaultBrowserProgram;
            this.radioButton202_ExternalBrowser.Checked = (!this.boonConfig_.isDefaultBrowserProgram);
            this.textBox204_BrowserProgram.Text = this.boonConfig_.browserProgram;

            this.checkBox301_IsAutoLoginEnabled.Checked = this.boonConfig_.isAutoLoginEnabled;
            this.textBox301_LoginMailAddress.Text = this.boonConfig_.loginMailAddress;
            this.textBox302_LoginPassword.Text = this.boonConfig_.loginPassword;

            this.radioButton401_PlaySwfOnLocalPlayer.Checked = this.boonConfig_.isSwfPlayedOnLocalPlayer;
            this.radioButton402_PlaySwfOnBrowser.Checked = (!this.boonConfig_.isSwfPlayedOnLocalPlayer);
            this.textBox401_SwfPlayerProgram.Text = this.boonConfig_.swfPlayerProgram;

            this.radioButton501_DefalutProxy.Checked = this.boonConfig_.isDefaultProxy;
            this.radioButton502_SpecifyProxy.Checked = (!this.boonConfig_.isDefaultProxy);
            this.textBox501_ProxyAddress.Text = this.boonConfig_.proxyAddress;
            this.textBox502_ProxyPort.Text = this.boonConfig_.proxyPort;
            this.textBox503_ProxyException.Text = this.boonConfig_.proxyException;
            this.checkBox501_InvokeProxyAtStartUp.Checked = this.boonConfig_.isLocalProxyInvokedAtStartUp;
            this.textBox504_LocalProxyProgram.Text = this.boonConfig_.localProxyProgram;
            this.textBox505_LocalProxyProgramInvokeWaitSeconds.Text = this.boonConfig_.localProxyProgramInvokeWaitSeconds.ToString();

            this.checkBox601_IsKeyAddedToFilename.Checked = this.boonConfig_.isKeyAddedToFilename;
            this.checkBox602_IsAllSaveTreeExpandAtStartUp.Checked = this.boonConfig_.isAllSaveTreeExpandAtStartUp;
            this.checkBox603_IsAllColumnSelectedInDownloadList.Checked = this.boonConfig_.isAllColumnSelectedInDownloadList;
            this.checkBox604_HideErrorWhileDownloading.Checked = this.boonConfig_.hideErrorWhileDownloading;
            this.checkBox605_IsMouseWheelEffectedUnderCursor.Checked = this.boonConfig_.isMouseWheelEffectedUnderCursor;
        }

        /// <summary>
        /// boonConfig_IuWFNgtH[̒lōXV܂B
        /// ̃\bhł́AtH[̃`FbN͎sȂ̂ŁAOisFormValid\bhŐmFĂ
        /// Ăяo悤ɂĂB
        /// </summary>
        private void updateConfigValue()
        {
            this.boonConfig_.startUpStatus = this.comboBox101_StartUpStatus.SelectedIndex;
            this.boonConfig_.homeUrl = this.textBox101_HomeUrl.Text;
            this.boonConfig_.saveFolderPath = this.textBox102_SaveFolder.Text;
            this.boonConfig_.maxDownloadConnections = Int32.Parse(this.textBox103_MaxDownloadConnections.Text);

            this.boonConfig_.maxTitleTextCount = Int32.Parse(this.textBox201_MaxTabTitleTextCount.Text);
            this.boonConfig_.isTitleStringDeleted = this.checkBox201_IsTitleStringDeleted.Checked;
            this.boonConfig_.deleteTitleString = this.textBox202_DeleteTitleString.Text;
            this.boonConfig_.historyExpiredDate = Int32.Parse(this.textBox203_HistoryExpireDate.Text);
            this.boonConfig_.isDefaultBrowserProgram = this.radioButton201_DefaultBrowser.Checked;
            this.boonConfig_.browserProgram = this.textBox204_BrowserProgram.Text;

            this.boonConfig_.isAutoLoginEnabled = this.checkBox301_IsAutoLoginEnabled.Checked;
            this.boonConfig_.loginMailAddress = this.textBox301_LoginMailAddress.Text;
            this.boonConfig_.loginPassword = this.textBox302_LoginPassword.Text;

            this.boonConfig_.isSwfPlayedOnLocalPlayer = this.radioButton401_PlaySwfOnLocalPlayer.Checked;
            this.boonConfig_.swfPlayerProgram = this.textBox401_SwfPlayerProgram.Text;

            this.boonConfig_.isDefaultProxy = this.radioButton501_DefalutProxy.Checked;
            this.boonConfig_.proxyAddress = this.textBox501_ProxyAddress.Text;
            this.boonConfig_.proxyPort = this.textBox502_ProxyPort.Text;
            this.boonConfig_.proxyException = this.textBox503_ProxyException.Text;
            this.boonConfig_.isLocalProxyInvokedAtStartUp = this.checkBox501_InvokeProxyAtStartUp.Checked;
            this.boonConfig_.localProxyProgram = this.textBox504_LocalProxyProgram.Text;
            this.boonConfig_.localProxyProgramInvokeWaitSeconds = Int32.Parse(this.textBox505_LocalProxyProgramInvokeWaitSeconds.Text);

            this.boonConfig_.isKeyAddedToFilename = this.checkBox601_IsKeyAddedToFilename.Checked;
            this.boonConfig_.isAllSaveTreeExpandAtStartUp = this.checkBox602_IsAllSaveTreeExpandAtStartUp.Checked;
            this.boonConfig_.isAllColumnSelectedInDownloadList = this.checkBox603_IsAllColumnSelectedInDownloadList.Checked;
            this.boonConfig_.hideErrorWhileDownloading = this.checkBox604_HideErrorWhileDownloading.Checked;
            this.boonConfig_.isMouseWheelEffectedUnderCursor = this.checkBox605_IsMouseWheelEffectedUnderCursor.Checked;

        }
        
        /// <summary>
        /// tH[ɓ͂ꂽf[^`FbN܂B
        /// sڂ΁AbZ[W{bNX\AfalseԂ܂B
        /// </summary>
        /// <returns>tH[̓͂łtrue</returns>
        private bool isFormValid()
        {

            #region (TabIndex = 0)̃`FbN

            if (this.textBox102_SaveFolder.Text.Equals(""))
            {
                MessageBox.Show("ۑtH_͂ĂB");
                this.tabControl01_Settings.TabPages[0].Select();
                this.textBox102_SaveFolder.Focus();
                return (false);
            }

            if (!Directory.Exists(this.textBox102_SaveFolder.Text))
            {
                MessageBox.Show("ۑtH_݂܂B\ntH_쐬ĂB");
                this.tabControl01_Settings.TabPages[0].Select();
                this.textBox102_SaveFolder.Focus();
                return (false);
            }

            if (this.textBox103_MaxDownloadConnections.Equals(""))
            {
                this.textBox103_MaxDownloadConnections.Text = "1";
            }

            if (Regex.IsMatch(this.textBox103_MaxDownloadConnections.Text, "[^1-3]"))
            {
                MessageBox.Show("ő_E[h1-3͈̔͂œ͂ĂB");
                this.tabControl01_Settings.TabPages[0].Select();
                this.textBox103_MaxDownloadConnections.Focus();
                return (false);
            }

            #endregion

            #region (TabIndex = 1)̃`FbN

            if (this.textBox201_MaxTabTitleTextCount.Text.Equals(""))
            {
                this.textBox201_MaxTabTitleTextCount.Text = "0";
            }

            if (Regex.IsMatch(this.textBox201_MaxTabTitleTextCount.Text, "[^0-9]"))
            {
                MessageBox.Show("^Cg̍ő啶͐l͂ĂB");
                this.tabControl01_Settings.TabPages[1].Select();
                this.textBox201_MaxTabTitleTextCount.Focus();
                return (false);
            }

            if (this.textBox203_HistoryExpireDate.Text.Equals(""))
            {
                this.textBox203_HistoryExpireDate.Text = "0";
            }

            if (Regex.IsMatch(this.textBox203_HistoryExpireDate.Text, "[^0-9]"))
            {
                MessageBox.Show("ۑ͐l͂ĂB");
                this.tabControl01_Settings.TabPages[1].Select();
                this.textBox203_HistoryExpireDate.Focus();
                return (false);
            }

            if ((this.radioButton202_ExternalBrowser.Checked) && (this.textBox204_BrowserProgram.Text.Equals("")))
            {
                MessageBox.Show("OuEU͂Ă܂B");
                this.tabControl01_Settings.TabPages[1].Select();
                this.textBox204_BrowserProgram.Focus();
                return(false);
            }

            #endregion

            #region (TabIndex = 2)̃`FbN

            if
            (
                (this.checkBox301_IsAutoLoginEnabled.Checked)
            &&
                (
                    (this.textBox301_LoginMailAddress.Text.Equals("")) || (this.textBox302_LoginPassword.Text.Equals(""))
                )
            )
            {
                MessageBox.Show("OC̏񂪓͂Ă܂B");
                this.tabControl01_Settings.TabPages[2].Select();
                if (this.textBox301_LoginMailAddress.Text.Equals(""))
                {
                    this.textBox301_LoginMailAddress.Focus();
                }
                else
                {
                    this.textBox302_LoginPassword.Focus();
                }
                return (false);
            }

            #endregion

            #region (TabIndex = 3)̃`FbN

            if ((this.radioButton401_PlaySwfOnLocalPlayer.Checked) && (this.textBox401_SwfPlayerProgram.Text.Equals("")))
            {
                MessageBox.Show("SWFvC[IĂ܂B");
                this.tabControl01_Settings.TabPages[3].Select();
                return (false);
            }

            #endregion

            #region (TabIndex = 4)̃`FbN

            if
            (
                (this.radioButton502_SpecifyProxy.Checked)
            &&
                (
                    (this.textBox501_ProxyAddress.Text.Equals(""))
                ||
                    (this.textBox502_ProxyPort.Text.Equals(""))
                ||
                    (Regex.IsMatch(this.textBox502_ProxyPort.Text, "[^0-9]") )
                )
            )
            {
                MessageBox.Show("vNV̏񂪐͂Ă܂B");
                this.tabControl01_Settings.TabPages[4].Select();
                if (this.textBox501_ProxyAddress.Text.Equals(""))
                {
                    this.textBox501_ProxyAddress.Focus();
                }
                else
                {
                    this.textBox502_ProxyPort.Focus();
                }
                return (false);
            }

            if ((this.checkBox501_InvokeProxyAtStartUp.Checked) && (this.textBox504_LocalProxyProgram.Text.Equals("")))
            {
                MessageBox.Show("vNVvOIĂ܂B");
                this.tabControl01_Settings.TabPages[4].Select();
                return (false);
            }

            if (this.textBox505_LocalProxyProgramInvokeWaitSeconds.Text.Equals(""))
            {
                this.textBox505_LocalProxyProgramInvokeWaitSeconds.Text = "0";
            }

            if (Regex.IsMatch(this.textBox505_LocalProxyProgramInvokeWaitSeconds.Text, "[^0-9]"))
            {
                MessageBox.Show("N҂Ԃ͐͂ĂB");
                this.tabControl01_Settings.TabPages[4].Select();
                return (false);
            }

            #endregion

            return (true);
        }

        #region Cxg

        /// <summary>
        /// OK{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		private void button001_Ok_Click(object sender, EventArgs e)
		{
            /// boonConfig_̍XVAtH[
            if (this.isFormValid())
            {
                this.updateConfigValue();
                this.boonConfig_.serializeConfigValue();
                this.boonConfig_ = null;
                this.Close();
                this.Dispose();
            }
		}

        /// <summary>
        /// LZ{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button002_Cancel_Click(object sender, EventArgs e)
        {
            this.boonConfig_ = null;
            this.Close();
            this.Dispose();
        }

        /// <summary>
        /// ũ݂y[Wgpv{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button101_UseCurrentPageAsHome_Click(object sender, EventArgs e)
        {
            this.textBox101_HomeUrl.Text = ((MainForm)this.Owner).getCurrentURL();
        }

        /// <summary>
        /// ۑtH_I{^ꂽۂ̃CxgłB
        /// FolderBrowserDialog\܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button102_SelectSaveFolder_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.SelectedPath = this.textBox102_SaveFolder.Text;
            fbd.Description = "ۑtH_I";
            if (fbd.ShowDialog() == DialogResult.OK)
            {
                this.textBox102_SaveFolder.Text = fbd.SelectedPath;
            }
        }

        /// <summary>
        /// OuEUIQƃ{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button201_SelectBrowserProgram_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "OuEUIĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                this.textBox204_BrowserProgram.Text = ofd.FileName;
            }
        }

        /// <summary>
        /// SWFvC[vOIQƃ{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button401_SelectSwfPlayer_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "SWFvC[IĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                this.textBox401_SwfPlayerProgram.Text = ofd.FileName;
            }

        }

        /// <summary>
        /// vNVvOIQƃ{^ꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void button501_SelectProxyProgram_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = @"st@C(*.exe)|*.exe|ׂẴt@C(*.*)|*.*";
            ofd.Title = "vLVvOIĂ";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                this.textBox504_LocalProxyProgram.Text = ofd.FileName;
            }

        }

        #endregion

    }
}