using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
//using System.Drawing.Drawing2D;
//using System.IO;
using System.Text.RegularExpressions;
using System.Runtime.InteropServices;

namespace TabBrowser
{
	/// <summary>
	/// ȒPȃ^uuEU[p̃Rg[񋟂܂B: Panelp
	/// </summary>
	public class TabBrowserControl : Panel
	{
		Regex Regex_DownMovieLink = new Regex("^boon://(?<movieid>sm[\\d]{1,10})[/]?$");
		int maxTabCount = 32;
		readonly string blankUrl = "about:blank";
		string HomeUrl { get { return "about:home"; } }
		readonly TabControl core;
		private int menuFocusTab = -1;
		int frg_occs = 0;
		Point tmpGuesturePt = Point.Empty;
		int maxClosedTabHistory = 10;



		#region Settings

		int guestureThres = 10;
		bool setEnableRightClickGuesture = true;
		bool setEnableCenterClickOpen = true;
		/// <summary>
		/// zC[NbNŊJ^uɃtH[JX
		/// </summary>
		bool setFocusOnCenterClickOpen = false;
		/// <summary>
		/// tH[JX̂^uƂɉEփtH[JXڂ
		/// </summary>
		bool setMoveRightWhenFocusedClosed = true;

		bool setEnableTabWheel = true;

		#endregion

		/// <summary>
		/// Cxg̎擾pɌJ (G)
		/// ̃^u͔񐄏ł
		/// </summary>
		public TabControl Core
		{
			get { return this.core; }
		}
		public int ContextMenuTargetTab
		{
			get
			{
				return (this.menuFocusTab >= 0) ?
					this.menuFocusTab : this.TbSelectedIndex;
			}
		}

		/// <summary>
		/// RXgN^B
		/// </summary>
		public TabBrowserControl()
		{
			this.BorderStyle = BorderStyle.None;
			this.Margin = new Padding(0);
			this.Padding = new Padding(0);
			this.core = new TabControl();
			this.core.TabPages.Clear();
			this.core.Dock = DockStyle.Fill;

			this.core.ImageList = new ImageList();
			this.core.ImageList.ImageSize = new Size(4, 4);
			this.core.ImageList.Images.Add("default", Browser.Properties.Resources.none);
			this.core.ImageList.Images.Add(Browser.Properties.Resources.tabLocked, Color.White);

			this.Controls.Add(this.core);

			this.MouseDown += new MouseEventHandler(TabBrowserControl_MouseDown);
			this.MouseClick += new MouseEventHandler(TabBrowserControl_MouseClick);
			this.MouseDoubleClick += new MouseEventHandler(TabBrowserControl_MouseDoubleClick);
			this.core.MouseDown += new MouseEventHandler(core_MouseDown);
			this.core.MouseClick += new MouseEventHandler(core_MouseClick);
			this.core.MouseDoubleClick += new MouseEventHandler(core_MouseDoubleClick);
			this.core.MouseUp += new MouseEventHandler(core_MouseUp);
			this.core.MouseWheel += new MouseEventHandler(core_MouseWheel);
			this.core.SelectedIndexChanged += new EventHandler(core_SelectedIndexChanged);

			this.initializeContext();
			this.initializePageList();

			this.initiaizeClosedHistory();
		}


		// ^uRg[Cxg
		void core_MouseUp(object sender, MouseEventArgs e)
		{
		}
		void core_MouseDown(object sender, MouseEventArgs e)
		{
			this.menuFocusTab = -1;
			for(int i = 0; i < this.TbTabCount; i++)
			{
				if(this.core.GetTabRect(i).Contains(e.Location))
				{
					this.menuFocusTab = i;
					break;
				}
			}

			if(e.Button == MouseButtons.Middle)
			{
				if(this.menuFocusTab < 0)
				{
				}
				else
				{
					this.TbRemove(this.menuFocusTab);
				}
			}
		}
		void core_MouseWheel(object sender, MouseEventArgs e)
		{
			if(this.setEnableTabWheel && this.TbTabCount > 1)
			{
				for(int i = 0; i < this.core.TabCount; i++)
				{
					if(this.core.GetTabRect(i).Contains(e.Location))
					{
						this.TbSelectedIndex = (this.TbTabCount + this.TbSelectedIndex - e.Delta / 120) % this.TbTabCount;
					}
				}
			}
		}
		void core_MouseClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				this.contextMenuStrip100_ForTab.Show(this, e.Location);
			}
		}
		void core_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				for(int i = 0; i < this.TbTabCount; ++i)
				{
					if(this.TbGetTabRect(i).Contains(e.Location))
					{
						this.TbSelectedTab.IsLocked = !this.TbSelectedTab.IsLocked;
						break;
					}
				}
			}
		}

		void core_SelectedIndexChanged(object sender, EventArgs e)
		{
			this.OnSelectedIndexChanged(sender, e);
		}


		// wiplCxg
		void TabBrowserControl_MouseClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Right)
			{
				this.ctxMenuPageList.Show(this, e.Location);
			}
			else if(e.Button == MouseButtons.Middle)
			{
					this.ctxCloseHistory.Show(this, e.Location);
				
			}
		}
		void TabBrowserControl_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Left)
			{
				this.ctxMenuPageList.Hide();
				this.TbOpenNewWindow(blankUrl, this.TbTabCount, false);
			}
		}
		void TabBrowserControl_MouseDown(object sender, MouseEventArgs e)
		{
		}


		// -------------  ---------------- //
		private void actBeforeCloseTab(int index)
		{
			if(this.TbSelectedIndex == index
				&& 0 <= index
				&& index < this.TbTabCount)
			{
				if(this.TbSelectedIndex == 0)// ԍ̃^u
				{
				}
				else if(this.TbSelectedIndex == this.TbTabCount - 1)//ԉẼ^u
				{
					this.TbSelectedIndex = this.TbSelectedIndex - 1;
				}
				else
				{
					this.TbSelectedIndex = this.TbSelectedIndex + (this.setMoveRightWhenFocusedClosed ? 1 : -1);
				}
			}
		}


		// -------------  Methods --------------- //

		#region  -------- Basic Function --------

		public TabBrowserPage this[int index]
		{
			get { return this.TbGetTab(index); }
		}
		public TabBrowserPage this[string key]
		{
			get { return this.TbGetTab(key); }
		}

		public TabBrowserPage TbGetTab(int index)
		{
			return (TabBrowserPage)this.core.TabPages[index];
		}
		public TabBrowserPage TbGetTab(string key)
		{
			return (TabBrowserPage)this.core.TabPages[key];
		}

		public TabBrowserPage TbSelectedTab
		{
			get { return (TabBrowserPage)this.core.SelectedTab; }
			set { this.core.SelectedTab = value; }
		}
		public int TbSelectedIndex
		{
			get { return this.core.SelectedIndex; }
			set { this.core.SelectedIndex = value; }
		}
		public int TbTabCount
		{
			get { return this.core.TabCount; }
		}
		public TabControl.TabPageCollection TbTabPages
		{
			get { return this.core.TabPages; }
		}
		public Rectangle TbGetTabRect(int index)
		{
			return this.core.GetTabRect(index);
		}

		#endregion

		#region  -------- Page Control ----------
		/// <summary>
		/// V^uǉ܂B
		/// </summary>
		/// <param name="page">ǉTabBrowserPage</param>
		public void TbAdd(TabBrowserPage page)
		{
			this.core.TabPages.Add(page);
		}
		/// <summary>
		/// w肵ʒuɐV^uǉ܂B
		/// </summary>
		/// <param name="insertIndex">^uǉʒu</param>
		/// <param name="page">ǉTabBrowserPage</param>
		public void TbAdd(int insertIndex, TabBrowserPage page)
		{
			this.core.TabPages.Insert(insertIndex, page);
		}
		/// <summary>
		/// y[WCollectionO܂BOꂽy[WDispose܂B
		/// QƂcĂKvꍇ̓I[o[Chꂽ̂gpĂB
		/// </summary>
		/// <param name="deleteIndex">폜y[Ẅʒu</param>
		public void TbRemove(int deleteIndex)
		{
			if(this.TbGetTab(deleteIndex).IsLocked)
			{
				return;
			}
			this.actBeforeCloseTab(deleteIndex);
			if(TbGetBrowser(deleteIndex).Url != null)
			{
				this.set_ClosedTabHistory(
					this.TbGetBrowser(deleteIndex).DocumentTitle,
					this.TbGetBrowser(deleteIndex).Url.ToString());
			}
			if(!this.TbGetTab(deleteIndex).IsDisposed)
				this.core.TabPages[deleteIndex].Dispose();
		}
		/// <summary>
		/// y[WCollectionO܂BOꂽy[WDispose܂B
		/// QƂcĂKvꍇ̓I[o[Chꂽ̂gpĂB
		/// </summary>
		/// <param name="deleteIndex">폜y[Ẅʒu</param>
		/// <param name="_ignoreLock">bNꂽ^u폜ꍇtrue</param>
		public void TbRemove(int deleteIndex, bool _ignoreLock)
		{
			if(!_ignoreLock && this.TbGetTab(deleteIndex).IsLocked)
			{
				return;
			}
			this.actBeforeCloseTab(deleteIndex);
			if(this.TbGetBrowser(deleteIndex).Url != null)
			{
				this.set_ClosedTabHistory(
					this.TbGetBrowser(deleteIndex).DocumentTitle,
					this.TbGetBrowser(deleteIndex).Url.ToString());
			}
			if(!this.TbGetTab(deleteIndex).IsDisposed)
				this.core.TabPages[deleteIndex].Dispose();
		}
		/// <summary>
		/// y[WCollectionO܂BłTabPageւ̎QƂc邽߁ADispose܂B
		/// Tab̍ւsꍇ͂gp܂B
		/// ʏ̍폜ɂ̓I[o[Chꂽ̂𗘗pĂB
		/// </summary>
		/// <param name="page">CollectionOy[W̎Q</param>
		public void TbRemove(TabBrowserPage page)
		{
			this.actBeforeCloseTab(this.TbTabPages.IndexOf(page));
			this.core.TabPages.Remove(page);
		}
		/// <summary>
		/// Rg[̃^uׂč폜AWebBrowserj܂
		/// </summary>
		/// <param name="_ignoreLock">bN^u폜ꍇtrue</param>
		public void TbClear(bool _ignoreLock)
		{
			for(int i = 0; i < this.TbTabCount;)
			{
				if((!_ignoreLock) && TbGetTab(i).IsLocked)
				{
					i++;
				}
				else
				{
					this.TbRemove(i);
				}
			}
		}
		/// <summary>
		/// w肵TabPageTabBrowserPageƂėpł邩ǂԂ܂
		/// </summary>
		/// <param name="index">ׂ^ũCfbNX</param>
		/// <returns>TabBrowserPageƂĈꍇtrue</returns>
		public bool TbIsExtendPage(int index)
		{
			return this.core.TabPages[index] is TabBrowserPage;
		}

		#endregion

		#region  -------- Browsing Function --------
		/// <summary>
		/// Iꂽ^uWebuEU擾܂
		/// </summary>
		public WebBrowserEx TbSelectedBrowser
		{
			get
			{
				return (this.TbSelectedIndex >= 0) ?
					this.TbSelectedTab.Browser : null;
			}
		}
		/// <summary>
		/// w肵^uWebuEU擾܂
		/// </summary>
		/// <param name="index">Ώۂ̃^ũCfbNX</param>
		/// <returns></returns>
		public WebBrowserEx TbGetBrowser(int index)
		{
			if(this.TbTabCount > 0)
			{
				return this.TbGetTab(index).Browser;
			}
			else { return null; }
		}

		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		public void TbOpenNewWindow(string URL)
		{
			this.TbOpenNewWindow(URL, this.TbTabCount, true);
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		public void TbOpenNewWindow(string URL, int tabIndex)
		{
			this.TbOpenNewWindow(URL, tabIndex, true);
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		/// <param name="focus">tH[JXڂꍇtrue</param>
		public void TbOpenNewWindow(string URL, int tabIndex, bool focus)
		{
			if(URL == null || URL == "")
			{
				URL = blankUrl;
			}
			try
			{
				Uri uri = new Uri(URL, UriKind.Absolute);
				this.TbOpenNewWindow(uri, tabIndex, focus);
			}
			catch(Exception e)
			{
				this.TbOpenNewWindow("res://ieframe.dll/syntax.htm#" + URL, tabIndex, focus);
			}
		}
		/// <summary>
		/// V^uURLJ܂
		/// </summary>
		/// <param name="URL">ǂݍURL</param>
		/// <param name="tabIndex">}̃CfbNX</param>
		/// <param name="focus">tH[JXڂꍇtrue</param>
		public void TbOpenNewWindow(Uri URL, int tabIndex, bool focus)
		{
			Match mt = Regex_DownMovieLink.Match(URL.ToString());
			if(mt.Success)
			{
				string movid = mt.Groups["movieid"].Value;
				if(movid == null) throw new Exception("URLERROR/ boon://-ɖȃAhX");
				this.OnMovieDownloadRequired(this, mt.Groups["movieid"].Value);
				return;
			}
			if(this.TbTabCount >= maxTabCount)
			{
				MessageBox.Show("^u̐𒴂܂B͖̑łB");
				return;
			}
			TabBrowserPage tb = new TabBrowserPage();

			tb.LockedChanged += new EventHandler(tb_LockedChanged);
			tb.Browser.BeforeNavigate += new EventHandler(Browser_BeforeNavigate);
			tb.Browser.BeforeNewWindow += new EventHandler(Browser_beforeNewWindow);
			tb.Browser.DocumentTitleChanged += new EventHandler(Browser_DocumentTitleChanged);
			tb.Browser.Navigated += new WebBrowserNavigatedEventHandler(Browser_Navigated);
			tb.Browser.DocumentCompleted += new WebBrowserDocumentCompletedEventHandler(Browser_documentCompleted);
			tb.Browser.StatusTextChanged += new EventHandler(Browser_StatusTextChanged);
			tb.Browser.CanGoBackChanged += new EventHandler(Browser_CanGoBackChanged);
			tb.Browser.CanGoForwardChanged += new EventHandler(Browser_CanGoForwardChanged);

			tb.Browser.Url = URL;
			this.TbAdd(tabIndex, tb);

			if(focus) { tb.Focus(); }
		}

		/// <summary>
		/// IĂuEUŕ\Ăy[ŴURL擾܂
		/// </summary>
		public string TbUrlText
		{
			get
			{
				if(this.TbSelectedIndex >= 0 && this.TbSelectedBrowser.Url != null)
				{
					return this.TbSelectedBrowser.Url.ToString();
				}
				else
				{
					return String.Empty;
				}
			}
		}
		/// <summary>
		/// IĂuEUŕ\Ăy[W̃^Cg擾܂
		/// </summary>
		public string TbTitleText
		{
			get
			{
				return this.TbSelectedIndex >= 0 ?
					this.TbSelectedBrowser.DocumentTitle : String.Empty;
			}
		}
		/// <summary>
		/// IĂuEUStatusText擾܂
		/// </summary>
		public string TbStatusText
		{
			get
			{
				return this.TbSelectedIndex >= 0 ?
				this.TbSelectedBrowser.StatusText : String.Empty;
			}
		}



		#endregion


		#region Handler

		void tb_LockedChanged(object sender, EventArgs e)
		{
			this.core.Invalidate(false);
		}

		void Browser_CanGoForwardChanged(object sender, EventArgs e)
		{
			this.OnCanGoForwardChanged(sender, e);
		}
		void Browser_CanGoBackChanged(object sender, EventArgs e)
		{
			this.OnCanGoBackChanged(sender, e);
		}
		void Browser_StatusTextChanged(object sender, EventArgs e)
		{
			this.OnStatusTextChanged(sender, e);
		}
		void Browser_DocumentTitleChanged(object sender, EventArgs e)
		{
			this.OnDocumentTitleChanged(sender, e);
		}

		void Browser_BeforeNavigate(object sender, EventArgs e)
		{
			WebBrowserExtendedNavigatingEventArgs ex = (WebBrowserExtendedNavigatingEventArgs)e;
			this.OnBeforeNavitage(sender, ex);
			if(((WebBrowserEx)sender).OwnerTabPage.IsLocked)
			{
				ex.Cancel = true;
				this.TbOpenNewWindow(ex.Url, this.TbSelectedIndex + 1, false);
			}
		}
		void Browser_Navigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			this.OnNavigated(sender, e);
		}

		void Browser_beforeNewWindow(object sender, EventArgs e)
		{
			WebBrowserExtendedNavigatingEventArgs ex = (WebBrowserExtendedNavigatingEventArgs)e;
			ex.Cancel = true;
			this.TbOpenNewWindow(ex.Url, this.TbSelectedIndex + 1);
		}
		void Browser_documentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			HtmlDocument doc__ = ((WebBrowser)sender).Document;
			doc__.Body.MouseDown += new HtmlElementEventHandler(Body_MouseDown);
			doc__.Body.MouseUp += new HtmlElementEventHandler(Body_MouseUp);
			foreach(HtmlElement link in doc__.Links)
			{
				link.MouseUp += new HtmlElementEventHandler(link_MouseUp);
				link.MouseDown += new HtmlElementEventHandler(link_MouseDown);
				link.MouseLeave += new HtmlElementEventHandler(link_MouseLeave);
			}
			this.OnDocumentCompleted(sender, e);
		}

		void Body_MouseDown(object sender, HtmlElementEventArgs e)
		{
			if(e.MouseButtonsPressed == MouseButtons.Right)
			{
				if(tmpGuesturePt == Point.Empty)
				{
					tmpGuesturePt = e.MousePosition;
				}
				else { this.tmpGuesturePt = Point.Empty; }
			}
		}
		void Body_MouseUp(object sender, HtmlElementEventArgs e)
		{
			bool guestureCalled = false;
			if(tmpGuesturePt != Point.Empty)
			{
				int mx = e.MousePosition.X - tmpGuesturePt.X;
				int my = e.MousePosition.Y - tmpGuesturePt.Y;
				if(mx >= guestureThres)
				{
					if(-guestureThres < my && my < guestureThres)
					{
						// Guesture Right
						this.TbSelectedBrowser.GoForward();
						guestureCalled = true;
					}
				}
				else if(mx <= -guestureThres)
				{
					if(-guestureThres < my && my < guestureThres)
					{
						// Guesture Left
						this.TbSelectedBrowser.GoBack();
						guestureCalled = true;
					}
				}
				else if(my <= -guestureThres)
				{
					// Guesture Up
					this.TbSelectedBrowser.Refresh();
					guestureCalled = true;
				}
				else if(my >= guestureThres)
				{
					// Guresture Down
					this.TbRemove(this.TbSelectedIndex);
					guestureCalled = true;
				}
				tmpGuesturePt = Point.Empty;
			}
			if(guestureCalled)
			{
				e.BubbleEvent = false;
			}
		}

		void link_MouseDown(object sender, HtmlElementEventArgs e)
		{
			if(e.MouseButtonsPressed == MouseButtons.Middle && frg_occs == 0)
			{
				string href_;
				string linkelem = ((HtmlElement)sender).OuterHtml;
				href_ = Regex.Match(linkelem, "href\\s*=\\s*(?:\"(?<1>[^\"]*)\"|(?<1>\\S+))", RegexOptions.IgnoreCase).Result("$1");

				if(href_ != null)
				{
					//this.TbSelectedBrowser.Navigate(b.Uri, true);

					if(href_.StartsWith("javascript:", StringComparison.CurrentCultureIgnoreCase))
					{
						// javascriptNNbN̓
					}
					else if(Uri.IsWellFormedUriString(href_, UriKind.Absolute))
					{
						Uri u_ = new Uri(href_);
						if(u_.IsAbsoluteUri)
						{
							this.TbOpenNewWindow(u_, this.TbSelectedIndex + 1, setFocusOnCenterClickOpen);
						}
					}
					else if(Uri.IsWellFormedUriString(href_, UriKind.Relative))
					{
						string urlbase = String.Empty;
						HtmlElementCollection basetag = this.TbSelectedBrowser.Document.GetElementsByTagName("base");
						if(basetag.Count > 0)
						{
							foreach(HtmlElement el in basetag)
							{
								string s = el.GetAttribute("href");
								if(s != null)
								{
									urlbase = s;
									break;
								}
							}
						}
						Uri u_;
						if(urlbase == string.Empty)
						{
							u_ = new Uri(this.TbSelectedBrowser.Url, href_);
						}
						else
						{
							u_ = new Uri(new Uri(urlbase), href_);
						}
						this.TbOpenNewWindow(u_, this.TbSelectedIndex + 1, setFocusOnCenterClickOpen);
					}
					else
					{
						MessageBox.Show("TabBrowserControl::link_MouseDown/InvalidLink");
					}
					if(this.TbSelectedBrowser.Focused)
					{
						this.Focus();
						this.TbSelectedBrowser.Focus();
					}
					SendKeys.Send("e");//AutoScroll΍
				}
				else
				{
					MessageBox.Show("Error");
				}
			}
			frg_occs = 1;
		}
		void link_MouseLeave(object sender, HtmlElementEventArgs e)
		{
			frg_occs = 0;
		}
		void link_MouseUp(object sender, HtmlElementEventArgs e)
		{
			frg_occs = 0;
		}


		#endregion


		public event EventHandler<MovieDownloadRequiredEventArgs> MovieDownloadRequired;
		/// <summary>
		/// TbSelectedIndexvpeBύXꂽɔ܂B
		/// </summary>
		public event EventHandler TbSelectedIndexChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCanGoBackChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbCanGoBackChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCanGoForwardChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbCanGoForwardChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔStatusTextChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbStatusTextChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔDocumentTitleChangedCxg`B܂B
		/// </summary>
		public event EventHandler TbDocumentTitleChanged;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔNavigatedCxg`B܂B
		/// </summary>
		public event WebBrowserNavigatedEventHandler TbNavigated;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔCxgBeforeNavigate`B܂B
		/// </summary>
		public event CancelEventHandler TbBeforeNavigate;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔDocumentCompletedCxg`B܂B
		/// </summary>
		public event WebBrowserDocumentCompletedEventHandler TbDocumentCompleted;
		/// <summary>
		/// Rg[Ɋ܂܂uEÛꂩŔProgressChangedCxg`B܂B
		/// </summary>
		public event WebBrowserProgressChangedEventHandler TbProgressChanged;

		protected void OnMovieDownloadRequired(object sender, string _movieId)
		{
			if(MovieDownloadRequired != null)
			{
				MovieDownloadRequiredEventArgs e = new MovieDownloadRequiredEventArgs(_movieId);
				MovieDownloadRequired(sender, e);
			}
		}
		protected void OnDocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
		{
			if(TbDocumentCompleted != null)
			{
				TbDocumentCompleted(sender, e);
			}
		}
		protected void OnDocumentTitleChanged(object sender, EventArgs e)
		{
			if(this.TbDocumentTitleChanged != null)
			{
				this.TbDocumentTitleChanged(sender, e);
			}
		}
		protected void OnNavigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			if(TbNavigated != null)
			{
				TbNavigated(sender, e);
			}
		}
		protected void OnBeforeNavitage(object sender, WebBrowserExtendedNavigatingEventArgs e)
		{
			Match mt = Regex_DownMovieLink.Match(e.Url);
			if(mt.Success)
			{
				e.Cancel = true;
				this.OnMovieDownloadRequired(this, mt.Groups["movieid"].Value);
				return;
			}
			if(this.TbBeforeNavigate != null)
			{
				TbBeforeNavigate(sender, e);
			}
			if(e.Cancel)
			{
				TabBrowserPage tp = ((WebBrowserEx)sender).OwnerTabPage;
				if(tp.Browser.Url == null)
				{
					this.TbRemove(tp);
					tp.Dispose();
				}
			}
		}
		protected void OnProgressChanged(object sender, WebBrowserProgressChangedEventArgs e)
		{
			if(this.TbProgressChanged != null)
			{
				TbProgressChanged(sender, e);
			}
		}
		protected void OnStatusTextChanged(object sender, EventArgs e)
		{
			if(TbStatusTextChanged != null)
			{
				TbStatusTextChanged(sender, e);
			}
		}
		protected void OnCanGoBackChanged(object sender, EventArgs e)
		{
			if(this.TbCanGoBackChanged != null)
			{
				this.TbCanGoBackChanged(sender, e);
			}
		}
		protected void OnCanGoForwardChanged(object sender, EventArgs e)
		{
			if(this.TbCanGoForwardChanged != null)
			{
				this.TbCanGoForwardChanged(sender, e);
			}
		}
		protected void OnSelectedIndexChanged(object sender, EventArgs e)
		{
			if(this.TbSelectedIndexChanged != null)
			{
				this.TbSelectedIndexChanged(sender, e);
			}
		}


		#region contextMenuStrip100֘A


		private void toolStripMenuItem101_CloseTab_Click(object sender, EventArgs e)
		{
			this.TbRemove(this.ContextMenuTargetTab);
		}
		private void toolStripMenuItem102_CloseAllTabs_Click(object sender, EventArgs e)
		{
			this.TbClear(false);
		}
		private void toolStripMenuItem103_OpenNewTab_Click(object sender, EventArgs e)
		{
			this.TbOpenNewWindow("about:blank");
		}
		private void toolStripMenuItem104_Refresh_Click(object sender, EventArgs e)
		{
			this.TbSelectedBrowser.Refresh();
		}
		private void toolStripMenuItem105_RefreshAllLockedTabs_Click(object sender, EventArgs e)
		{
			for(int i = 0; i < TbTabCount; i++)
			{
				if(this.TbGetTab(i).IsLocked)
				{
					this.TbGetTab(i).IsLocked = false;
					this.TbGetBrowser(i).Refresh();
					this.TbGetTab(i).IsLocked = true;
				}
			}
		}
		private void toolStripMenuItem106_RefreshAllTabs_Click(object sender, EventArgs e)
		{
			int tooMuchTabs = 3;
			if(this.TbTabCount >= tooMuchTabs)
			{
				if(MessageBox.Show("\̃^uxɍXV悤ƂĂ܂B\n̑͑傫ȕׂSz܂B\n\n{Ɏs܂H"
				, "\ׂ̂Ẵ^u̍XV", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning)
					== DialogResult.Cancel)
				{
					return;
				}
			}
			for(int i = 0; i < this.TbTabCount; i++)
			{
				this.TbSelectedBrowser.Refresh();
			}
		}
		private void toolStripMenuItem107_LockThisTab_Click(object sender, EventArgs e)
		{
			this.TbGetTab(this.ContextMenuTargetTab).IsLocked = !this.TbGetTab(this.ContextMenuTargetTab).IsLocked;
		}
		private void toolStripMenuItem108_CopyTitleAndUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(
				this.TbGetBrowser(this.ContextMenuTargetTab).DocumentTitle
				+ "\n" +
				this.TbGetBrowser(this.ContextMenuTargetTab).Url.ToString());
		}
		private void toolStripMenuItem109_CopyTitle_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.TbGetBrowser(this.ContextMenuTargetTab).DocumentTitle);
		}
		private void toolStripMenuItem110_CopyUrl_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(this.TbGetBrowser(this.ContextMenuTargetTab).Url.ToString());
		}

		// ----------------- MenuField ------------------------ //

		private System.Windows.Forms.ContextMenuStrip contextMenuStrip100_ForTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem101_CloseTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem102_CloseAllTabs;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator101;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_OpenNewTab;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_TabPageList;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator102;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem104_Refresh;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem105_RefreshAllLockedTabs;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem106_RefreshAllTabs;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator103;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem107_LockThisTab;
		private System.Windows.Forms.ToolStripSeparator toolStripSeparator104;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem108_CopyTitleAndUrl;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem109_CopyTitle;
		private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem110_CopyUrl;

		private void initializeContext()
		{
			this.contextMenuStrip100_ForTab = new System.Windows.Forms.ContextMenuStrip();
			this.toolStripMenuItem101_CloseTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem102_CloseAllTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator101 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem103_OpenNewTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem103_TabPageList = new ToolStripMenuItem();
			this.toolStripSeparator102 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem104_Refresh = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem105_RefreshAllLockedTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem106_RefreshAllTabs = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator103 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem107_LockThisTab = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator104 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripMenuItem108_CopyTitleAndUrl = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem109_CopyTitle = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem110_CopyUrl = new System.Windows.Forms.ToolStripMenuItem();
			// 
			// contextMenuStrip100_ForTab
			// 
			this.contextMenuStrip100_ForTab.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripMenuItem101_CloseTab,
            this.toolStripMenuItem102_CloseAllTabs,
            this.toolStripSeparator101,
            this.toolStripMenuItem103_OpenNewTab,
				this.toolStripMenuItem103_TabPageList,
            this.toolStripSeparator102,
            this.toolStripMenuItem104_Refresh,
            this.toolStripMenuItem105_RefreshAllLockedTabs,
            this.toolStripMenuItem106_RefreshAllTabs,
            this.toolStripSeparator103,
            this.toolStripMenuItem107_LockThisTab,
            this.toolStripSeparator104,
            this.toolStripMenuItem108_CopyTitleAndUrl,
            this.toolStripMenuItem109_CopyTitle,
            this.toolStripMenuItem110_CopyUrl});
			this.contextMenuStrip100_ForTab.Name = "contextMenuStrip100_ForTab";
			this.contextMenuStrip100_ForTab.Size = new System.Drawing.Size(261, 248);
			this.contextMenuStrip100_ForTab.Opening += new CancelEventHandler(contextMenuStrip100_ForTab_Opening);
			// 
			// toolStripMenuItem101_CloseTab
			// 
			this.toolStripMenuItem101_CloseTab.Name = "toolStripMenuItem101_CloseTab";
			this.toolStripMenuItem101_CloseTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
			this.toolStripMenuItem101_CloseTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem101_CloseTab.Text = "(&C)";
			this.toolStripMenuItem101_CloseTab.Click += new System.EventHandler(this.toolStripMenuItem101_CloseTab_Click);
			// 
			// toolStripMenuItem102_CloseAllTabs
			// 
			this.toolStripMenuItem102_CloseAllTabs.Name = "toolStripMenuItem102_CloseAllTabs";
			this.toolStripMenuItem102_CloseAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
			this.toolStripMenuItem102_CloseAllTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem102_CloseAllTabs.Text = "ׂẴ^u(&A)";
			this.toolStripMenuItem102_CloseAllTabs.Click += new System.EventHandler(this.toolStripMenuItem102_CloseAllTabs_Click);
			// 
			// toolStripSeparator101
			// 
			this.toolStripSeparator101.Name = "toolStripSeparator101";
			this.toolStripSeparator101.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem103_OpenNewTab
			// 
			this.toolStripMenuItem103_OpenNewTab.Name = "toolStripMenuItem103_OpenNewTab";
			this.toolStripMenuItem103_OpenNewTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
			this.toolStripMenuItem103_OpenNewTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem103_OpenNewTab.Text = "V^uJ(&N)";
			this.toolStripMenuItem103_OpenNewTab.Click += new System.EventHandler(this.toolStripMenuItem103_OpenNewTab_Click);
			//
			// toolStripMenuItem103_TabPageList
			//
			this.toolStripMenuItem103_TabPageList.Name = "toolStripMenuItem103_TabPageList";
			this.toolStripMenuItem103_TabPageList.Size = new Size(260, 22);
			this.toolStripMenuItem103_TabPageList.Text = "JĂ^üꗗ";
			// 
			// toolStripSeparator102
			// 
			this.toolStripSeparator102.Name = "toolStripSeparator102";
			this.toolStripSeparator102.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem104_Refresh
			// 
			this.toolStripMenuItem104_Refresh.Name = "toolStripMenuItem104_Refresh";
			this.toolStripMenuItem104_Refresh.ShortcutKeys = System.Windows.Forms.Keys.F5;
			this.toolStripMenuItem104_Refresh.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem104_Refresh.Text = "ŐV̏ɍXV(&R)";
			this.toolStripMenuItem104_Refresh.Click += new System.EventHandler(this.toolStripMenuItem104_Refresh_Click);
			// 
			// toolStripMenuItem105_RefreshAllLockedTabs
			// 
			this.toolStripMenuItem105_RefreshAllLockedTabs.Name = "toolStripMenuItem105_RefreshAllLockedTabs";
			this.toolStripMenuItem105_RefreshAllLockedTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.F5)));
			this.toolStripMenuItem105_RefreshAllLockedTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem105_RefreshAllLockedTabs.Text = "ׂẴbN^uXV(&O)";
			this.toolStripMenuItem105_RefreshAllLockedTabs.Click += new System.EventHandler(this.toolStripMenuItem105_RefreshAllLockedTabs_Click);
			// 
			// toolStripMenuItem106_RefreshAllTabs
			// 
			this.toolStripMenuItem106_RefreshAllTabs.Name = "toolStripMenuItem106_RefreshAllTabs";
			this.toolStripMenuItem106_RefreshAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Shift)
						| System.Windows.Forms.Keys.F5)));
			this.toolStripMenuItem106_RefreshAllTabs.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem106_RefreshAllTabs.Text = "ׂẴ^uXV(&E)";
			this.toolStripMenuItem106_RefreshAllTabs.Click += new System.EventHandler(this.toolStripMenuItem106_RefreshAllTabs_Click);
			// 
			// toolStripSeparator103
			// 
			this.toolStripSeparator103.Name = "toolStripSeparator103";
			this.toolStripSeparator103.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem107_LockThisTab
			// 
			this.toolStripMenuItem107_LockThisTab.Name = "toolStripMenuItem107_LockThisTab";
			this.toolStripMenuItem107_LockThisTab.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem107_LockThisTab.Text = "̃^ubN(&L)";
			this.toolStripMenuItem107_LockThisTab.Click += new System.EventHandler(this.toolStripMenuItem107_LockThisTab_Click);
			// 
			// toolStripSeparator104
			// 
			this.toolStripSeparator104.Name = "toolStripSeparator104";
			this.toolStripSeparator104.Size = new System.Drawing.Size(257, 6);
			// 
			// toolStripMenuItem108_CopyTitleAndUrl
			// 
			this.toolStripMenuItem108_CopyTitleAndUrl.Name = "toolStripMenuItem108_CopyTitleAndUrl";
			this.toolStripMenuItem108_CopyTitleAndUrl.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem108_CopyTitleAndUrl.Text = "^CgURLRs[(&B)";
			this.toolStripMenuItem108_CopyTitleAndUrl.Click += new System.EventHandler(this.toolStripMenuItem108_CopyTitleAndUrl_Click);
			// 
			// toolStripMenuItem109_CopyTitle
			// 
			this.toolStripMenuItem109_CopyTitle.Name = "toolStripMenuItem109_CopyTitle";
			this.toolStripMenuItem109_CopyTitle.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem109_CopyTitle.Text = "^CgRs[(&T)";
			this.toolStripMenuItem109_CopyTitle.Click += new System.EventHandler(this.toolStripMenuItem109_CopyTitle_Click);
			// 
			// toolStripMenuItem110_CopyUrl
			// 
			this.toolStripMenuItem110_CopyUrl.Name = "toolStripMenuItem110_CopyUrl";
			this.toolStripMenuItem110_CopyUrl.Size = new System.Drawing.Size(260, 22);
			this.toolStripMenuItem110_CopyUrl.Text = "URLRs[(&U)";
			this.toolStripMenuItem110_CopyUrl.Click += new System.EventHandler(this.toolStripMenuItem110_CopyUrl_Click);

		}

		void contextMenuStrip100_ForTab_Opening(object sender, CancelEventArgs e)
		{
			if(0 <= this.ContextMenuTargetTab && this.ContextMenuTargetTab < this.TbTabCount)
			{
				this.toolStripMenuItem107_LockThisTab.Checked = this.TbGetTab(this.ContextMenuTargetTab).IsLocked;
			}
			this.get_PageListMenu(this.toolStripMenuItem103_TabPageList.DropDownItems, true);
		}

		#endregion

		#region contextPageList

		private ContextMenuStrip ctxMenuPageList;
		private ToolStripMenuItem tsmiPageListOpenNewTab;
		private List<ToolStripMenuItem> tsmiPageLists;
		private ToolStripSeparator tsctxmenuSeparate1 = new ToolStripSeparator();
		private ToolStripSeparator tsctxmenuSeparate2 = new ToolStripSeparator();

		private void initializePageList()
		{
			this.ctxMenuPageList = new ContextMenuStrip();
			this.tsctxmenuSeparate1 = new ToolStripSeparator();
			this.tsctxmenuSeparate2 = new ToolStripSeparator();
			this.tsctxmenuSeparate1.Name = "-1";
			this.tsctxmenuSeparate2.Name = "-1";

			this.ctxMenuPageList.ItemClicked += new ToolStripItemClickedEventHandler(ctxMenuPageList_ItemClicked);
			this.ctxMenuPageList.Opening += new CancelEventHandler(ctxMenuPageList_Opening);
			this.tsmiPageLists = new List<ToolStripMenuItem>(32);
			for(int i = 0; i < this.maxTabCount; i++)
			{
				tsmiPageLists.Add(new ToolStripMenuItem());
				tsmiPageLists[i].Name = i.ToString();
			}
			this.tsmiPageListOpenNewTab = new ToolStripMenuItem();
			tsmiPageListOpenNewTab.Text = "V^uJ";
			tsmiPageListOpenNewTab.Name = "-10";
			tsmiPageListOpenNewTab.Image = Browser.Properties.Resources.document.ToBitmap();
			tsmiPageListOpenNewTab.ShowShortcutKeys = true;
		}
		/// <summary>
		/// \̃y[Wꗗ擾
		/// </summary>
		/// <param name="target_"></param>
		/// <param name="useTitle_"></param>
		private void get_PageListMenu(ToolStripItemCollection target_, bool useTitle_)
		{
			for(int i = 0; i < this.TbTabCount; i++)
			{
				tsmiPageLists[i].Text =
					useTitle_ ? this.TbGetBrowser(i).DocumentTitle : this.TbGetBrowser(i).Url.ToString();
				tsmiPageLists[i].Checked = this.TbSelectedIndex == i;
				target_.Add(tsmiPageLists[i]);
			}
		}

		void ctxMenuPageList_Opening(object sender, CancelEventArgs e)
		{
			bool useTitle_ = true;
			this.ctxMenuPageList.Items.Clear();
			this.ctxMenuPageList.Items.Add(tsmiPageListOpenNewTab);
			this.ctxMenuPageList.Items.Add(tsctxmenuSeparate1);
			this.get_PageListMenu(this.ctxMenuPageList.Items, useTitle_);
		}

		void ctxMenuPageList_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int tgt = Int32.Parse(e.ClickedItem.Name);
			if(0 <= tgt && tgt < this.TbTabCount)
			{
				this.TbSelectedIndex = tgt;
			}
			else if(tgt == -10)
			{
				this.TbOpenNewWindow(blankUrl);
			}
		}

		#endregion



		#region LatestClosedTabHistory֘A

		ContextMenuStrip ctxCloseHistory;
		ToolStripMenuItem tsmiCloseHistoryHeader;
		List<ToolStripMenuItem> tsmiCloseHistory;
		List<KeyValuePair<string, string>> closedTabHistory;

		/// <summary>
		/// ŋߕ^ũ^CgURL擾܂B
		/// </summary>
		/// <param name="offset">Ōɕ^u0Ƃ̒l</param>
		/// <returns>KeyɃ^CgAValueUrlPair</returns>
		public KeyValuePair<string, string> GetRecentClosed(int offset)
		{
			if(0 <= offset && this.closedTabHistory.Count < offset)
			{
				return this.closedTabHistory[offset];
			}
			else
			{
				throw new ArgumentException("TabBrowser::GetRecentClosed̈sł");
			}
		}
		/// <summary>
		/// 
		/// </summary>
		public int RecentclosedTabCount
		{
			get { return this.closedTabHistory.Count; }
		}

		private void initiaizeClosedHistory()
		{
			this.closedTabHistory = new List<KeyValuePair<string, string>>(maxClosedTabHistory);
			this.ctxCloseHistory = new ContextMenuStrip();
			this.ctxCloseHistory.ShowItemToolTips = true;

			this.tsmiCloseHistoryHeader = new ToolStripMenuItem();
			this.tsmiCloseHistoryHeader.Text = "ŋߕ^üꗗ";
			this.tsmiCloseHistoryHeader.Enabled = false;

			this.tsmiCloseHistory = new List<ToolStripMenuItem>(maxClosedTabHistory);
			for(int i = 0; i < this.tsmiCloseHistory.Capacity; i++)
			{
				ToolStripMenuItem mn = new ToolStripMenuItem();
				mn.Name = i.ToString();
				this.tsmiCloseHistory.Add(mn);
			}
			this.ctxCloseHistory.Opening += new CancelEventHandler(ctxCloseHistory_Opening);
			this.ctxCloseHistory.ItemClicked += new ToolStripItemClickedEventHandler(ctxCloseHistory_ItemClicked);
		}

		void ctxCloseHistory_Opening(object sender, CancelEventArgs e)
		{
			this.ctxCloseHistory.Items.Clear();
			this.ctxCloseHistory.Items.Add(tsmiCloseHistoryHeader);
			this.ctxCloseHistory.Items.Add(tsctxmenuSeparate2);
			for(int i = 0; i < this.closedTabHistory.Count; i++)
			{
				this.tsmiCloseHistory[i].Text = closedTabHistory[i].Key;
				this.tsmiCloseHistory[i].ToolTipText = closedTabHistory[i].Value;
				this.ctxCloseHistory.Items.Add(this.tsmiCloseHistory[i]);
			}
		}

		void ctxCloseHistory_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int tgt = Int32.Parse(e.ClickedItem.Name);
			if(tgt >= 0)
			{
				this.TbOpenNewWindow(this.closedTabHistory[tgt].Value);
				this.closedTabHistory.RemoveAt(tgt);
			}
		}

		private void set_ClosedTabHistory(string _title, string _url)
		{
			if(this.closedTabHistory.Count == this.closedTabHistory.Capacity)
			{
				this.closedTabHistory.RemoveAt(this.closedTabHistory.Count - 1);
			}
			this.closedTabHistory.Insert(0, new KeyValuePair<string, string>(_title, _url));
		}
		private void remove_LatestClosedTabHistory()
		{
			this.closedTabHistory.RemoveAt(0);
		}
		private string get_LatestClosedTabHistory()
		{
			if(this.closedTabHistory.Count > 0)
			{
				return this.closedTabHistory[0].Value;
			}
			else { return String.Empty; }
		}

		#endregion

	}

	// ********************  TabBrowserControl ܂  *************************** //

	public class MovieDownloadRequiredEventArgs : EventArgs
	{
		string movieid;
		public string MovieID
		{
			get { return this.movieid; }
		}
		public MovieDownloadRequiredEventArgs(string _movieId)
			: base()
		{
			this.movieid = _movieId;
		}
	}

	/// <summary>
	/// TabBrowserControlׂ̈ɊgꂽTabPageł
	/// </summary>
	public class TabBrowserPage : TabPage
	{
		WebBrowserEx browser;
		/// <summary>
		/// ̃y[WjꂽɃuEU
		/// </summary>
		public bool KeepBrowserInstance = false;
		private bool isLocked = false;
		/// <summary>
		/// ̃^ũbNԂ擾ݒ肵܂
		/// </summary>
		public bool IsLocked
		{
			get { return this.isLocked; }
			set
			{
				this.isLocked = value;
				this.OnLockedChanged(this, new EventArgs());
			}
		}

		/// <summary>
		/// TabBrowserControlׂ̈ɊgꂽTabPageł
		/// </summary>
		public TabBrowserPage()
		{
			this.browser = new WebBrowserEx(this);
			this.Width = 200;
			this.Margin = new Padding(0);
			this.Padding = new Padding(0);
			this.BorderStyle = BorderStyle.None;
			browser.Dock = System.Windows.Forms.DockStyle.Fill;
			browser.MinimumSize = new System.Drawing.Size(20, 20);
			this.browser.DocumentTitleChanged += new EventHandler(browser_DocumentTitleChanged);
			this.Controls.Add(browser);
			this.Font = new Font("MS UI Gothic", 10f, FontStyle.Regular);
		}

		void browser_DocumentTitleChanged(object sender, EventArgs e)
		{
			if(this.browser.DocumentTitle != "")
			{
				this.Text = this.browser.DocumentTitle;
				if(true)
				{
					this.Text = Regex.Replace(this.Text, "(\\S+)]jRjR\\(\\)$", "$1", RegexOptions.IgnoreCase);
				}
			}
			else
			{
				this.Text = this.browser.Url.ToString();
			}
			this.ToolTipText = this.browser.DocumentTitle;
		}

		/// <summary>
		/// ̃y[W̃uEU擾܂
		/// </summary>
		public WebBrowserEx Browser
		{
			get { return this.browser; }
		}

		protected override void Dispose(bool disposing)
		{
			if(this.browser.Created)
			{
				this.browser.Dispose();
				Debug.WriteLine("browser.Disposed");
			}
			base.Dispose(disposing);
		}
		/// <summary>
		/// ^ũbNԂύXꂽƂɔ܂
		/// </summary>
		public event EventHandler LockedChanged;
		public void OnLockedChanged(object sender, EventArgs e)
		{
			if(LockedChanged != null)
			{
				LockedChanged(sender, e);
				this.ImageIndex = IsLocked ? 1 : -1;
			}
		}

	}

	/// <summary>
	/// 
	/// </summary>
	public class TabBrowserSetting
	{
		string homeUrl;

		bool titleDeleteUse;
		string titleDeleteStr;

		string browserPath;
		bool browserDefault;
		bool urlCheckUse;
		string[] urlCheckMatch;

		bool proxyUse;
		string proxyUrl;
		string proxyBypass;
		int proxyPort;

		TB_LockedTabBehavior lockedTabBehavior;
	}
	/// <summary>
	/// 
	/// </summary>
	public class TabBrowserSession
	{
		public TravelLogEntry[] BackHistory;
		public TravelLogEntry[] ForeHistory;
		public TravelLogEntry Current;

		public TabBrowserSession(WebBrowserEx browser)
		{
		}
	}
	/// <summary>
	/// 
	/// </summary>
	public enum TB_LockedTabBehavior : byte
	{
		AsNotLocked = 0x0,
		OpenNewOnNavigate = 0x1,
		IgnoreClose = 0x2,
		ReloadOnThis = 0x4,
		ForeBackOnThis = 0x8,

		BoonConpatible = 0x7,

	}

}
