using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace WindowsApplication1
{
    [Serializable()]
    [XmlRoot("AvP[V̐ݒ")]
    public class SampleSettings
    {
        // VACYƂ͊֌WȂǐݒ荀ڂ̊lƂ
        private static class Default
        {
            public const int Number1 = 20;
            public const int Number2 = 40;
            public const string String1 = "Tv";
            public const string String2 = "Ղ";
        }

        private int _number1;
        private int _number2;
        private string _string1;
        private string _string2;
        private SampleListItem[] _list;

        private int _temp1 = 666;
        private string _temp2 = "VACY֎~";


        public SampleSettings()
        {
            _number1 = Default.Number1;
            _number2 = Default.Number2;
            _string1 = Default.String1;
            _string2 = Default.String2;

            _list = new SampleListItem[5];
            _list[0] = new SampleListItem(); _list[0].Name = "ACeP"; _list[0].Value1 = "A"; _list[0].Value2 = "B";
            _list[1] = new SampleListItem(); _list[1].Name = "ACeQ"; _list[1].Value1 = "C"; _list[1].Value2 = "D";
            _list[2] = new SampleListItem(); _list[2].Name = "ACeR"; _list[2].Value1 = "E"; _list[2].Value2 = "F";
            _list[3] = new SampleListItem(); _list[3].Name = "ACeS"; _list[3].Value1 = "G"; _list[3].Value2 = "H";
            _list[4] = new SampleListItem(); _list[4].Name = "ACeT"; _list[4].Value1 = "I"; _list[4].Value2 = "J";
        }

        // l^ null ƂȂ̂ IsNullable  true ɂł܂
        [XmlElement(ElementName = "l1", IsNullable = false)]
        public int Number1
        {
            get { return _number1; }
            set { _number1 = value; }
        }

        [XmlElement(ElementName = "l2", IsNullable = false)]
        public int Number2
        {
            get { return _number2; }
            set { _number2 = value; }
        }

        [XmlElement(ElementName = "1", IsNullable = false)]
        public string String1
        {
            get { return _string1; }
            set { _string1 = value; }
        }

        [XmlElement(ElementName = "2", IsNullable = true)]
        public string String2
        {
            get { return _string2; }
            set { _string2 = value; }
        }

        [XmlElement(ElementName = "Xg", IsNullable = true)]
        public SampleListItem[] List
        {
            get { return _list; }
            set { _list = value; }
        }

        // fVACYƂXMLɖm̍ڂƂ͂ɓ
        [XmlAnyElement()]
        public XmlElement[] Any;

        // VACY֎~
        [XmlIgnore()]
        public int Temp1
        {
            get { return _temp1; }
            set { _temp1 = value; }
        }

        // VACY֎~
        [XmlIgnore()]
        public string Temp2
        {
            get { return _temp2; }
            set { _temp2 = value; }
        }


        [Serializable()]
        public class SampleListItem
        {
            private string _name;
            private string _value1;
            private string _value2;

            [XmlElement(ElementName = "O", IsNullable = false)]
            public string Name
            {
                get { return _name; }
                set { _name = value; }
            }

            [XmlElement(ElementName = "l1", IsNullable = true)]
            public string Value1
            {
                get { return _value1; }
                set { _value1 = value; }
            }

            [XmlElement(ElementName = "l2", IsNullable = true)]
            public string Value2
            {
                get { return _value2; }
                set { _value2 = value; }
            }
        }
    }
}
