using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        private SampleSettings _settings = new SampleSettings();

        public Form1()
        {
            InitializeComponent();
            ShowSettings();
        }

        private void btnSerialize_Click(object sender, EventArgs e)
        {
            _settings.Number1 = int.Parse(txtNumber1.Text);
            _settings.Number2 = int.Parse(txtNumber2.Text);
            _settings.String1 = txtString1.Text;
            _settings.String2 = txtString2.Text;

            for (int i = 0; i < listItems.Items.Count; i++)
            {
                ListViewItem item = listItems.Items[i];
                _settings.List[i].Name = item.Text;
                _settings.List[i].Value1 = item.SubItems[1].Text;
                _settings.List[i].Value2 = item.SubItems[2].Text;
            }

            XmlSerializer serializer = new XmlSerializer(typeof(SampleSettings), new XmlRootAttribute("AvP[V̐ݒ"));
            FileStream stream = new FileStream(Application.StartupPath + "\\settings.xml", FileMode.Create);
            serializer.Serialize(stream, _settings);
            stream.Close();

            MessageBox.Show(Application.StartupPath + "\\settings.xml ֕ۑ܂");
        }

        private void btnDeserialize_Click(object sender, EventArgs e)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(SampleSettings), new XmlRootAttribute("AvP[V̐ݒ"));
            FileStream stream = new FileStream(Application.StartupPath + "\\settings.xml", FileMode.Open);
            SampleSettings response = (SampleSettings)serializer.Deserialize(stream);
            stream.Close();

            ShowSettings();
        }

        private void ShowSettings()
        {
            txtNumber1.Text = _settings.Number1.ToString();
            txtNumber2.Text = _settings.Number2.ToString();
            txtString1.Text = _settings.String1;
            txtString2.Text = _settings.String2;

            listItems.Items.Clear();
            for (int i = 0; i < _settings.List.Length; i++)
            {
                ListViewItem item = listItems.Items.Add(_settings.List[i].Name);
                item.SubItems.Add(_settings.List[i].Value1);
                item.SubItems.Add(_settings.List[i].Value2);
            }
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            listItems.Items.Clear();
        }
    }
}