#ifndef CARD_READER_H
#define CARD_READER_H

#include <winscard.h>
#include <dshow.h>
#include "BonBaseClass.h"


// J[h[_[NX
class __declspec(novtable) CCardReader : public CBonBaseClass
{
public:
	enum ReaderType {
		READER_NONE,
		READER_SCARD,
		READER_SCARD_DYNAMIC,
#ifdef ONLY_WINSCARD_DYNLINK
		READER_LAST=READER_SCARD_DYNAMIC
#else
		READER_BONCASCLIENT,
		READER_HDUS,
		READER_LAST=READER_HDUS
#endif
	};

	CCardReader();
	virtual ~CCardReader();
	virtual bool Open(LPCTSTR pszReader=NULL)=0;
	virtual void Close()=0;
	virtual LPCTSTR GetReaderName() const=0;
	virtual int NumReaders() const { return 1; }
	virtual LPCTSTR EnumReader(int Index) const;
	ReaderType GetReaderType() const { return m_ReaderType; }
	virtual bool Transmit(const void *pSendData,DWORD SendSize,void *pRecvData,DWORD *pRecvSize)=0;
	static CCardReader *CreateCardReader(ReaderType Type);

private:
	ReaderType m_ReaderType;
};

#ifndef ONLY_WINSCARD_DYNLINK

// X}[gJ[h[_[(X^eBbNN)
class CSCardReader : public CCardReader
{
	SCARDCONTEXT m_ScardContext;
	SCARDHANDLE m_hSCard;
	bool m_bIsEstablish;
	LPTSTR m_pReaderList;
	int m_NumReaders;
	LPTSTR m_pszReaderName;

public:
	CSCardReader();
	~CSCardReader();
	bool Open(LPCTSTR pszReader);
	void Close();
	LPCTSTR GetReaderName() const;
	int NumReaders() const;
	LPCTSTR EnumReader(int Index) const;
	bool Transmit(const void *pSendData,DWORD SendSize,void *pRecvData,DWORD *pRecvSize);
};

#endif

// X}[gJ[h[_[(_Ci~bNN)
// 킴킴X^eBbNNƕĂ̂́ABonCasLinko[Wɂ
// X^eBbNNłȂΗpłȂ
class CDynamicSCardReader : public CCardReader
{
	HMODULE m_hLib;
	SCARDCONTEXT m_ScardContext;
	SCARDHANDLE m_hSCard;
	LPTSTR m_pReaderList;
	LPTSTR m_pszReaderName;
	typedef LONG (WINAPI *SCardTransmitFunc)(SCARDHANDLE,LPCSCARD_IO_REQUEST,LPCBYTE,
											 DWORD,LPSCARD_IO_REQUEST,LPBYTE,LPDWORD);
	SCardTransmitFunc m_pSCardTransmit;
	LPSCARD_IO_REQUEST m_prgSCardT1Pci;

	bool Load(LPCTSTR pszFileName);

public:
	CDynamicSCardReader();
	~CDynamicSCardReader();
	bool Open(LPCTSTR pszReader);
	void Close();
	LPCTSTR GetReaderName() const;
	int NumReaders() const;
	LPCTSTR EnumReader(int Index) const;
	bool Transmit(const void *pSendData,DWORD SendSize,void *pRecvData,DWORD *pRecvSize);
};

#ifndef ONLY_WINSCARD_DYNLINK

// BonCasClient
class CBonCasClientCardReader : public CCardReader
{
	HMODULE m_hLib;
	SCARDCONTEXT m_ScardContext;
	SCARDHANDLE m_hSCard;
	LPTSTR m_pReaderList;
	LPTSTR m_pszReaderName;
	typedef LONG (WINAPI *CasLinkTransmitFunc)(SCARDHANDLE,LPCSCARD_IO_REQUEST,LPCBYTE,
											   DWORD,LPSCARD_IO_REQUEST,LPBYTE,LPDWORD);
	CasLinkTransmitFunc m_pCasLinkTransmit;

	HMODULE Load(LPCTSTR pszFileName);
	bool Connect(LPCTSTR pszReader);

public:
	CBonCasClientCardReader();
	~CBonCasClientCardReader();
	bool Open(LPCTSTR pszReader);
	void Close();
	LPCTSTR GetReaderName() const;
	int NumReaders() const;
	LPCTSTR EnumReader(int Index) const;
	bool Transmit(const void *pSendData,DWORD SendSize,void *pRecvData,DWORD *pRecvSize);
};

// HDUSJ[h[_[
class CHdusCardReader : public CCardReader
{
	IBaseFilter *m_pTuner;
	bool m_bSent;

	IBaseFilter *FindDevice(REFCLSID category,BSTR varFriendlyName);
	HRESULT Send(const void *pSendData,DWORD SendSize);
	HRESULT Receive(void *pRecvData,DWORD *pRecvSize);

public:
	CHdusCardReader();
	~CHdusCardReader();
	bool Open(LPCTSTR pszReader);
	void Close();
	LPCTSTR GetReaderName() const;
	bool Transmit(const void *pSendData,DWORD SendSize,void *pRecvData,DWORD *pRecvSize);
};

#endif


#endif
